/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.util;

import java.net.URISyntaxException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.util.QuotedUriSyntaxException;

@NotThreadSafe
public final class UriDecoder {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final CharsetDecoder decoder;
    @CheckForNull
    private StringBuilder stringBuilder;

    public UriDecoder() {
        this(null);
    }

    public UriDecoder(@CheckForNull Charset charset) {
        if (null == charset) {
            charset = UTF8;
        }
        this.decoder = charset.newDecoder();
    }

    private static int dequote(CharBuffer charBuffer) {
        if (charBuffer.hasRemaining()) {
            char c2 = charBuffer.get();
            if (charBuffer.hasRemaining()) {
                char c3 = charBuffer.get();
                return UriDecoder.dequote(c2) << 4 | UriDecoder.dequote(c3);
            }
        }
        return -1;
    }

    private static int dequote(char c2) {
        if ('0' <= c2 && c2 <= '9') {
            return c2 - 48;
        }
        if ('A' <= (c2 = (char)(c2 & 0xFFFFFFDF)) && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        return -1;
    }

    public String decode(String string) {
        try {
            StringBuilder stringBuilder = this.decode(string, null);
            return null != stringBuilder ? stringBuilder.toString() : string;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
    }

    @CheckForNull
    public StringBuilder decode(String string, @CheckForNull StringBuilder stringBuilder) throws URISyntaxException {
        CharBuffer charBuffer = CharBuffer.wrap(string);
        Buffer buffer = null;
        CharBuffer charBuffer2 = null;
        CharsetDecoder charsetDecoder = null;
        while (true) {
            int n2;
            charBuffer.mark();
            int n3 = n2 = charBuffer.hasRemaining() ? (int)charBuffer.get() : -1;
            if (37 == n2) {
                int n4;
                if (null == buffer) {
                    if (null == stringBuilder) {
                        stringBuilder = this.stringBuilder;
                        if (null == stringBuilder) {
                            stringBuilder = this.stringBuilder = new StringBuilder();
                        } else {
                            stringBuilder.setLength(0);
                        }
                        stringBuilder.append(string, 0, charBuffer.position() - 1);
                    }
                    n4 = charBuffer.remaining();
                    n4 = (n4 + 1) / 3;
                    buffer = ByteBuffer.allocate(n4);
                    charBuffer2 = CharBuffer.allocate(n4);
                    charsetDecoder = this.decoder;
                }
                if ((n4 = UriDecoder.dequote(charBuffer)) < 0) {
                    throw new URISyntaxException(string, "illegal escape sequence", charBuffer.reset().position());
                }
                ((ByteBuffer)buffer).put((byte)n4);
                continue;
            }
            if (null != buffer && 0 < buffer.position()) {
                ((ByteBuffer)buffer).flip();
                CoderResult coderResult = charsetDecoder.reset().decode((ByteBuffer)buffer, charBuffer2, true);
                if (CoderResult.UNDERFLOW != coderResult || CoderResult.UNDERFLOW != (coderResult = charsetDecoder.flush(charBuffer2))) {
                    assert (CoderResult.OVERFLOW != coderResult);
                    throw new QuotedUriSyntaxException((Object)string, coderResult.toString());
                }
                ((ByteBuffer)buffer).clear();
                charBuffer2.flip();
                stringBuilder.append(charBuffer2);
                charBuffer2.clear();
            }
            if (0 > n2) break;
            if (null == stringBuilder) continue;
            stringBuilder.append((char)n2);
        }
        return null == buffer ? null : stringBuilder;
    }
}

