/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.util;

import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.util.QuotedUriSyntaxException;

@NotThreadSafe
public final class UriEncoder {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String ALPHANUM_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final String MARK_CHARS = "-_.!~*'()";
    private static final String DEFAULT_LEGAL_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-_.!~*'(),;$&+=@";
    private final CharsetEncoder encoder;
    private final boolean encode;
    private final boolean raw;
    @CheckForNull
    private StringBuilder stringBuilder;

    public UriEncoder() {
        this(UTF8, false);
    }

    public UriEncoder(boolean bl2) {
        this(UTF8, bl2);
    }

    public UriEncoder(@CheckForNull Charset charset) {
        this(charset, false);
    }

    public UriEncoder(@CheckForNull Charset charset, boolean bl2) {
        this.encode = null != charset;
        if (!this.encode) {
            charset = UTF8;
        }
        this.encoder = charset.newEncoder();
        this.raw = bl2;
    }

    boolean isRaw() {
        return this.raw;
    }

    private static void quote(char c2, StringBuilder stringBuilder) {
        UriEncoder.quote(UTF8.encode(CharBuffer.wrap(Character.toString(c2))), stringBuilder);
    }

    private static void quote(ByteBuffer byteBuffer, StringBuilder stringBuilder) {
        while (byteBuffer.hasRemaining()) {
            byte by2 = byteBuffer.get();
            stringBuilder.append('%');
            stringBuilder.append(HEX[by2 >> 4 & 0xF]);
            stringBuilder.append(HEX[by2 & 0xF]);
        }
    }

    public String encode(String string, Encoding encoding) {
        try {
            StringBuilder stringBuilder = this.encode(string, encoding, null);
            return null != stringBuilder ? stringBuilder.toString() : string;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
    }

    @CheckForNull
    public StringBuilder encode(String string, Encoding encoding, @CheckForNull StringBuilder stringBuilder) throws URISyntaxException {
        String[] stringArray = encoding.escapes;
        CharBuffer charBuffer = CharBuffer.wrap(string);
        ByteBuffer byteBuffer = null;
        CharsetEncoder charsetEncoder = this.encoder;
        boolean bl2 = this.encode;
        while (charBuffer.hasRemaining()) {
            charBuffer.mark();
            char c2 = charBuffer.get();
            if (c2 < '\u0080') {
                String string2 = stringArray[c2];
                if (!(null == string2 || '%' == c2 && this.raw)) {
                    if (null == byteBuffer) {
                        if (null == stringBuilder) {
                            stringBuilder = this.stringBuilder;
                            if (null == stringBuilder) {
                                stringBuilder = this.stringBuilder = new StringBuilder();
                            } else {
                                stringBuilder.setLength(0);
                            }
                            stringBuilder.append(string, 0, charBuffer.position() - 1);
                        }
                        byteBuffer = ByteBuffer.allocate(3);
                    }
                    stringBuilder.append(string2);
                    continue;
                }
                if (null == stringBuilder) continue;
                stringBuilder.append(c2);
                continue;
            }
            if (Character.isISOControl(c2) || Character.isSpaceChar(c2) || bl2) {
                if (null == byteBuffer) {
                    if (null == stringBuilder) {
                        stringBuilder = this.stringBuilder;
                        if (null == stringBuilder) {
                            stringBuilder = this.stringBuilder = new StringBuilder();
                        } else {
                            stringBuilder.setLength(0);
                        }
                        stringBuilder.append(string, 0, charBuffer.position() - 1);
                    }
                    byteBuffer = ByteBuffer.allocate(3);
                }
                int n2 = charBuffer.position();
                charBuffer.reset();
                charBuffer.limit(n2);
                CoderResult coderResult = charsetEncoder.reset().encode(charBuffer, byteBuffer, true);
                if (CoderResult.UNDERFLOW != coderResult || CoderResult.UNDERFLOW != (coderResult = charsetEncoder.flush(byteBuffer))) {
                    assert (CoderResult.OVERFLOW != coderResult);
                    throw new QuotedUriSyntaxException((Object)string, coderResult.toString());
                }
                byteBuffer.flip();
                UriEncoder.quote(byteBuffer, stringBuilder);
                byteBuffer.clear();
                charBuffer.limit(charBuffer.capacity());
                continue;
            }
            if (null == stringBuilder) continue;
            stringBuilder.append(c2);
        }
        return null == byteBuffer ? null : stringBuilder;
    }

    public static enum Encoding {
        ANY("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-_.!~*'(),;$&+=@"),
        AUTHORITY("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-_.!~*'(),;$&+=@:[]"),
        PATH("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-_.!~*'(),;$&+=@/"),
        ABSOLUTE_PATH("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-_.!~*'(),;$&+=@:/"),
        QUERY("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-_.!~*'(),;$&+=@:/?"),
        FRAGMENT("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-_.!~*'(),;$&+=@:/?");

        private final String[] escapes = new String[128];

        private Encoding(String string2) {
            StringBuilder stringBuilder = new StringBuilder();
            for (char c2 = '\u0000'; c2 < '\u0080'; c2 = (char)((char)(c2 + 1))) {
                if (string2.indexOf(c2) >= 0) continue;
                stringBuilder.setLength(0);
                UriEncoder.quote(c2, stringBuilder);
                this.escapes[c2] = stringBuilder.toString();
            }
        }
    }
}

