/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import zz.de.schlichtherle.truezip.zip.CRC32Exception;
import zz.de.schlichtherle.truezip.zip.ZipEntry;

final class Crc32InputStream
extends CheckedInputStream {
    private final ZipEntry entry;
    private final int size;
    boolean closed;

    Crc32InputStream(InputStream inputStream, ZipEntry zipEntry, int n2) {
        super(inputStream, new CRC32());
        this.entry = zipEntry;
        this.size = n2;
    }

    @Override
    public long skip(long l2) throws IOException {
        long l3;
        long l4 = 0L;
        byte[] byArray = new byte[this.size];
        while ((l3 = l2 - l4) > 0L && (l3 = (long)this.read(byArray, 0, l3 < (long)byArray.length ? (int)l3 : byArray.length)) >= 0L) {
            l4 += l3;
        }
        return l4;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            while (this.skip(Long.MAX_VALUE) > 0L) {
            }
        }
        super.close();
        this.closed = true;
        long l2 = this.entry.getCrc();
        long l3 = this.getChecksum().getValue();
        if (l2 != l3) {
            throw new CRC32Exception(this.entry.getName(), l2, l3);
        }
    }
}

