/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.zip;

import java.util.Map;
import java.util.TreeMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.zip.Constants;
import zz.de.schlichtherle.truezip.zip.ExtraField;
import zz.de.schlichtherle.truezip.zip.LittleEndian;
import zz.de.schlichtherle.truezip.zip.UShort;

@NotThreadSafe
final class ExtraFields
implements Cloneable {
    private Map<Integer, ExtraField> extra = new TreeMap<Integer, ExtraField>();

    ExtraFields() {
    }

    public ExtraFields clone() {
        try {
            ExtraFields extraFields = (ExtraFields)super.clone();
            extraFields.extra = new TreeMap<Integer, ExtraField>(this.extra);
            return extraFields;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    int size() {
        return this.extra.size();
    }

    @CheckForNull
    ExtraField get(int n2) {
        assert (UShort.check(n2));
        ExtraField extraField = this.extra.get(n2);
        assert (null == extraField || extraField.getHeaderId() == n2);
        return extraField;
    }

    ExtraField add(ExtraField extraField) {
        int n2 = extraField.getHeaderId();
        assert (UShort.check(n2));
        return this.extra.put(n2, extraField);
    }

    @Nullable
    ExtraField remove(int n2) {
        assert (UShort.check(n2));
        ExtraField extraField = this.extra.remove(n2);
        assert (null == extraField || extraField.getHeaderId() == n2);
        return extraField;
    }

    int getExtraLength() {
        Map<Integer, ExtraField> map = this.extra;
        if (map.isEmpty()) {
            return 0;
        }
        int n2 = 0;
        for (ExtraField extraField : map.values()) {
            n2 += 4 + extraField.getDataSize();
        }
        return n2;
    }

    byte[] getExtra() {
        int n2 = this.getExtraLength();
        assert (UShort.check(n2));
        if (0 == n2) {
            return Constants.EMPTY;
        }
        byte[] byArray = new byte[n2];
        this.writeTo(byArray, 0);
        return byArray;
    }

    void readFrom(byte[] byArray, int n2, int n3) throws IndexOutOfBoundsException, IllegalArgumentException {
        assert (UShort.check(n3));
        TreeMap<Integer, ExtraField> treeMap = new TreeMap<Integer, ExtraField>();
        if (null != byArray && 0 < n3) {
            int n4 = n2 + n3;
            while (n2 < n4) {
                int n5 = LittleEndian.readUShort(byArray, n2);
                int n6 = LittleEndian.readUShort(byArray, n2 += 2);
                ExtraField extraField = ExtraField.create(n5);
                extraField.readFrom(byArray, n2 += 2, n6);
                n2 += n6;
                treeMap.put(n5, extraField);
            }
            assert (n2 == n4);
        }
        this.extra = treeMap;
    }

    void writeTo(byte[] byArray, int n2) throws IndexOutOfBoundsException {
        for (ExtraField extraField : this.extra.values()) {
            LittleEndian.writeShort(extraField.getHeaderId(), byArray, n2);
            LittleEndian.writeShort(extraField.getDataSize(), byArray, n2 += 2);
            extraField.writeTo(byArray, n2 += 2);
            n2 += extraField.getDataSize();
        }
    }
}

