/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.crypto.BufferedPartialBlockCipher;
import zz.de.schlichtherle.truezip.crypto.CipherOutputStream;
import zz.de.schlichtherle.truezip.crypto.param.AesKeyStrength;
import zz.de.schlichtherle.truezip.io.LEDataOutputStream;
import zz.de.schlichtherle.truezip.zip.WinZipAesCipher;
import zz.de.schlichtherle.truezip.zip.WinZipAesEntryParameters;
import zz.org.bouncycastle.crypto.CipherParameters;
import zz.org.bouncycastle.crypto.Digest;
import zz.org.bouncycastle.crypto.Mac;
import zz.org.bouncycastle.crypto.digests.SHA1Digest;
import zz.org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import zz.org.bouncycastle.crypto.io.MacOutputStream;
import zz.org.bouncycastle.crypto.macs.HMac;
import zz.org.bouncycastle.crypto.params.KeyParameter;
import zz.org.bouncycastle.crypto.params.ParametersWithIV;
import zz.org.bouncycastle.util.io.TeeOutputStream;

@NotThreadSafe
final class WinZipAesEntryOutputStream
extends CipherOutputStream {
    static final int ITERATION_COUNT = 1000;
    static final int AES_BLOCK_SIZE_BITS = 128;
    static final int PWD_VERIFIER_BITS = 16;
    private final SecureRandom shaker = new SecureRandom();
    private final WinZipAesEntryParameters param;
    private final MacOutputStream mos;
    private final LEDataOutputStream dos;

    WinZipAesEntryOutputStream(LEDataOutputStream lEDataOutputStream, WinZipAesEntryParameters winZipAesEntryParameters) throws IOException {
        super(lEDataOutputStream, new BufferedPartialBlockCipher(new WinZipAesCipher()));
        assert (null != lEDataOutputStream);
        assert (null != winZipAesEntryParameters);
        this.param = winZipAesEntryParameters;
        AesKeyStrength aesKeyStrength = winZipAesEntryParameters.getKeyStrength();
        int n2 = aesKeyStrength.getBits();
        int n3 = aesKeyStrength.getBytes();
        byte[] byArray = new byte[n3 / 2];
        this.shaker.nextBytes(byArray);
        byte[] byArray2 = winZipAesEntryParameters.getWritePassword();
        PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator();
        pKCS5S2ParametersGenerator.init(byArray2, byArray, 1000);
        assert (128 <= n2);
        KeyParameter keyParameter = (KeyParameter)pKCS5S2ParametersGenerator.generateDerivedParameters(2 * n2 + 16);
        this.paranoidWipe(byArray2);
        byte[] byArray3 = new byte[16];
        ParametersWithIV parametersWithIV = new ParametersWithIV((CipherParameters)new KeyParameter(keyParameter.getKey(), 0, n3), byArray3);
        KeyParameter keyParameter2 = new KeyParameter(keyParameter.getKey(), n3, n3);
        this.cipher.init(true, (CipherParameters)parametersWithIV);
        HMac hMac = new HMac((Digest)new SHA1Digest());
        hMac.init((CipherParameters)keyParameter2);
        this.dos = (LEDataOutputStream)this.delegate;
        this.mos = new MacOutputStream((Mac)hMac);
        this.delegate = new TeeOutputStream((OutputStream)this.dos, (OutputStream)this.mos);
        this.dos.write(byArray);
        this.writePasswordVerifier(keyParameter);
    }

    private void writePasswordVerifier(KeyParameter keyParameter) throws IOException {
        this.dos.write(keyParameter.getKey(), 2 * this.param.getKeyStrength().getBytes(), 2);
    }

    private void paranoidWipe(byte[] byArray) {
        this.shaker.nextBytes(byArray);
    }

    @Override
    protected void finish() throws IOException {
        super.finish();
        byte[] byArray = this.mos.getMac();
        this.dos.write(byArray, 0, byArray.length / 2);
    }
}

