/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.zip;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.EOFException;
import java.io.IOException;
import javax.annotation.WillCloseWhenClosed;
import javax.annotation.concurrent.NotThreadSafe;
import zz.de.schlichtherle.truezip.crypto.CipherReadOnlyFile;
import zz.de.schlichtherle.truezip.crypto.SeekableBlockCipher;
import zz.de.schlichtherle.truezip.crypto.SuspensionPenalty;
import zz.de.schlichtherle.truezip.crypto.param.AesKeyStrength;
import zz.de.schlichtherle.truezip.rof.ReadOnlyFile;
import zz.de.schlichtherle.truezip.util.ArrayHelper;
import zz.de.schlichtherle.truezip.zip.WinZipAesCipher;
import zz.de.schlichtherle.truezip.zip.WinZipAesEntryExtraField;
import zz.de.schlichtherle.truezip.zip.WinZipAesEntryParameters;
import zz.de.schlichtherle.truezip.zip.ZipAuthenticationException;
import zz.de.schlichtherle.truezip.zip.ZipCryptoException;
import zz.de.schlichtherle.truezip.zip.ZipEntry;
import zz.org.bouncycastle.crypto.CipherParameters;
import zz.org.bouncycastle.crypto.Digest;
import zz.org.bouncycastle.crypto.Mac;
import zz.org.bouncycastle.crypto.digests.SHA1Digest;
import zz.org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import zz.org.bouncycastle.crypto.macs.HMac;
import zz.org.bouncycastle.crypto.params.KeyParameter;
import zz.org.bouncycastle.crypto.params.ParametersWithIV;

@NotThreadSafe
final class WinZipAesEntryReadOnlyFile
extends CipherReadOnlyFile {
    private final byte[] authenticationCode;
    private final KeyParameter sha1MacParam;
    private final ZipEntry entry;

    @CreatesObligation
    @SuppressWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    WinZipAesEntryReadOnlyFile(@WillCloseWhenClosed ReadOnlyFile readOnlyFile, WinZipAesEntryParameters winZipAesEntryParameters) throws IOException {
        super(readOnlyFile);
        KeyParameter keyParameter;
        ParametersWithIV parametersWithIV;
        Object object;
        KeyParameter keyParameter2;
        ZipEntry zipEntry = winZipAesEntryParameters.getEntry();
        assert (zipEntry.isEncrypted());
        WinZipAesEntryExtraField winZipAesEntryExtraField = (WinZipAesEntryExtraField)zipEntry.getExtraField(39169);
        if (null == winZipAesEntryExtraField) {
            throw new ZipCryptoException(zipEntry.getName() + " (missing extra field for WinZip AES entry)");
        }
        AesKeyStrength aesKeyStrength = winZipAesEntryExtraField.getKeyStrength();
        int n2 = aesKeyStrength.getBits();
        int n3 = aesKeyStrength.getBytes();
        byte[] byArray = new byte[n3 / 2];
        readOnlyFile.seek(0L);
        readOnlyFile.readFully(byArray);
        byte[] byArray2 = new byte[2];
        readOnlyFile.readFully(byArray2);
        HMac hMac = new HMac((Digest)new SHA1Digest());
        this.authenticationCode = new byte[hMac.getMacSize() / 2];
        long l2 = readOnlyFile.getFilePointer();
        long l3 = readOnlyFile.length() - (long)this.authenticationCode.length;
        long l4 = l3 - l2;
        if (0L > l4) {
            throw new ZipCryptoException(zipEntry.getName() + " (false positive WinZip AES entry is too short)", new EOFException());
        }
        readOnlyFile.seek(l3);
        readOnlyFile.readFully(this.authenticationCode);
        if (-1 != readOnlyFile.read()) {
            throw new ZipCryptoException("Expected end of file after WinZip AES authentication code!");
        }
        PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator = new PKCS5S2ParametersGenerator();
        long l5 = 0L;
        do {
            object = winZipAesEntryParameters.getReadPassword(0L != l5);
            assert (null != object);
            pKCS5S2ParametersGenerator.init(object, byArray, 1000);
            assert (128 <= n2);
            keyParameter2 = (KeyParameter)pKCS5S2ParametersGenerator.generateDerivedParameters(2 * n2 + 16);
            this.paranoidWipe((byte[])object);
            byte[] byArray3 = new byte[16];
            parametersWithIV = new ParametersWithIV((CipherParameters)new KeyParameter(keyParameter2.getKey(), 0, n3), byArray3);
            keyParameter = new KeyParameter(keyParameter2.getKey(), n3, n3);
            l5 = SuspensionPenalty.enforce(l5);
        } while (!ArrayHelper.equals(keyParameter2.getKey(), 2 * n3, byArray2, 0, 2));
        this.sha1MacParam = keyParameter;
        this.entry = zipEntry;
        object = new WinZipAesCipher();
        object.init(false, (CipherParameters)parametersWithIV);
        this.init((SeekableBlockCipher)object, l2, l4);
        winZipAesEntryParameters.setKeyStrength(aesKeyStrength);
    }

    private void paranoidWipe(byte[] byArray) {
        int n2 = byArray.length;
        while (--n2 >= 0) {
            byArray[n2] = 0;
        }
    }

    void authenticate() throws IOException {
        HMac hMac = new HMac((Digest)new SHA1Digest());
        hMac.init((CipherParameters)this.sha1MacParam);
        byte[] byArray = this.computeMac((Mac)hMac);
        if (!ArrayHelper.equals(byArray, 0, this.authenticationCode, 0, this.authenticationCode.length)) {
            throw new ZipAuthenticationException(this.entry.getName() + " (authenticated WinZip AES entry content has been tampered with)");
        }
    }
}

