/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import zz.de.schlichtherle.truezip.io.SynchronizedInputStream;
import zz.de.schlichtherle.truezip.rof.DefaultReadOnlyFile;
import zz.de.schlichtherle.truezip.rof.ReadOnlyFile;
import zz.de.schlichtherle.truezip.util.Pool;
import zz.de.schlichtherle.truezip.zip.DefaultZipFileParameters;
import zz.de.schlichtherle.truezip.zip.RawZipFile;
import zz.de.schlichtherle.truezip.zip.ZipCryptoParameters;
import zz.de.schlichtherle.truezip.zip.ZipEntry;

@ThreadSafe
public class ZipFile
extends RawZipFile<ZipEntry> {
    @CheckForNull
    private volatile ZipCryptoParameters cryptoParameters;
    private final String name;

    public ZipFile(String string) throws IOException {
        this(string, DEFAULT_CHARSET, true, false);
    }

    public ZipFile(String string, Charset charset) throws IOException {
        this(string, charset, true, false);
    }

    public ZipFile(String string, Charset charset, boolean bl2, boolean bl3) throws IOException {
        super(new DefaultReadOnlyFilePool(string), new DefaultZipFileParameters(charset, bl2, bl3));
        this.name = string;
    }

    public ZipFile(File file) throws IOException {
        this(file, DEFAULT_CHARSET, true, false);
    }

    public ZipFile(File file, Charset charset) throws IOException {
        this(file, charset, true, false);
    }

    public ZipFile(File file, Charset charset, boolean bl2, boolean bl3) throws IOException {
        super(new DefaultReadOnlyFilePool(file), new DefaultZipFileParameters(charset, bl2, bl3));
        this.name = file.toString();
    }

    public ZipFile(ReadOnlyFile readOnlyFile) throws IOException {
        this(readOnlyFile, DEFAULT_CHARSET, true, false);
    }

    public ZipFile(ReadOnlyFile readOnlyFile, Charset charset) throws IOException {
        this(readOnlyFile, charset, true, false);
    }

    public ZipFile(ReadOnlyFile readOnlyFile, Charset charset, boolean bl2, boolean bl3) throws IOException {
        super(readOnlyFile, new DefaultZipFileParameters(charset, bl2, bl3));
        this.name = readOnlyFile.toString();
    }

    @Override
    public void recoverLostEntries() throws IOException {
        super.recoverLostEntries();
    }

    public String getName() {
        return this.name;
    }

    public Enumeration<? extends ZipEntry> entries() {
        class CloneEnumeration
        implements Enumeration<ZipEntry> {
            final Iterator<ZipEntry> i;

            CloneEnumeration() {
                this.i = ZipFile.super.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.i.hasNext();
            }

            @Override
            public ZipEntry nextElement() {
                return this.i.next().clone();
            }
        }
        return new CloneEnumeration();
    }

    @Override
    public Iterator<ZipEntry> iterator() {
        class EntryIterator
        implements Iterator<ZipEntry> {
            final Iterator<ZipEntry> i;

            EntryIterator() {
                this.i = ZipFile.super.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public ZipEntry next() {
                return this.i.next().clone();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
        return new EntryIterator();
    }

    @Override
    public ZipEntry getEntry(String string) {
        Object e2 = super.getEntry(string);
        return e2 != null ? ((ZipEntry)e2).clone() : null;
    }

    @Override
    public synchronized InputStream getPreambleInputStream() throws IOException {
        return new SynchronizedInputStream(super.getPreambleInputStream(), this);
    }

    @Override
    public synchronized InputStream getPostambleInputStream() throws IOException {
        return new SynchronizedInputStream(super.getPostambleInputStream(), this);
    }

    @Override
    public synchronized boolean busy() {
        return super.busy();
    }

    @Override
    @Nullable
    public ZipCryptoParameters getCryptoParameters() {
        return this.cryptoParameters;
    }

    public void setCryptoParameters(@CheckForNull ZipCryptoParameters zipCryptoParameters) {
        this.cryptoParameters = zipCryptoParameters;
    }

    @Override
    protected synchronized InputStream getInputStream(String string, Boolean bl2, boolean bl3) throws IOException {
        InputStream inputStream = super.getInputStream(string, bl2, bl3);
        return inputStream == null ? null : new SynchronizedInputStream(inputStream, this);
    }

    @Override
    public synchronized void close() throws IOException {
        super.close();
    }

    private static final class DefaultReadOnlyFilePool
    implements Pool<ReadOnlyFile, IOException> {
        final File file;

        DefaultReadOnlyFilePool(String string) {
            this(new File(string));
        }

        DefaultReadOnlyFilePool(File file) {
            this.file = file;
        }

        @Override
        public ReadOnlyFile allocate() throws IOException {
            return new DefaultReadOnlyFile(this.file);
        }

        @Override
        public void release(ReadOnlyFile readOnlyFile) throws IOException {
            readOnlyFile.close();
        }
    }
}

