/*
 * Decompiled with CFR 0.152.
 */
package zz.de.schlichtherle.truezip.zip;

import edu.umd.cs.findbugs.annotations.CleanupObligation;
import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.DischargesObligation;
import java.io.IOException;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.annotation.WillCloseWhenClosed;
import zz.de.schlichtherle.truezip.util.JSE7;
import zz.de.schlichtherle.truezip.zip.DummyByteInputStream;
import zz.de.schlichtherle.truezip.zip.Jdk6Inflater;

@CleanupObligation
final class ZipInflaterInputStream
extends InflaterInputStream {
    private static final InflaterFactory factory = JSE7.AVAILABLE ? new InflaterFactory() : new Jdk6InflaterFactory();

    @CreatesObligation
    ZipInflaterInputStream(@WillCloseWhenClosed DummyByteInputStream dummyByteInputStream, int n2) {
        super(dummyByteInputStream, factory.newInflater(), n2);
    }

    Inflater getInflater() {
        return this.inf;
    }

    @Override
    @DischargesObligation
    public void close() throws IOException {
        super.close();
        this.inf.end();
    }

    private static final class Jdk6InflaterFactory
    extends InflaterFactory {
        private Jdk6InflaterFactory() {
        }

        @Override
        protected Inflater newInflater() {
            return new Jdk6Inflater(true);
        }
    }

    private static class InflaterFactory {
        private InflaterFactory() {
        }

        protected Inflater newInflater() {
            return new Inflater(true);
        }
    }
}

