/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.compress.archivers;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import zz.org.apache.commons.compress.archivers.ArchiveEntry;
import zz.org.apache.commons.compress.archivers.ArchiveException;
import zz.org.apache.commons.compress.archivers.ArchiveInputStream;
import zz.org.apache.commons.compress.archivers.ArchiveStreamFactory;
import zz.org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import zz.org.apache.commons.compress.archivers.sevenz.SevenZFile;

public final class Lister {
    private static final ArchiveStreamFactory factory = new ArchiveStreamFactory();

    public static void main(String[] stringArray) throws Exception {
        String string;
        if (stringArray.length == 0) {
            Lister.usage();
            return;
        }
        System.out.println("Analysing " + stringArray[0]);
        File file = new File(stringArray[0]);
        if (!file.isFile()) {
            System.err.println(file + " doesn't exist or is a directory");
        }
        String string2 = string = stringArray.length > 1 ? stringArray[1] : Lister.detectFormat(file);
        if ("7z".equalsIgnoreCase(string)) {
            Lister.list7z(file);
        } else {
            Lister.listStream(file, stringArray);
        }
    }

    private static void listStream(File file, String[] stringArray) throws ArchiveException, IOException {
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
             ArchiveInputStream archiveInputStream = Lister.createArchiveInputStream(stringArray, bufferedInputStream);){
            ArchiveEntry archiveEntry;
            System.out.println("Created " + archiveInputStream.toString());
            while ((archiveEntry = archiveInputStream.getNextEntry()) != null) {
                System.out.println(archiveEntry.getName());
            }
        }
    }

    private static ArchiveInputStream createArchiveInputStream(String[] stringArray, InputStream inputStream) throws ArchiveException {
        if (stringArray.length > 1) {
            return factory.createArchiveInputStream(stringArray[1], inputStream);
        }
        return factory.createArchiveInputStream(inputStream);
    }

    private static String detectFormat(File file) throws ArchiveException, IOException {
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            String string = ArchiveStreamFactory.detect(bufferedInputStream);
            return string;
        }
    }

    private static void list7z(File file) throws ArchiveException, IOException {
        try (SevenZFile sevenZFile = new SevenZFile(file);){
            SevenZArchiveEntry sevenZArchiveEntry;
            System.out.println("Created " + sevenZFile.toString());
            while ((sevenZArchiveEntry = sevenZFile.getNextEntry()) != null) {
                System.out.println(sevenZArchiveEntry.getName());
            }
        }
    }

    private static void usage() {
        System.out.println("Parameters: archive-name [archive-type]");
    }
}

