/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.compress.archivers.ar;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import zz.org.apache.commons.compress.archivers.ArchiveEntry;
import zz.org.apache.commons.compress.archivers.ArchiveInputStream;
import zz.org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import zz.org.apache.commons.compress.utils.ArchiveUtils;
import zz.org.apache.commons.compress.utils.IOUtils;

public class ArArchiveInputStream
extends ArchiveInputStream {
    private final InputStream input;
    private long offset = 0L;
    private boolean closed;
    private ArArchiveEntry currentEntry = null;
    private byte[] namebuffer = null;
    private long entryOffset = -1L;
    private static final int NAME_OFFSET = 0;
    private static final int NAME_LEN = 16;
    private static final int LAST_MODIFIED_OFFSET = 16;
    private static final int LAST_MODIFIED_LEN = 12;
    private static final int USER_ID_OFFSET = 28;
    private static final int USER_ID_LEN = 6;
    private static final int GROUP_ID_OFFSET = 34;
    private static final int GROUP_ID_LEN = 6;
    private static final int FILE_MODE_OFFSET = 40;
    private static final int FILE_MODE_LEN = 8;
    private static final int LENGTH_OFFSET = 48;
    private static final int LENGTH_LEN = 10;
    private final byte[] metaData = new byte[58];
    static final String BSD_LONGNAME_PREFIX = "#1/";
    private static final int BSD_LONGNAME_PREFIX_LEN = "#1/".length();
    private static final String BSD_LONGNAME_PATTERN = "^#1/\\d+";
    private static final String GNU_STRING_TABLE_NAME = "//";
    private static final String GNU_LONGNAME_PATTERN = "^/\\d+";

    public ArArchiveInputStream(InputStream inputStream) {
        this.input = inputStream;
        this.closed = false;
    }

    public ArArchiveEntry getNextArEntry() throws IOException {
        int n2;
        int n3;
        byte[] byArray;
        if (this.currentEntry != null) {
            long l2 = this.entryOffset + this.currentEntry.getLength();
            long l3 = IOUtils.skip(this.input, l2 - this.offset);
            this.trackReadBytes(l3);
            this.currentEntry = null;
        }
        if (this.offset == 0L) {
            byte[] byArray2 = ArchiveUtils.toAsciiBytes("!<arch>\n");
            byArray = new byte[byArray2.length];
            n3 = IOUtils.readFully(this.input, byArray);
            this.trackReadBytes(n3);
            if (n3 != byArray2.length) {
                throw new IOException("failed to read header. Occured at byte: " + this.getBytesRead());
            }
            for (n2 = 0; n2 < byArray2.length; ++n2) {
                if (byArray2[n2] == byArray[n2]) continue;
                throw new IOException("invalid header " + ArchiveUtils.toAsciiString(byArray));
            }
        }
        if (this.offset % 2L != 0L) {
            if (this.input.read() < 0) {
                return null;
            }
            this.trackReadBytes(1L);
        }
        if (this.input.available() == 0) {
            return null;
        }
        int n4 = IOUtils.readFully(this.input, this.metaData);
        this.trackReadBytes(n4);
        if (n4 < this.metaData.length) {
            throw new IOException("truncated ar archive");
        }
        Object object = ArchiveUtils.toAsciiBytes("`\n");
        byArray = new byte[((byte[])object).length];
        n3 = IOUtils.readFully(this.input, byArray);
        this.trackReadBytes(n3);
        if (n3 != ((byte[])object).length) {
            throw new IOException("failed to read entry trailer. Occured at byte: " + this.getBytesRead());
        }
        for (n2 = 0; n2 < ((byte[])object).length; ++n2) {
            if (object[n2] == byArray[n2]) continue;
            throw new IOException("invalid entry trailer. not read the content? Occured at byte: " + this.getBytesRead());
        }
        this.entryOffset = this.offset;
        object = ArchiveUtils.toAsciiString(this.metaData, 0, 16).trim();
        if (ArArchiveInputStream.isGNUStringTable((String)object)) {
            this.currentEntry = this.readGNUStringTable(this.metaData, 48, 10);
            return this.getNextArEntry();
        }
        long l4 = this.asLong(this.metaData, 48, 10);
        if (((String)object).endsWith("/")) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        } else if (this.isGNULongName((String)object)) {
            n2 = Integer.parseInt(((String)object).substring(1));
            object = this.getExtendedName(n2);
        } else if (ArArchiveInputStream.isBSDLongName((String)object)) {
            object = this.getBSDLongName((String)object);
            n2 = ((String)object).length();
            l4 -= (long)n2;
            this.entryOffset += (long)n2;
        }
        this.currentEntry = new ArArchiveEntry((String)object, l4, this.asInt(this.metaData, 28, 6, true), this.asInt(this.metaData, 34, 6, true), this.asInt(this.metaData, 40, 8, 8), this.asLong(this.metaData, 16, 12));
        return this.currentEntry;
    }

    private String getExtendedName(int n2) throws IOException {
        if (this.namebuffer == null) {
            throw new IOException("Cannot process GNU long filename as no // record was found");
        }
        for (int i2 = n2; i2 < this.namebuffer.length; ++i2) {
            if (this.namebuffer[i2] != 10 && this.namebuffer[i2] != 0) continue;
            if (this.namebuffer[i2 - 1] == 47) {
                --i2;
            }
            return ArchiveUtils.toAsciiString(this.namebuffer, n2, i2 - n2);
        }
        throw new IOException("Failed to read entry: " + n2);
    }

    private long asLong(byte[] byArray, int n2, int n3) {
        return Long.parseLong(ArchiveUtils.toAsciiString(byArray, n2, n3).trim());
    }

    private int asInt(byte[] byArray, int n2, int n3) {
        return this.asInt(byArray, n2, n3, 10, false);
    }

    private int asInt(byte[] byArray, int n2, int n3, boolean bl2) {
        return this.asInt(byArray, n2, n3, 10, bl2);
    }

    private int asInt(byte[] byArray, int n2, int n3, int n4) {
        return this.asInt(byArray, n2, n3, n4, false);
    }

    private int asInt(byte[] byArray, int n2, int n3, int n4, boolean bl2) {
        String string = ArchiveUtils.toAsciiString(byArray, n2, n3).trim();
        if (string.length() == 0 && bl2) {
            return 0;
        }
        return Integer.parseInt(string, n4);
    }

    @Override
    public ArchiveEntry getNextEntry() throws IOException {
        return this.getNextArEntry();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.input.close();
        }
        this.currentEntry = null;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.currentEntry == null) {
            throw new IllegalStateException("No current ar entry");
        }
        int n4 = n3;
        long l2 = this.entryOffset + this.currentEntry.getLength();
        if (n3 <= 0 || l2 <= this.offset) {
            return -1;
        }
        n4 = (int)Math.min((long)n3, l2 - this.offset);
        int n5 = this.input.read(byArray, n2, n4);
        this.trackReadBytes(n5);
        return n5;
    }

    public static boolean matches(byte[] byArray, int n2) {
        return n2 >= 8 && byArray[0] == 33 && byArray[1] == 60 && byArray[2] == 97 && byArray[3] == 114 && byArray[4] == 99 && byArray[5] == 104 && byArray[6] == 62 && byArray[7] == 10;
    }

    private static boolean isBSDLongName(String string) {
        return string != null && string.matches(BSD_LONGNAME_PATTERN);
    }

    private String getBSDLongName(String string) throws IOException {
        int n2 = Integer.parseInt(string.substring(BSD_LONGNAME_PREFIX_LEN));
        byte[] byArray = new byte[n2];
        int n3 = IOUtils.readFully(this.input, byArray);
        this.trackReadBytes(n3);
        if (n3 != n2) {
            throw new EOFException();
        }
        return ArchiveUtils.toAsciiString(byArray);
    }

    private static boolean isGNUStringTable(String string) {
        return GNU_STRING_TABLE_NAME.equals(string);
    }

    private void trackReadBytes(long l2) {
        this.count(l2);
        if (l2 > 0L) {
            this.offset += l2;
        }
    }

    private ArArchiveEntry readGNUStringTable(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.asInt(byArray, n2, n3);
        this.namebuffer = new byte[n4];
        int n5 = IOUtils.readFully(this.input, this.namebuffer, 0, n4);
        this.trackReadBytes(n5);
        if (n5 != n4) {
            throw new IOException("Failed to read complete // record: expected=" + n4 + " read=" + n5);
        }
        return new ArArchiveEntry(GNU_STRING_TABLE_NAME, n4);
    }

    private boolean isGNULongName(String string) {
        return string != null && string.matches(GNU_LONGNAME_PATTERN);
    }
}

