/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.compress.archivers.dump;

import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import zz.org.apache.commons.compress.archivers.ArchiveEntry;
import zz.org.apache.commons.compress.archivers.dump.DumpArchiveConstants;
import zz.org.apache.commons.compress.archivers.dump.DumpArchiveSummary;
import zz.org.apache.commons.compress.archivers.dump.DumpArchiveUtil;

public class DumpArchiveEntry
implements ArchiveEntry {
    private String name;
    private TYPE type = TYPE.UNKNOWN;
    private int mode;
    private Set<PERMISSION> permissions = Collections.emptySet();
    private long size;
    private long atime;
    private long mtime;
    private int uid;
    private int gid;
    private final DumpArchiveSummary summary = null;
    private final TapeSegmentHeader header = new TapeSegmentHeader();
    private String simpleName;
    private String originalName;
    private int volume;
    private long offset;
    private int ino;
    private int nlink;
    private long ctime;
    private int generation;
    private boolean isDeleted;

    public DumpArchiveEntry() {
    }

    public DumpArchiveEntry(String string, String string2) {
        this.setName(string);
        this.simpleName = string2;
    }

    protected DumpArchiveEntry(String string, String string2, int n2, TYPE tYPE) {
        this.setType(tYPE);
        this.setName(string);
        this.simpleName = string2;
        this.ino = n2;
        this.offset = 0L;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    protected void setSimpleName(String string) {
        this.simpleName = string;
    }

    public int getIno() {
        return this.header.getIno();
    }

    public int getNlink() {
        return this.nlink;
    }

    public void setNlink(int n2) {
        this.nlink = n2;
    }

    public Date getCreationTime() {
        return new Date(this.ctime);
    }

    public void setCreationTime(Date date) {
        this.ctime = date.getTime();
    }

    public int getGeneration() {
        return this.generation;
    }

    public void setGeneration(int n2) {
        this.generation = n2;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void setDeleted(boolean bl2) {
        this.isDeleted = bl2;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long l2) {
        this.offset = l2;
    }

    public int getVolume() {
        return this.volume;
    }

    public void setVolume(int n2) {
        this.volume = n2;
    }

    public DumpArchiveConstants.SEGMENT_TYPE getHeaderType() {
        return this.header.getType();
    }

    public int getHeaderCount() {
        return this.header.getCount();
    }

    public int getHeaderHoles() {
        return this.header.getHoles();
    }

    public boolean isSparseRecord(int n2) {
        return (this.header.getCdata(n2) & 1) == 0;
    }

    public int hashCode() {
        return this.ino;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !object.getClass().equals(this.getClass())) {
            return false;
        }
        DumpArchiveEntry dumpArchiveEntry = (DumpArchiveEntry)object;
        if (dumpArchiveEntry.header == null) {
            return false;
        }
        if (this.ino != dumpArchiveEntry.ino) {
            return false;
        }
        return (this.summary != null || dumpArchiveEntry.summary == null) && (this.summary == null || this.summary.equals(dumpArchiveEntry.summary));
    }

    public String toString() {
        return this.getName();
    }

    static DumpArchiveEntry parse(byte[] byArray) {
        DumpArchiveEntry dumpArchiveEntry = new DumpArchiveEntry();
        TapeSegmentHeader tapeSegmentHeader = dumpArchiveEntry.header;
        tapeSegmentHeader.type = DumpArchiveConstants.SEGMENT_TYPE.find(DumpArchiveUtil.convert32(byArray, 0));
        tapeSegmentHeader.volume = DumpArchiveUtil.convert32(byArray, 12);
        dumpArchiveEntry.ino = tapeSegmentHeader.ino = DumpArchiveUtil.convert32(byArray, 20);
        int n2 = DumpArchiveUtil.convert16(byArray, 32);
        dumpArchiveEntry.setType(TYPE.find(n2 >> 12 & 0xF));
        dumpArchiveEntry.setMode(n2);
        dumpArchiveEntry.nlink = DumpArchiveUtil.convert16(byArray, 34);
        dumpArchiveEntry.setSize(DumpArchiveUtil.convert64(byArray, 40));
        long l2 = 1000L * (long)DumpArchiveUtil.convert32(byArray, 48) + (long)(DumpArchiveUtil.convert32(byArray, 52) / 1000);
        dumpArchiveEntry.setAccessTime(new Date(l2));
        l2 = 1000L * (long)DumpArchiveUtil.convert32(byArray, 56) + (long)(DumpArchiveUtil.convert32(byArray, 60) / 1000);
        dumpArchiveEntry.setLastModifiedDate(new Date(l2));
        dumpArchiveEntry.ctime = l2 = 1000L * (long)DumpArchiveUtil.convert32(byArray, 64) + (long)(DumpArchiveUtil.convert32(byArray, 68) / 1000);
        dumpArchiveEntry.generation = DumpArchiveUtil.convert32(byArray, 140);
        dumpArchiveEntry.setUserId(DumpArchiveUtil.convert32(byArray, 144));
        dumpArchiveEntry.setGroupId(DumpArchiveUtil.convert32(byArray, 148));
        tapeSegmentHeader.count = DumpArchiveUtil.convert32(byArray, 160);
        tapeSegmentHeader.holes = 0;
        for (int i2 = 0; i2 < 512 && i2 < tapeSegmentHeader.count; ++i2) {
            if (byArray[164 + i2] != 0) continue;
            tapeSegmentHeader.holes++;
        }
        System.arraycopy(byArray, 164, tapeSegmentHeader.cdata, 0, 512);
        dumpArchiveEntry.volume = tapeSegmentHeader.getVolume();
        return dumpArchiveEntry;
    }

    void update(byte[] byArray) {
        this.header.volume = DumpArchiveUtil.convert32(byArray, 16);
        this.header.count = DumpArchiveUtil.convert32(byArray, 160);
        this.header.holes = 0;
        for (int i2 = 0; i2 < 512 && i2 < this.header.count; ++i2) {
            if (byArray[164 + i2] != 0) continue;
            this.header.holes++;
        }
        System.arraycopy(byArray, 164, this.header.cdata, 0, 512);
    }

    @Override
    public String getName() {
        return this.name;
    }

    String getOriginalName() {
        return this.originalName;
    }

    public final void setName(String string) {
        this.originalName = string;
        if (string != null) {
            if (this.isDirectory() && !string.endsWith("/")) {
                string = string + "/";
            }
            if (string.startsWith("./")) {
                string = string.substring(2);
            }
        }
        this.name = string;
    }

    @Override
    public Date getLastModifiedDate() {
        return new Date(this.mtime);
    }

    @Override
    public boolean isDirectory() {
        return this.type == TYPE.DIRECTORY;
    }

    public boolean isFile() {
        return this.type == TYPE.FILE;
    }

    public boolean isSocket() {
        return this.type == TYPE.SOCKET;
    }

    public boolean isChrDev() {
        return this.type == TYPE.CHRDEV;
    }

    public boolean isBlkDev() {
        return this.type == TYPE.BLKDEV;
    }

    public boolean isFifo() {
        return this.type == TYPE.FIFO;
    }

    public TYPE getType() {
        return this.type;
    }

    public void setType(TYPE tYPE) {
        this.type = tYPE;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n2) {
        this.mode = n2 & 0xFFF;
        this.permissions = PERMISSION.find(n2);
    }

    public Set<PERMISSION> getPermissions() {
        return this.permissions;
    }

    @Override
    public long getSize() {
        return this.isDirectory() ? -1L : this.size;
    }

    long getEntrySize() {
        return this.size;
    }

    public void setSize(long l2) {
        this.size = l2;
    }

    public void setLastModifiedDate(Date date) {
        this.mtime = date.getTime();
    }

    public Date getAccessTime() {
        return new Date(this.atime);
    }

    public void setAccessTime(Date date) {
        this.atime = date.getTime();
    }

    public int getUserId() {
        return this.uid;
    }

    public void setUserId(int n2) {
        this.uid = n2;
    }

    public int getGroupId() {
        return this.gid;
    }

    public void setGroupId(int n2) {
        this.gid = n2;
    }

    public static enum PERMISSION {
        SETUID(2048),
        SETGUI(1024),
        STICKY(512),
        USER_READ(256),
        USER_WRITE(128),
        USER_EXEC(64),
        GROUP_READ(32),
        GROUP_WRITE(16),
        GROUP_EXEC(8),
        WORLD_READ(4),
        WORLD_WRITE(2),
        WORLD_EXEC(1);

        private int code;

        private PERMISSION(int n3) {
            this.code = n3;
        }

        public static Set<PERMISSION> find(int n2) {
            HashSet<PERMISSION> hashSet = new HashSet<PERMISSION>();
            for (PERMISSION pERMISSION : PERMISSION.values()) {
                if ((n2 & pERMISSION.code) != pERMISSION.code) continue;
                hashSet.add(pERMISSION);
            }
            if (hashSet.isEmpty()) {
                return Collections.emptySet();
            }
            return EnumSet.copyOf(hashSet);
        }
    }

    public static enum TYPE {
        WHITEOUT(14),
        SOCKET(12),
        LINK(10),
        FILE(8),
        BLKDEV(6),
        DIRECTORY(4),
        CHRDEV(2),
        FIFO(1),
        UNKNOWN(15);

        private int code;

        private TYPE(int n3) {
            this.code = n3;
        }

        public static TYPE find(int n2) {
            TYPE tYPE = UNKNOWN;
            for (TYPE tYPE2 : TYPE.values()) {
                if (n2 != tYPE2.code) continue;
                tYPE = tYPE2;
            }
            return tYPE;
        }
    }

    static class TapeSegmentHeader {
        private DumpArchiveConstants.SEGMENT_TYPE type;
        private int volume;
        private int ino;
        private int count;
        private int holes;
        private final byte[] cdata = new byte[512];

        TapeSegmentHeader() {
        }

        public DumpArchiveConstants.SEGMENT_TYPE getType() {
            return this.type;
        }

        public int getVolume() {
            return this.volume;
        }

        public int getIno() {
            return this.ino;
        }

        void setIno(int n2) {
            this.ino = n2;
        }

        public int getCount() {
            return this.count;
        }

        public int getHoles() {
            return this.holes;
        }

        public int getCdata(int n2) {
            return this.cdata[n2];
        }
    }
}

