/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.compress.archivers.dump;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Stack;
import zz.org.apache.commons.compress.archivers.ArchiveException;
import zz.org.apache.commons.compress.archivers.ArchiveInputStream;
import zz.org.apache.commons.compress.archivers.dump.Dirent;
import zz.org.apache.commons.compress.archivers.dump.DumpArchiveConstants;
import zz.org.apache.commons.compress.archivers.dump.DumpArchiveEntry;
import zz.org.apache.commons.compress.archivers.dump.DumpArchiveSummary;
import zz.org.apache.commons.compress.archivers.dump.DumpArchiveUtil;
import zz.org.apache.commons.compress.archivers.dump.InvalidFormatException;
import zz.org.apache.commons.compress.archivers.dump.TapeInputStream;
import zz.org.apache.commons.compress.archivers.dump.UnrecognizedFormatException;
import zz.org.apache.commons.compress.archivers.zip.ZipEncoding;
import zz.org.apache.commons.compress.archivers.zip.ZipEncodingHelper;

public class DumpArchiveInputStream
extends ArchiveInputStream {
    private DumpArchiveSummary summary;
    private DumpArchiveEntry active;
    private boolean isClosed;
    private boolean hasHitEOF;
    private long entrySize;
    private long entryOffset;
    private int readIdx;
    private final byte[] readBuf = new byte[1024];
    private byte[] blockBuffer;
    private int recordOffset;
    private long filepos;
    protected TapeInputStream raw;
    private final Map<Integer, Dirent> names = new HashMap<Integer, Dirent>();
    private final Map<Integer, DumpArchiveEntry> pending = new HashMap<Integer, DumpArchiveEntry>();
    private Queue<DumpArchiveEntry> queue;
    private final ZipEncoding zipEncoding;
    final String encoding;

    public DumpArchiveInputStream(InputStream inputStream) throws ArchiveException {
        this(inputStream, null);
    }

    public DumpArchiveInputStream(InputStream inputStream, String string) throws ArchiveException {
        Object object;
        this.raw = new TapeInputStream(inputStream);
        this.hasHitEOF = false;
        this.encoding = string;
        this.zipEncoding = ZipEncodingHelper.getZipEncoding(string);
        try {
            object = this.raw.readRecord();
            if (!DumpArchiveUtil.verify(object)) {
                throw new UnrecognizedFormatException();
            }
            this.summary = new DumpArchiveSummary((byte[])object, this.zipEncoding);
            this.raw.resetBlockSize(this.summary.getNTRec(), this.summary.isCompressed());
            this.blockBuffer = new byte[4096];
            this.readCLRI();
            this.readBITS();
        }
        catch (IOException iOException) {
            throw new ArchiveException(iOException.getMessage(), iOException);
        }
        object = new Dirent(2, 2, 4, ".");
        this.names.put(2, (Dirent)object);
        this.queue = new PriorityQueue<DumpArchiveEntry>(10, new Comparator<DumpArchiveEntry>(){

            @Override
            public int compare(DumpArchiveEntry dumpArchiveEntry, DumpArchiveEntry dumpArchiveEntry2) {
                if (dumpArchiveEntry.getOriginalName() == null || dumpArchiveEntry2.getOriginalName() == null) {
                    return Integer.MAX_VALUE;
                }
                return dumpArchiveEntry.getOriginalName().compareTo(dumpArchiveEntry2.getOriginalName());
            }
        });
    }

    @Override
    @Deprecated
    public int getCount() {
        return (int)this.getBytesRead();
    }

    @Override
    public long getBytesRead() {
        return this.raw.getBytesRead();
    }

    public DumpArchiveSummary getSummary() {
        return this.summary;
    }

    private void readCLRI() throws IOException {
        byte[] byArray = this.raw.readRecord();
        if (!DumpArchiveUtil.verify(byArray)) {
            throw new InvalidFormatException();
        }
        this.active = DumpArchiveEntry.parse(byArray);
        if (DumpArchiveConstants.SEGMENT_TYPE.CLRI != this.active.getHeaderType()) {
            throw new InvalidFormatException();
        }
        if (this.raw.skip(1024L * (long)this.active.getHeaderCount()) == -1L) {
            throw new EOFException();
        }
        this.readIdx = this.active.getHeaderCount();
    }

    private void readBITS() throws IOException {
        byte[] byArray = this.raw.readRecord();
        if (!DumpArchiveUtil.verify(byArray)) {
            throw new InvalidFormatException();
        }
        this.active = DumpArchiveEntry.parse(byArray);
        if (DumpArchiveConstants.SEGMENT_TYPE.BITS != this.active.getHeaderType()) {
            throw new InvalidFormatException();
        }
        if (this.raw.skip(1024L * (long)this.active.getHeaderCount()) == -1L) {
            throw new EOFException();
        }
        this.readIdx = this.active.getHeaderCount();
    }

    public DumpArchiveEntry getNextDumpEntry() throws IOException {
        return this.getNextEntry();
    }

    @Override
    public DumpArchiveEntry getNextEntry() throws IOException {
        DumpArchiveEntry dumpArchiveEntry = null;
        String string = null;
        if (!this.queue.isEmpty()) {
            return this.queue.remove();
        }
        while (dumpArchiveEntry == null) {
            if (this.hasHitEOF) {
                return null;
            }
            while (this.readIdx < this.active.getHeaderCount()) {
                if (this.active.isSparseRecord(this.readIdx++) || this.raw.skip(1024L) != -1L) continue;
                throw new EOFException();
            }
            this.readIdx = 0;
            this.filepos = this.raw.getBytesRead();
            byte[] byArray = this.raw.readRecord();
            if (!DumpArchiveUtil.verify(byArray)) {
                throw new InvalidFormatException();
            }
            this.active = DumpArchiveEntry.parse(byArray);
            while (DumpArchiveConstants.SEGMENT_TYPE.ADDR == this.active.getHeaderType()) {
                if (this.raw.skip(1024L * (long)(this.active.getHeaderCount() - this.active.getHeaderHoles())) == -1L) {
                    throw new EOFException();
                }
                this.filepos = this.raw.getBytesRead();
                byArray = this.raw.readRecord();
                if (!DumpArchiveUtil.verify(byArray)) {
                    throw new InvalidFormatException();
                }
                this.active = DumpArchiveEntry.parse(byArray);
            }
            if (DumpArchiveConstants.SEGMENT_TYPE.END == this.active.getHeaderType()) {
                this.hasHitEOF = true;
                return null;
            }
            dumpArchiveEntry = this.active;
            if (dumpArchiveEntry.isDirectory()) {
                this.readDirectoryEntry(this.active);
                this.entryOffset = 0L;
                this.entrySize = 0L;
                this.readIdx = this.active.getHeaderCount();
            } else {
                this.entryOffset = 0L;
                this.entrySize = this.active.getEntrySize();
                this.readIdx = 0;
            }
            this.recordOffset = this.readBuf.length;
            string = this.getPath(dumpArchiveEntry);
            if (string != null) continue;
            dumpArchiveEntry = null;
        }
        dumpArchiveEntry.setName(string);
        dumpArchiveEntry.setSimpleName(this.names.get(dumpArchiveEntry.getIno()).getName());
        dumpArchiveEntry.setOffset(this.filepos);
        return dumpArchiveEntry;
    }

    private void readDirectoryEntry(DumpArchiveEntry dumpArchiveEntry) throws IOException {
        long l2 = dumpArchiveEntry.getEntrySize();
        boolean bl2 = true;
        while (bl2 || DumpArchiveConstants.SEGMENT_TYPE.ADDR == dumpArchiveEntry.getHeaderType()) {
            int n2;
            if (!bl2) {
                this.raw.readRecord();
            }
            if (!this.names.containsKey(dumpArchiveEntry.getIno()) && DumpArchiveConstants.SEGMENT_TYPE.INODE == dumpArchiveEntry.getHeaderType()) {
                this.pending.put(dumpArchiveEntry.getIno(), dumpArchiveEntry);
            }
            if (this.blockBuffer.length < (n2 = 1024 * dumpArchiveEntry.getHeaderCount())) {
                this.blockBuffer = new byte[n2];
            }
            if (this.raw.read(this.blockBuffer, 0, n2) != n2) {
                throw new EOFException();
            }
            int n3 = 0;
            for (int i2 = 0; i2 < n2 - 8 && (long)i2 < l2 - 8L; i2 += n3) {
                int n4 = DumpArchiveUtil.convert32(this.blockBuffer, i2);
                n3 = DumpArchiveUtil.convert16(this.blockBuffer, i2 + 4);
                byte by2 = this.blockBuffer[i2 + 6];
                String string = DumpArchiveUtil.decode(this.zipEncoding, this.blockBuffer, i2 + 8, this.blockBuffer[i2 + 7]);
                if (".".equals(string) || "..".equals(string)) continue;
                Dirent dirent = new Dirent(n4, dumpArchiveEntry.getIno(), by2, string);
                this.names.put(n4, dirent);
                for (Map.Entry<Integer, DumpArchiveEntry> entry : this.pending.entrySet()) {
                    String string2 = this.getPath(entry.getValue());
                    if (string2 == null) continue;
                    entry.getValue().setName(string2);
                    entry.getValue().setSimpleName(this.names.get(entry.getKey()).getName());
                    this.queue.add(entry.getValue());
                }
                for (DumpArchiveEntry dumpArchiveEntry2 : this.queue) {
                    this.pending.remove(dumpArchiveEntry2.getIno());
                }
            }
            byte[] byArray = this.raw.peek();
            if (!DumpArchiveUtil.verify(byArray)) {
                throw new InvalidFormatException();
            }
            dumpArchiveEntry = DumpArchiveEntry.parse(byArray);
            bl2 = false;
            l2 -= 1024L;
        }
    }

    private String getPath(DumpArchiveEntry dumpArchiveEntry) {
        Stack<String> stack = new Stack<String>();
        Dirent dirent = null;
        int n2 = dumpArchiveEntry.getIno();
        while (true) {
            if (!this.names.containsKey(n2)) {
                stack.clear();
                break;
            }
            dirent = this.names.get(n2);
            stack.push(dirent.getName());
            if (dirent.getIno() == dirent.getParentIno()) break;
            n2 = dirent.getParentIno();
        }
        if (stack.isEmpty()) {
            this.pending.put(dumpArchiveEntry.getIno(), dumpArchiveEntry);
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder((String)stack.pop());
        while (!stack.isEmpty()) {
            stringBuilder.append('/');
            stringBuilder.append((String)stack.pop());
        }
        return stringBuilder.toString();
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = 0;
        if (this.hasHitEOF || this.isClosed || this.entryOffset >= this.entrySize) {
            return -1;
        }
        if (this.active == null) {
            throw new IllegalStateException("No current dump entry");
        }
        if ((long)n3 + this.entryOffset > this.entrySize) {
            n3 = (int)(this.entrySize - this.entryOffset);
        }
        while (n3 > 0) {
            int n5;
            int n6 = n5 = n3 > this.readBuf.length - this.recordOffset ? this.readBuf.length - this.recordOffset : n3;
            if (this.recordOffset + n5 <= this.readBuf.length) {
                System.arraycopy(this.readBuf, this.recordOffset, byArray, n2, n5);
                n4 += n5;
                this.recordOffset += n5;
                n3 -= n5;
                n2 += n5;
            }
            if (n3 <= 0) continue;
            if (this.readIdx >= 512) {
                byte[] byArray2 = this.raw.readRecord();
                if (!DumpArchiveUtil.verify(byArray2)) {
                    throw new InvalidFormatException();
                }
                this.active = DumpArchiveEntry.parse(byArray2);
                this.readIdx = 0;
            }
            if (!this.active.isSparseRecord(this.readIdx++)) {
                int n7 = this.raw.read(this.readBuf, 0, this.readBuf.length);
                if (n7 != this.readBuf.length) {
                    throw new EOFException();
                }
            } else {
                Arrays.fill(this.readBuf, (byte)0);
            }
            this.recordOffset = 0;
        }
        this.entryOffset += (long)n4;
        return n4;
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed) {
            this.isClosed = true;
            this.raw.close();
        }
    }

    public static boolean matches(byte[] byArray, int n2) {
        if (n2 < 32) {
            return false;
        }
        if (n2 >= 1024) {
            return DumpArchiveUtil.verify(byArray);
        }
        return 60012 == DumpArchiveUtil.convert32(byArray, 24);
    }
}

