/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.compress.archivers.examples;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import zz.org.apache.commons.compress.archivers.ArchiveEntry;
import zz.org.apache.commons.compress.archivers.ArchiveException;
import zz.org.apache.commons.compress.archivers.ArchiveOutputStream;
import zz.org.apache.commons.compress.archivers.ArchiveStreamFactory;
import zz.org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;
import zz.org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import zz.org.apache.commons.compress.utils.IOUtils;

public class Archiver {
    public void create(String string, File file, File file2) throws IOException, ArchiveException {
        if (this.prefersSeekableByteChannel(string)) {
            try (FileChannel fileChannel = FileChannel.open(file.toPath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                this.create(string, fileChannel, file2);
            }
            return;
        }
        try (OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            this.create(string, outputStream, file2);
        }
    }

    public void create(String string, OutputStream outputStream, File file) throws IOException, ArchiveException {
        this.create(new ArchiveStreamFactory().createArchiveOutputStream(string, outputStream), file);
    }

    public void create(String string, SeekableByteChannel seekableByteChannel, File file) throws IOException, ArchiveException {
        if (!this.prefersSeekableByteChannel(string)) {
            this.create(string, Channels.newOutputStream(seekableByteChannel), file);
        } else if ("zip".equalsIgnoreCase(string)) {
            this.create(new ZipArchiveOutputStream(seekableByteChannel), file);
        } else if ("7z".equalsIgnoreCase(string)) {
            this.create(new SevenZOutputFile(seekableByteChannel), file);
        } else {
            throw new ArchiveException("don't know how to handle format " + string);
        }
    }

    public void create(final ArchiveOutputStream archiveOutputStream, File file) throws IOException, ArchiveException {
        this.create(file, new ArchiveEntryCreator(){

            @Override
            public ArchiveEntry create(File file, String string) throws IOException {
                return archiveOutputStream.createArchiveEntry(file, string);
            }
        }, new ArchiveEntryConsumer(){

            @Override
            public void accept(File file, ArchiveEntry archiveEntry) throws IOException {
                archiveOutputStream.putArchiveEntry(archiveEntry);
                if (!archiveEntry.isDirectory()) {
                    try (BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
                        IOUtils.copy(bufferedInputStream, archiveOutputStream);
                    }
                }
                archiveOutputStream.closeArchiveEntry();
            }
        }, new Finisher(){

            @Override
            public void finish() throws IOException {
                archiveOutputStream.finish();
            }
        });
    }

    public void create(final SevenZOutputFile sevenZOutputFile, File file) throws IOException {
        this.create(file, new ArchiveEntryCreator(){

            @Override
            public ArchiveEntry create(File file, String string) throws IOException {
                return sevenZOutputFile.createArchiveEntry(file, string);
            }
        }, new ArchiveEntryConsumer(){

            @Override
            public void accept(File file, ArchiveEntry archiveEntry) throws IOException {
                sevenZOutputFile.putArchiveEntry(archiveEntry);
                if (!archiveEntry.isDirectory()) {
                    byte[] byArray = new byte[8024];
                    int n2 = 0;
                    long l2 = 0L;
                    try (BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
                        while (-1 != (n2 = ((InputStream)bufferedInputStream).read(byArray))) {
                            sevenZOutputFile.write(byArray, 0, n2);
                            l2 += (long)n2;
                        }
                    }
                }
                sevenZOutputFile.closeArchiveEntry();
            }
        }, new Finisher(){

            @Override
            public void finish() throws IOException {
                sevenZOutputFile.finish();
            }
        });
    }

    private boolean prefersSeekableByteChannel(String string) {
        return "zip".equalsIgnoreCase(string) || "7z".equalsIgnoreCase(string);
    }

    private void create(File file, ArchiveEntryCreator archiveEntryCreator, ArchiveEntryConsumer archiveEntryConsumer, Finisher finisher) throws IOException {
        this.create("", file, archiveEntryCreator, archiveEntryConsumer);
        finisher.finish();
    }

    private void create(String string, File file, ArchiveEntryCreator archiveEntryCreator, ArchiveEntryConsumer archiveEntryConsumer) throws IOException {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            String string2 = string + file2.getName() + (file2.isDirectory() ? "/" : "");
            archiveEntryConsumer.accept(file2, archiveEntryCreator.create(file2, string2));
            if (!file2.isDirectory()) continue;
            this.create(string2, file2, archiveEntryCreator, archiveEntryConsumer);
        }
    }

    private static interface Finisher {
        public void finish() throws IOException;
    }

    private static interface ArchiveEntryConsumer {
        public void accept(File var1, ArchiveEntry var2) throws IOException;
    }

    private static interface ArchiveEntryCreator {
        public ArchiveEntry create(File var1, String var2) throws IOException;
    }
}

