/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.compress.archivers.examples;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Enumeration;
import zz.org.apache.commons.compress.archivers.ArchiveEntry;
import zz.org.apache.commons.compress.archivers.ArchiveException;
import zz.org.apache.commons.compress.archivers.ArchiveInputStream;
import zz.org.apache.commons.compress.archivers.ArchiveStreamFactory;
import zz.org.apache.commons.compress.archivers.sevenz.SevenZFile;
import zz.org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import zz.org.apache.commons.compress.archivers.zip.ZipFile;
import zz.org.apache.commons.compress.utils.IOUtils;

public class Expander {
    public void expand(File file, File file2) throws IOException, ArchiveException {
        String string = null;
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            new ArchiveStreamFactory();
            string = ArchiveStreamFactory.detect(bufferedInputStream);
        }
        this.expand(string, file, file2);
    }

    public void expand(String string, File file, File file2) throws IOException, ArchiveException {
        if (this.prefersSeekableByteChannel(string)) {
            try (FileChannel fileChannel = FileChannel.open(file.toPath(), StandardOpenOption.READ);){
                this.expand(string, fileChannel, file2);
            }
            return;
        }
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));){
            this.expand(string, bufferedInputStream, file2);
        }
    }

    public void expand(InputStream inputStream, File file) throws IOException, ArchiveException {
        this.expand(new ArchiveStreamFactory().createArchiveInputStream(inputStream), file);
    }

    public void expand(String string, InputStream inputStream, File file) throws IOException, ArchiveException {
        this.expand(new ArchiveStreamFactory().createArchiveInputStream(string, inputStream), file);
    }

    public void expand(String string, SeekableByteChannel seekableByteChannel, File file) throws IOException, ArchiveException {
        if (!this.prefersSeekableByteChannel(string)) {
            this.expand(string, Channels.newInputStream(seekableByteChannel), file);
        } else if ("zip".equalsIgnoreCase(string)) {
            this.expand(new ZipFile(seekableByteChannel), file);
        } else if ("7z".equalsIgnoreCase(string)) {
            this.expand(new SevenZFile(seekableByteChannel), file);
        } else {
            throw new ArchiveException("don't know how to handle format " + string);
        }
    }

    public void expand(final ArchiveInputStream archiveInputStream, File file) throws IOException, ArchiveException {
        this.expand(new ArchiveEntrySupplier(){

            @Override
            public ArchiveEntry getNextReadableEntry() throws IOException {
                ArchiveEntry archiveEntry = archiveInputStream.getNextEntry();
                while (archiveEntry != null && !archiveInputStream.canReadEntryData(archiveEntry)) {
                    archiveEntry = archiveInputStream.getNextEntry();
                }
                return archiveEntry;
            }
        }, new EntryWriter(){

            @Override
            public void writeEntryDataTo(ArchiveEntry archiveEntry, OutputStream outputStream) throws IOException {
                IOUtils.copy(archiveInputStream, outputStream);
            }
        }, file);
    }

    public void expand(final ZipFile zipFile, File file) throws IOException, ArchiveException {
        final Enumeration<ZipArchiveEntry> enumeration = zipFile.getEntries();
        this.expand(new ArchiveEntrySupplier(){

            @Override
            public ArchiveEntry getNextReadableEntry() throws IOException {
                ZipArchiveEntry zipArchiveEntry;
                ZipArchiveEntry zipArchiveEntry2 = zipArchiveEntry = enumeration.hasMoreElements() ? (ZipArchiveEntry)enumeration.nextElement() : null;
                while (zipArchiveEntry != null && !zipFile.canReadEntryData(zipArchiveEntry)) {
                    zipArchiveEntry = enumeration.hasMoreElements() ? (ZipArchiveEntry)enumeration.nextElement() : null;
                }
                return zipArchiveEntry;
            }
        }, new EntryWriter(){

            @Override
            public void writeEntryDataTo(ArchiveEntry archiveEntry, OutputStream outputStream) throws IOException {
                try (InputStream inputStream = zipFile.getInputStream((ZipArchiveEntry)archiveEntry);){
                    IOUtils.copy(inputStream, outputStream);
                }
            }
        }, file);
    }

    public void expand(final SevenZFile sevenZFile, File file) throws IOException, ArchiveException {
        this.expand(new ArchiveEntrySupplier(){

            @Override
            public ArchiveEntry getNextReadableEntry() throws IOException {
                return sevenZFile.getNextEntry();
            }
        }, new EntryWriter(){

            @Override
            public void writeEntryDataTo(ArchiveEntry archiveEntry, OutputStream outputStream) throws IOException {
                byte[] byArray = new byte[8024];
                int n2 = 0;
                long l2 = 0L;
                while (-1 != (n2 = sevenZFile.read(byArray))) {
                    outputStream.write(byArray, 0, n2);
                    l2 += (long)n2;
                }
            }
        }, file);
    }

    private boolean prefersSeekableByteChannel(String string) {
        return "zip".equalsIgnoreCase(string) || "7z".equalsIgnoreCase(string);
    }

    private void expand(ArchiveEntrySupplier archiveEntrySupplier, EntryWriter entryWriter, File file) throws IOException {
        String string = file.getCanonicalPath();
        if (!string.endsWith(File.separator)) {
            string = string + File.separatorChar;
        }
        ArchiveEntry archiveEntry = archiveEntrySupplier.getNextReadableEntry();
        while (archiveEntry != null) {
            File file2 = new File(file, archiveEntry.getName());
            if (!file2.getCanonicalPath().startsWith(string)) {
                throw new IOException("expanding " + archiveEntry.getName() + " would create file outside of " + file);
            }
            if (archiveEntry.isDirectory()) {
                if (!file2.isDirectory() && !file2.mkdirs()) {
                    throw new IOException("failed to create directory " + file2);
                }
            } else {
                File file3 = file2.getParentFile();
                if (!file3.isDirectory() && !file3.mkdirs()) {
                    throw new IOException("failed to create directory " + file3);
                }
                try (OutputStream outputStream = Files.newOutputStream(file2.toPath(), new OpenOption[0]);){
                    entryWriter.writeEntryDataTo(archiveEntry, outputStream);
                }
            }
            archiveEntry = archiveEntrySupplier.getNextReadableEntry();
        }
    }

    private static interface EntryWriter {
        public void writeEntryDataTo(ArchiveEntry var1, OutputStream var2) throws IOException;
    }

    private static interface ArchiveEntrySupplier {
        public ArchiveEntry getNextReadableEntry() throws IOException;
    }
}

