/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.compress.archivers.sevenz;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;

class BoundedSeekableByteChannelInputStream
extends InputStream {
    private static final int MAX_BUF_LEN = 8192;
    private final ByteBuffer buffer;
    private final SeekableByteChannel channel;
    private long bytesRemaining;

    public BoundedSeekableByteChannelInputStream(SeekableByteChannel seekableByteChannel, long l2) {
        this.channel = seekableByteChannel;
        this.bytesRemaining = l2;
        this.buffer = l2 < 8192L && l2 > 0L ? ByteBuffer.allocate((int)l2) : ByteBuffer.allocate(8192);
    }

    @Override
    public int read() throws IOException {
        if (this.bytesRemaining > 0L) {
            --this.bytesRemaining;
            int n2 = this.read(1);
            if (n2 < 0) {
                return n2;
            }
            return this.buffer.get() & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        ByteBuffer byteBuffer;
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        int n5 = n3;
        if ((long)n5 > this.bytesRemaining) {
            n5 = (int)this.bytesRemaining;
        }
        if (n5 <= this.buffer.capacity()) {
            byteBuffer = this.buffer;
            n4 = this.read(n5);
        } else {
            byteBuffer = ByteBuffer.allocate(n5);
            n4 = this.channel.read(byteBuffer);
            byteBuffer.flip();
        }
        if (n4 >= 0) {
            byteBuffer.get(byArray, n2, n4);
            this.bytesRemaining -= (long)n4;
        }
        return n4;
    }

    private int read(int n2) throws IOException {
        this.buffer.rewind().limit(n2);
        int n3 = this.channel.read(this.buffer);
        this.buffer.flip();
        return n3;
    }

    @Override
    public void close() {
    }
}

