/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.compress.archivers.zip;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipException;
import zz.org.apache.commons.compress.archivers.zip.AsiExtraField;
import zz.org.apache.commons.compress.archivers.zip.JarMarker;
import zz.org.apache.commons.compress.archivers.zip.ResourceAlignmentExtraField;
import zz.org.apache.commons.compress.archivers.zip.UnicodeCommentExtraField;
import zz.org.apache.commons.compress.archivers.zip.UnicodePathExtraField;
import zz.org.apache.commons.compress.archivers.zip.UnparseableExtraFieldData;
import zz.org.apache.commons.compress.archivers.zip.UnrecognizedExtraField;
import zz.org.apache.commons.compress.archivers.zip.X000A_NTFS;
import zz.org.apache.commons.compress.archivers.zip.X0014_X509Certificates;
import zz.org.apache.commons.compress.archivers.zip.X0015_CertificateIdForFile;
import zz.org.apache.commons.compress.archivers.zip.X0016_CertificateIdForCentralDirectory;
import zz.org.apache.commons.compress.archivers.zip.X0017_StrongEncryptionHeader;
import zz.org.apache.commons.compress.archivers.zip.X0019_EncryptionRecipientCertificateList;
import zz.org.apache.commons.compress.archivers.zip.X5455_ExtendedTimestamp;
import zz.org.apache.commons.compress.archivers.zip.X7875_NewUnix;
import zz.org.apache.commons.compress.archivers.zip.Zip64ExtendedInformationExtraField;
import zz.org.apache.commons.compress.archivers.zip.ZipExtraField;
import zz.org.apache.commons.compress.archivers.zip.ZipShort;

public class ExtraFieldUtils {
    private static final int WORD = 4;
    private static final Map<ZipShort, Class<?>> implementations = new ConcurrentHashMap();

    public static void register(Class<?> clazz) {
        try {
            ZipExtraField zipExtraField = (ZipExtraField)clazz.newInstance();
            implementations.put(zipExtraField.getHeaderId(), clazz);
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException(clazz + " doesn't implement ZipExtraField");
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(clazz + " is not a concrete class");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(clazz + "'s no-arg constructor is not public");
        }
    }

    public static ZipExtraField createExtraField(ZipShort zipShort) throws InstantiationException, IllegalAccessException {
        Class<?> clazz = implementations.get(zipShort);
        if (clazz != null) {
            return (ZipExtraField)clazz.newInstance();
        }
        UnrecognizedExtraField unrecognizedExtraField = new UnrecognizedExtraField();
        unrecognizedExtraField.setHeaderId(zipShort);
        return unrecognizedExtraField;
    }

    public static ZipExtraField[] parse(byte[] byArray) throws ZipException {
        return ExtraFieldUtils.parse(byArray, true, UnparseableExtraField.THROW);
    }

    public static ZipExtraField[] parse(byte[] byArray, boolean bl2) throws ZipException {
        return ExtraFieldUtils.parse(byArray, bl2, UnparseableExtraField.THROW);
    }

    public static ZipExtraField[] parse(byte[] byArray, boolean bl2, UnparseableExtraField unparseableExtraField) throws ZipException {
        Object object;
        int n2;
        ArrayList<ZipExtraField> arrayList = new ArrayList<ZipExtraField>();
        block9: for (int i2 = 0; i2 <= byArray.length - 4; i2 += n2 + 4) {
            ZipExtraField zipExtraField;
            object = new ZipShort(byArray, i2);
            n2 = new ZipShort(byArray, i2 + 2).getValue();
            if (i2 + 4 + n2 > byArray.length) {
                switch (unparseableExtraField.getKey()) {
                    case 0: {
                        throw new ZipException("bad extra field starting at " + i2 + ".  Block length of " + n2 + " bytes exceeds remaining data of " + (byArray.length - i2 - 4) + " bytes.");
                    }
                    case 2: {
                        zipExtraField = new UnparseableExtraFieldData();
                        if (bl2) {
                            ((UnparseableExtraFieldData)zipExtraField).parseFromLocalFileData(byArray, i2, byArray.length - i2);
                        } else {
                            ((UnparseableExtraFieldData)zipExtraField).parseFromCentralDirectoryData(byArray, i2, byArray.length - i2);
                        }
                        arrayList.add(zipExtraField);
                    }
                    case 1: {
                        break block9;
                    }
                    default: {
                        throw new ZipException("unknown UnparseableExtraField key: " + unparseableExtraField.getKey());
                    }
                }
            }
            try {
                zipExtraField = ExtraFieldUtils.createExtraField((ZipShort)object);
                try {
                    if (bl2) {
                        zipExtraField.parseFromLocalFileData(byArray, i2 + 4, n2);
                    } else {
                        zipExtraField.parseFromCentralDirectoryData(byArray, i2 + 4, n2);
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw (ZipException)new ZipException("Failed to parse corrupt ZIP extra field of type " + Integer.toHexString(((ZipShort)object).getValue())).initCause(arrayIndexOutOfBoundsException);
                }
                arrayList.add(zipExtraField);
                continue;
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                throw (ZipException)new ZipException(reflectiveOperationException.getMessage()).initCause(reflectiveOperationException);
            }
        }
        object = new ZipExtraField[arrayList.size()];
        return arrayList.toArray((T[])object);
    }

    public static byte[] mergeLocalFileDataData(ZipExtraField[] zipExtraFieldArray) {
        byte[] byArray;
        boolean bl2 = zipExtraFieldArray.length > 0 && zipExtraFieldArray[zipExtraFieldArray.length - 1] instanceof UnparseableExtraFieldData;
        int n2 = bl2 ? zipExtraFieldArray.length - 1 : zipExtraFieldArray.length;
        int n3 = 4 * n2;
        for (ZipExtraField zipExtraField : zipExtraFieldArray) {
            n3 += zipExtraField.getLocalFileDataLength().getValue();
        }
        byte[] byArray2 = new byte[n3];
        int n4 = 0;
        for (int byArray3 = 0; byArray3 < n2; ++byArray3) {
            System.arraycopy(zipExtraFieldArray[byArray3].getHeaderId().getBytes(), 0, byArray2, n4, 2);
            System.arraycopy(zipExtraFieldArray[byArray3].getLocalFileDataLength().getBytes(), 0, byArray2, n4 + 2, 2);
            n4 += 4;
            byte[] byArray4 = zipExtraFieldArray[byArray3].getLocalFileDataData();
            if (byArray4 == null) continue;
            System.arraycopy(byArray4, 0, byArray2, n4, byArray4.length);
            n4 += byArray4.length;
        }
        if (bl2 && (byArray = zipExtraFieldArray[zipExtraFieldArray.length - 1].getLocalFileDataData()) != null) {
            System.arraycopy(byArray, 0, byArray2, n4, byArray.length);
        }
        return byArray2;
    }

    public static byte[] mergeCentralDirectoryData(ZipExtraField[] zipExtraFieldArray) {
        byte[] byArray;
        boolean bl2 = zipExtraFieldArray.length > 0 && zipExtraFieldArray[zipExtraFieldArray.length - 1] instanceof UnparseableExtraFieldData;
        int n2 = bl2 ? zipExtraFieldArray.length - 1 : zipExtraFieldArray.length;
        int n3 = 4 * n2;
        for (ZipExtraField zipExtraField : zipExtraFieldArray) {
            n3 += zipExtraField.getCentralDirectoryLength().getValue();
        }
        byte[] byArray2 = new byte[n3];
        int n4 = 0;
        for (int byArray3 = 0; byArray3 < n2; ++byArray3) {
            System.arraycopy(zipExtraFieldArray[byArray3].getHeaderId().getBytes(), 0, byArray2, n4, 2);
            System.arraycopy(zipExtraFieldArray[byArray3].getCentralDirectoryLength().getBytes(), 0, byArray2, n4 + 2, 2);
            n4 += 4;
            byte[] byArray4 = zipExtraFieldArray[byArray3].getCentralDirectoryData();
            if (byArray4 == null) continue;
            System.arraycopy(byArray4, 0, byArray2, n4, byArray4.length);
            n4 += byArray4.length;
        }
        if (bl2 && (byArray = zipExtraFieldArray[zipExtraFieldArray.length - 1].getCentralDirectoryData()) != null) {
            System.arraycopy(byArray, 0, byArray2, n4, byArray.length);
        }
        return byArray2;
    }

    static {
        ExtraFieldUtils.register(AsiExtraField.class);
        ExtraFieldUtils.register(X5455_ExtendedTimestamp.class);
        ExtraFieldUtils.register(X7875_NewUnix.class);
        ExtraFieldUtils.register(JarMarker.class);
        ExtraFieldUtils.register(UnicodePathExtraField.class);
        ExtraFieldUtils.register(UnicodeCommentExtraField.class);
        ExtraFieldUtils.register(Zip64ExtendedInformationExtraField.class);
        ExtraFieldUtils.register(X000A_NTFS.class);
        ExtraFieldUtils.register(X0014_X509Certificates.class);
        ExtraFieldUtils.register(X0015_CertificateIdForFile.class);
        ExtraFieldUtils.register(X0016_CertificateIdForCentralDirectory.class);
        ExtraFieldUtils.register(X0017_StrongEncryptionHeader.class);
        ExtraFieldUtils.register(X0019_EncryptionRecipientCertificateList.class);
        ExtraFieldUtils.register(ResourceAlignmentExtraField.class);
    }

    public static final class UnparseableExtraField {
        public static final int THROW_KEY = 0;
        public static final int SKIP_KEY = 1;
        public static final int READ_KEY = 2;
        public static final UnparseableExtraField THROW = new UnparseableExtraField(0);
        public static final UnparseableExtraField SKIP = new UnparseableExtraField(1);
        public static final UnparseableExtraField READ = new UnparseableExtraField(2);
        private final int key;

        private UnparseableExtraField(int n2) {
            this.key = n2;
        }

        public int getKey() {
            return this.key;
        }
    }
}

