/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.compress.archivers.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import zz.org.apache.commons.compress.utils.InputStreamStatistics;

class InflaterInputStreamWithStatistics
extends InflaterInputStream
implements InputStreamStatistics {
    private long compressedCount = 0L;
    private long uncompressedCount = 0L;

    public InflaterInputStreamWithStatistics(InputStream inputStream) {
        super(inputStream);
    }

    public InflaterInputStreamWithStatistics(InputStream inputStream, Inflater inflater) {
        super(inputStream, inflater);
    }

    public InflaterInputStreamWithStatistics(InputStream inputStream, Inflater inflater, int n2) {
        super(inputStream, inflater, n2);
    }

    @Override
    protected void fill() throws IOException {
        super.fill();
        this.compressedCount += (long)this.inf.getRemaining();
    }

    @Override
    public int read() throws IOException {
        int n2 = super.read();
        if (n2 > -1) {
            ++this.uncompressedCount;
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = super.read(byArray, n2, n3);
        if (n4 > -1) {
            this.uncompressedCount += (long)n4;
        }
        return n4;
    }

    @Override
    public long getCompressedCount() {
        return this.compressedCount;
    }

    @Override
    public long getUncompressedCount() {
        return this.uncompressedCount;
    }
}

