/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.compress.archivers.zip;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import zz.org.apache.commons.compress.archivers.zip.ZipExtraField;
import zz.org.apache.commons.compress.archivers.zip.ZipShort;
import zz.org.apache.commons.compress.archivers.zip.ZipUtil;

public abstract class PKWareExtraHeader
implements ZipExtraField {
    private final ZipShort headerId;
    private byte[] localData;
    private byte[] centralData;

    protected PKWareExtraHeader(ZipShort zipShort) {
        this.headerId = zipShort;
    }

    @Override
    public ZipShort getHeaderId() {
        return this.headerId;
    }

    public void setLocalFileDataData(byte[] byArray) {
        this.localData = ZipUtil.copy(byArray);
    }

    @Override
    public ZipShort getLocalFileDataLength() {
        return new ZipShort(this.localData != null ? this.localData.length : 0);
    }

    @Override
    public byte[] getLocalFileDataData() {
        return ZipUtil.copy(this.localData);
    }

    public void setCentralDirectoryData(byte[] byArray) {
        this.centralData = ZipUtil.copy(byArray);
    }

    @Override
    public ZipShort getCentralDirectoryLength() {
        if (this.centralData != null) {
            return new ZipShort(this.centralData.length);
        }
        return this.getLocalFileDataLength();
    }

    @Override
    public byte[] getCentralDirectoryData() {
        if (this.centralData != null) {
            return ZipUtil.copy(this.centralData);
        }
        return this.getLocalFileDataData();
    }

    @Override
    public void parseFromLocalFileData(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        this.setLocalFileDataData(byArray2);
    }

    @Override
    public void parseFromCentralDirectoryData(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        this.setCentralDirectoryData(byArray2);
        if (this.localData == null) {
            this.setLocalFileDataData(byArray2);
        }
    }

    public static enum HashAlgorithm {
        NONE(0),
        CRC32(1),
        MD5(32771),
        SHA1(32772),
        RIPEND160(32775),
        SHA256(32780),
        SHA384(32781),
        SHA512(32782);

        private final int code;
        private static final Map<Integer, HashAlgorithm> codeToEnum;

        private HashAlgorithm(int n3) {
            this.code = n3;
        }

        public int getCode() {
            return this.code;
        }

        public static HashAlgorithm getAlgorithmByCode(int n2) {
            return codeToEnum.get(n2);
        }

        static {
            HashMap<Integer, HashAlgorithm> hashMap = new HashMap<Integer, HashAlgorithm>();
            for (HashAlgorithm hashAlgorithm : HashAlgorithm.values()) {
                hashMap.put(hashAlgorithm.getCode(), hashAlgorithm);
            }
            codeToEnum = Collections.unmodifiableMap(hashMap);
        }
    }

    public static enum EncryptionAlgorithm {
        DES(26113),
        RC2pre52(26114),
        TripleDES168(26115),
        TripleDES192(26121),
        AES128(26126),
        AES192(26127),
        AES256(26128),
        RC2(26370),
        RC4(26625),
        UNKNOWN(65535);

        private final int code;
        private static final Map<Integer, EncryptionAlgorithm> codeToEnum;

        private EncryptionAlgorithm(int n3) {
            this.code = n3;
        }

        public int getCode() {
            return this.code;
        }

        public static EncryptionAlgorithm getAlgorithmByCode(int n2) {
            return codeToEnum.get(n2);
        }

        static {
            HashMap<Integer, EncryptionAlgorithm> hashMap = new HashMap<Integer, EncryptionAlgorithm>();
            for (EncryptionAlgorithm encryptionAlgorithm : EncryptionAlgorithm.values()) {
                hashMap.put(encryptionAlgorithm.getCode(), encryptionAlgorithm);
            }
            codeToEnum = Collections.unmodifiableMap(hashMap);
        }
    }
}

