/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.compress.archivers.zip;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import zz.org.apache.commons.compress.archivers.zip.ScatterStatistics;
import zz.org.apache.commons.compress.archivers.zip.ScatterZipOutputStream;
import zz.org.apache.commons.compress.archivers.zip.StreamCompressor;
import zz.org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import zz.org.apache.commons.compress.archivers.zip.ZipArchiveEntryRequest;
import zz.org.apache.commons.compress.archivers.zip.ZipArchiveEntryRequestSupplier;
import zz.org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import zz.org.apache.commons.compress.parallel.FileBasedScatterGatherBackingStore;
import zz.org.apache.commons.compress.parallel.InputStreamSupplier;
import zz.org.apache.commons.compress.parallel.ScatterGatherBackingStore;
import zz.org.apache.commons.compress.parallel.ScatterGatherBackingStoreSupplier;

public class ParallelScatterZipCreator {
    private final List<ScatterZipOutputStream> streams = Collections.synchronizedList(new ArrayList());
    private final ExecutorService es;
    private final ScatterGatherBackingStoreSupplier backingStoreSupplier;
    private final List<Future<Object>> futures = new ArrayList<Future<Object>>();
    private final long startedAt = System.currentTimeMillis();
    private long compressionDoneAt = 0L;
    private long scatterDoneAt;
    private final ThreadLocal<ScatterZipOutputStream> tlScatterStreams = new ThreadLocal<ScatterZipOutputStream>(){

        @Override
        protected ScatterZipOutputStream initialValue() {
            try {
                ScatterZipOutputStream scatterZipOutputStream = ParallelScatterZipCreator.this.createDeferred(ParallelScatterZipCreator.this.backingStoreSupplier);
                ParallelScatterZipCreator.this.streams.add(scatterZipOutputStream);
                return scatterZipOutputStream;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    };

    private ScatterZipOutputStream createDeferred(ScatterGatherBackingStoreSupplier scatterGatherBackingStoreSupplier) throws IOException {
        ScatterGatherBackingStore scatterGatherBackingStore = scatterGatherBackingStoreSupplier.get();
        StreamCompressor streamCompressor = StreamCompressor.create(-1, scatterGatherBackingStore);
        return new ScatterZipOutputStream(scatterGatherBackingStore, streamCompressor);
    }

    public ParallelScatterZipCreator() {
        this(Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()));
    }

    public ParallelScatterZipCreator(ExecutorService executorService) {
        this(executorService, new DefaultBackingStoreSupplier());
    }

    public ParallelScatterZipCreator(ExecutorService executorService, ScatterGatherBackingStoreSupplier scatterGatherBackingStoreSupplier) {
        this.backingStoreSupplier = scatterGatherBackingStoreSupplier;
        this.es = executorService;
    }

    public void addArchiveEntry(ZipArchiveEntry zipArchiveEntry, InputStreamSupplier inputStreamSupplier) {
        this.submit(this.createCallable(zipArchiveEntry, inputStreamSupplier));
    }

    public void addArchiveEntry(ZipArchiveEntryRequestSupplier zipArchiveEntryRequestSupplier) {
        this.submit(this.createCallable(zipArchiveEntryRequestSupplier));
    }

    public final void submit(Callable<Object> callable) {
        this.futures.add(this.es.submit(callable));
    }

    public final Callable<Object> createCallable(ZipArchiveEntry zipArchiveEntry, InputStreamSupplier inputStreamSupplier) {
        int n2 = zipArchiveEntry.getMethod();
        if (n2 == -1) {
            throw new IllegalArgumentException("Method must be set on zipArchiveEntry: " + zipArchiveEntry);
        }
        final ZipArchiveEntryRequest zipArchiveEntryRequest = ZipArchiveEntryRequest.createZipArchiveEntryRequest(zipArchiveEntry, inputStreamSupplier);
        return new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ((ScatterZipOutputStream)ParallelScatterZipCreator.this.tlScatterStreams.get()).addArchiveEntry(zipArchiveEntryRequest);
                return null;
            }
        };
    }

    public final Callable<Object> createCallable(final ZipArchiveEntryRequestSupplier zipArchiveEntryRequestSupplier) {
        return new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ((ScatterZipOutputStream)ParallelScatterZipCreator.this.tlScatterStreams.get()).addArchiveEntry(zipArchiveEntryRequestSupplier.get());
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(ZipArchiveOutputStream zipArchiveOutputStream) throws IOException, InterruptedException, ExecutionException {
        try {
            for (Future<Object> object : this.futures) {
                object.get();
            }
        }
        finally {
            this.es.shutdown();
        }
        this.es.awaitTermination(60000L, TimeUnit.SECONDS);
        this.compressionDoneAt = System.currentTimeMillis();
        List<ScatterZipOutputStream> list = this.streams;
        synchronized (list) {
            for (ScatterZipOutputStream scatterZipOutputStream : this.streams) {
                scatterZipOutputStream.writeTo(zipArchiveOutputStream);
                scatterZipOutputStream.close();
            }
        }
        this.scatterDoneAt = System.currentTimeMillis();
    }

    public ScatterStatistics getStatisticsMessage() {
        return new ScatterStatistics(this.compressionDoneAt - this.startedAt, this.scatterDoneAt - this.compressionDoneAt);
    }

    private static class DefaultBackingStoreSupplier
    implements ScatterGatherBackingStoreSupplier {
        final AtomicInteger storeNum = new AtomicInteger(0);

        private DefaultBackingStoreSupplier() {
        }

        @Override
        public ScatterGatherBackingStore get() throws IOException {
            File file = File.createTempFile("parallelscatter", "n" + this.storeNum.incrementAndGet());
            return new FileBasedScatterGatherBackingStore(file);
        }
    }
}

