/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.compress.archivers.zip;

import zz.org.apache.commons.compress.archivers.zip.ZipExtraField;
import zz.org.apache.commons.compress.archivers.zip.ZipShort;
import zz.org.apache.commons.compress.archivers.zip.ZipUtil;

public final class UnparseableExtraFieldData
implements ZipExtraField {
    private static final ZipShort HEADER_ID = new ZipShort(44225);
    private byte[] localFileData;
    private byte[] centralDirectoryData;

    @Override
    public ZipShort getHeaderId() {
        return HEADER_ID;
    }

    @Override
    public ZipShort getLocalFileDataLength() {
        return new ZipShort(this.localFileData == null ? 0 : this.localFileData.length);
    }

    @Override
    public ZipShort getCentralDirectoryLength() {
        return this.centralDirectoryData == null ? this.getLocalFileDataLength() : new ZipShort(this.centralDirectoryData.length);
    }

    @Override
    public byte[] getLocalFileDataData() {
        return ZipUtil.copy(this.localFileData);
    }

    @Override
    public byte[] getCentralDirectoryData() {
        return this.centralDirectoryData == null ? this.getLocalFileDataData() : ZipUtil.copy(this.centralDirectoryData);
    }

    @Override
    public void parseFromLocalFileData(byte[] byArray, int n2, int n3) {
        this.localFileData = new byte[n3];
        System.arraycopy(byArray, n2, this.localFileData, 0, n3);
    }

    @Override
    public void parseFromCentralDirectoryData(byte[] byArray, int n2, int n3) {
        this.centralDirectoryData = new byte[n3];
        System.arraycopy(byArray, n2, this.centralDirectoryData, 0, n3);
        if (this.localFileData == null) {
            this.parseFromLocalFileData(byArray, n2, n3);
        }
    }
}

