/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.compress.archivers.zip;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import zz.org.apache.commons.compress.archivers.zip.ExplodingInputStream;
import zz.org.apache.commons.compress.archivers.zip.GeneralPurposeBit;
import zz.org.apache.commons.compress.archivers.zip.InflaterInputStreamWithStatistics;
import zz.org.apache.commons.compress.archivers.zip.UnshrinkingInputStream;
import zz.org.apache.commons.compress.archivers.zip.Zip64ExtendedInformationExtraField;
import zz.org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import zz.org.apache.commons.compress.archivers.zip.ZipArchiveEntryPredicate;
import zz.org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import zz.org.apache.commons.compress.archivers.zip.ZipEightByteInteger;
import zz.org.apache.commons.compress.archivers.zip.ZipEncoding;
import zz.org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import zz.org.apache.commons.compress.archivers.zip.ZipLong;
import zz.org.apache.commons.compress.archivers.zip.ZipMethod;
import zz.org.apache.commons.compress.archivers.zip.ZipShort;
import zz.org.apache.commons.compress.archivers.zip.ZipUtil;
import zz.org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import zz.org.apache.commons.compress.compressors.deflate64.Deflate64CompressorInputStream;
import zz.org.apache.commons.compress.utils.CountingInputStream;
import zz.org.apache.commons.compress.utils.IOUtils;
import zz.org.apache.commons.compress.utils.InputStreamStatistics;

public class ZipFile
implements Closeable {
    private static final int HASH_SIZE = 509;
    static final int NIBLET_MASK = 15;
    static final int BYTE_SHIFT = 8;
    private static final int POS_0 = 0;
    private static final int POS_1 = 1;
    private static final int POS_2 = 2;
    private static final int POS_3 = 3;
    private static final byte[] ONE_ZERO_BYTE = new byte[1];
    private final List<ZipArchiveEntry> entries = new LinkedList<ZipArchiveEntry>();
    private final Map<String, LinkedList<ZipArchiveEntry>> nameMap = new HashMap<String, LinkedList<ZipArchiveEntry>>(509);
    private final String encoding;
    private final ZipEncoding zipEncoding;
    private final String archiveName;
    private final SeekableByteChannel archive;
    private final boolean useUnicodeExtraFields;
    private volatile boolean closed = true;
    private final byte[] dwordBuf = new byte[8];
    private final byte[] wordBuf = new byte[4];
    private final byte[] cfhBuf = new byte[42];
    private final byte[] shortBuf = new byte[2];
    private final ByteBuffer dwordBbuf = ByteBuffer.wrap(this.dwordBuf);
    private final ByteBuffer wordBbuf = ByteBuffer.wrap(this.wordBuf);
    private final ByteBuffer cfhBbuf = ByteBuffer.wrap(this.cfhBuf);
    private static final int CFH_LEN = 42;
    private static final long CFH_SIG = ZipLong.getValue(ZipArchiveOutputStream.CFH_SIG);
    static final int MIN_EOCD_SIZE = 22;
    private static final int MAX_EOCD_SIZE = 65557;
    private static final int CFD_LOCATOR_OFFSET = 16;
    private static final int ZIP64_EOCDL_LENGTH = 20;
    private static final int ZIP64_EOCDL_LOCATOR_OFFSET = 8;
    private static final int ZIP64_EOCD_CFD_LOCATOR_OFFSET = 48;
    private static final long LFH_OFFSET_FOR_FILENAME_LENGTH = 26L;
    private final Comparator<ZipArchiveEntry> offsetComparator = new Comparator<ZipArchiveEntry>(){

        @Override
        public int compare(ZipArchiveEntry zipArchiveEntry, ZipArchiveEntry zipArchiveEntry2) {
            Entry entry;
            if (zipArchiveEntry == zipArchiveEntry2) {
                return 0;
            }
            Entry entry2 = zipArchiveEntry instanceof Entry ? (Entry)zipArchiveEntry : null;
            Entry entry3 = entry = zipArchiveEntry2 instanceof Entry ? (Entry)zipArchiveEntry2 : null;
            if (entry2 == null) {
                return 1;
            }
            if (entry == null) {
                return -1;
            }
            long l2 = entry2.getLocalHeaderOffset() - entry.getLocalHeaderOffset();
            return l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
        }
    };

    public ZipFile(File file) throws IOException {
        this(file, "UTF8");
    }

    public ZipFile(String string) throws IOException {
        this(new File(string), "UTF8");
    }

    public ZipFile(String string, String string2) throws IOException {
        this(new File(string), string2, true);
    }

    public ZipFile(File file, String string) throws IOException {
        this(file, string, true);
    }

    public ZipFile(File file, String string, boolean bl2) throws IOException {
        this(Files.newByteChannel(file.toPath(), EnumSet.of(StandardOpenOption.READ), new FileAttribute[0]), file.getAbsolutePath(), string, bl2, true);
    }

    public ZipFile(SeekableByteChannel seekableByteChannel) throws IOException {
        this(seekableByteChannel, "unknown archive", "UTF8", true);
    }

    public ZipFile(SeekableByteChannel seekableByteChannel, String string) throws IOException {
        this(seekableByteChannel, "unknown archive", string, true);
    }

    public ZipFile(SeekableByteChannel seekableByteChannel, String string, String string2, boolean bl2) throws IOException {
        this(seekableByteChannel, string, string2, bl2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZipFile(SeekableByteChannel seekableByteChannel, String string, String string2, boolean bl2, boolean bl3) throws IOException {
        this.archiveName = string;
        this.encoding = string2;
        this.zipEncoding = ZipEncodingHelper.getZipEncoding(string2);
        this.useUnicodeExtraFields = bl2;
        this.archive = seekableByteChannel;
        boolean bl4 = false;
        try {
            Map<ZipArchiveEntry, NameAndComment> map = this.populateFromCentralDirectory();
            this.resolveLocalFileHeaderData(map);
            bl4 = true;
            boolean bl5 = this.closed = !bl4;
        }
        catch (Throwable throwable) {
            boolean bl6 = this.closed = !bl4;
            if (!bl4 && bl3) {
                IOUtils.closeQuietly(this.archive);
            }
            throw throwable;
        }
        if (!bl4 && bl3) {
            IOUtils.closeQuietly(this.archive);
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.archive.close();
    }

    public static void closeQuietly(ZipFile zipFile) {
        IOUtils.closeQuietly(zipFile);
    }

    public Enumeration<ZipArchiveEntry> getEntries() {
        return Collections.enumeration(this.entries);
    }

    public Enumeration<ZipArchiveEntry> getEntriesInPhysicalOrder() {
        ZipArchiveEntry[] zipArchiveEntryArray = this.entries.toArray(new ZipArchiveEntry[this.entries.size()]);
        Arrays.sort(zipArchiveEntryArray, this.offsetComparator);
        return Collections.enumeration(Arrays.asList(zipArchiveEntryArray));
    }

    public ZipArchiveEntry getEntry(String string) {
        LinkedList<ZipArchiveEntry> linkedList = this.nameMap.get(string);
        return linkedList != null ? linkedList.getFirst() : null;
    }

    public Iterable<ZipArchiveEntry> getEntries(String string) {
        List<ZipArchiveEntry> list = (List<ZipArchiveEntry>)this.nameMap.get(string);
        return list != null ? list : Collections.emptyList();
    }

    public Iterable<ZipArchiveEntry> getEntriesInPhysicalOrder(String string) {
        ZipArchiveEntry[] zipArchiveEntryArray = new ZipArchiveEntry[]{};
        if (this.nameMap.containsKey(string)) {
            zipArchiveEntryArray = this.nameMap.get(string).toArray(zipArchiveEntryArray);
            Arrays.sort(zipArchiveEntryArray, this.offsetComparator);
        }
        return Arrays.asList(zipArchiveEntryArray);
    }

    public boolean canReadEntryData(ZipArchiveEntry zipArchiveEntry) {
        return ZipUtil.canHandleEntryData(zipArchiveEntry);
    }

    public InputStream getRawInputStream(ZipArchiveEntry zipArchiveEntry) {
        if (!(zipArchiveEntry instanceof Entry)) {
            return null;
        }
        long l2 = zipArchiveEntry.getDataOffset();
        return this.createBoundedInputStream(l2, zipArchiveEntry.getCompressedSize());
    }

    public void copyRawEntries(ZipArchiveOutputStream zipArchiveOutputStream, ZipArchiveEntryPredicate zipArchiveEntryPredicate) throws IOException {
        Enumeration<ZipArchiveEntry> enumeration = this.getEntriesInPhysicalOrder();
        while (enumeration.hasMoreElements()) {
            ZipArchiveEntry zipArchiveEntry = enumeration.nextElement();
            if (!zipArchiveEntryPredicate.test(zipArchiveEntry)) continue;
            zipArchiveOutputStream.addRawArchiveEntry(zipArchiveEntry, this.getRawInputStream(zipArchiveEntry));
        }
    }

    public InputStream getInputStream(ZipArchiveEntry zipArchiveEntry) throws IOException {
        if (!(zipArchiveEntry instanceof Entry)) {
            return null;
        }
        ZipUtil.checkRequestedFeatures(zipArchiveEntry);
        long l2 = zipArchiveEntry.getDataOffset();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(this.createBoundedInputStream(l2, zipArchiveEntry.getCompressedSize()));
        switch (ZipMethod.getMethodByCode(zipArchiveEntry.getMethod())) {
            case STORED: {
                return new StoredStatisticsStream(bufferedInputStream);
            }
            case UNSHRINKING: {
                return new UnshrinkingInputStream(bufferedInputStream);
            }
            case IMPLODING: {
                return new ExplodingInputStream(zipArchiveEntry.getGeneralPurposeBit().getSlidingDictionarySize(), zipArchiveEntry.getGeneralPurposeBit().getNumberOfShannonFanoTrees(), bufferedInputStream);
            }
            case DEFLATED: {
                final Inflater inflater = new Inflater(true);
                return new InflaterInputStreamWithStatistics(new SequenceInputStream(bufferedInputStream, new ByteArrayInputStream(ONE_ZERO_BYTE)), inflater){

                    @Override
                    public void close() throws IOException {
                        try {
                            super.close();
                        }
                        finally {
                            inflater.end();
                        }
                    }
                };
            }
            case BZIP2: {
                return new BZip2CompressorInputStream(bufferedInputStream);
            }
            case ENHANCED_DEFLATED: {
                return new Deflate64CompressorInputStream(bufferedInputStream);
            }
        }
        throw new ZipException("Found unsupported compression method " + zipArchiveEntry.getMethod());
    }

    public String getUnixSymlink(ZipArchiveEntry zipArchiveEntry) throws IOException {
        if (zipArchiveEntry != null && zipArchiveEntry.isUnixSymlink()) {
            try (InputStream inputStream = this.getInputStream(zipArchiveEntry);){
                String string = this.zipEncoding.decode(IOUtils.toByteArray(inputStream));
                return string;
            }
        }
        return null;
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.closed) {
                System.err.println("Cleaning up unclosed ZipFile for archive " + this.archiveName);
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    private Map<ZipArchiveEntry, NameAndComment> populateFromCentralDirectory() throws IOException {
        HashMap<ZipArchiveEntry, NameAndComment> hashMap = new HashMap<ZipArchiveEntry, NameAndComment>();
        this.positionAtCentralDirectory();
        this.wordBbuf.rewind();
        IOUtils.readFully(this.archive, this.wordBbuf);
        long l2 = ZipLong.getValue(this.wordBuf);
        if (l2 != CFH_SIG && this.startsWithLocalFileHeader()) {
            throw new IOException("central directory is empty, can't expand corrupt archive.");
        }
        while (l2 == CFH_SIG) {
            this.readCentralDirectoryEntry(hashMap);
            this.wordBbuf.rewind();
            IOUtils.readFully(this.archive, this.wordBbuf);
            l2 = ZipLong.getValue(this.wordBuf);
        }
        return hashMap;
    }

    private void readCentralDirectoryEntry(Map<ZipArchiveEntry, NameAndComment> map) throws IOException {
        ZipEncoding zipEncoding;
        this.cfhBbuf.rewind();
        IOUtils.readFully(this.archive, this.cfhBbuf);
        int n2 = 0;
        Entry entry = new Entry();
        int n3 = ZipShort.getValue(this.cfhBuf, n2);
        entry.setVersionMadeBy(n3);
        entry.setPlatform(n3 >> 8 & 0xF);
        entry.setVersionRequired(ZipShort.getValue(this.cfhBuf, n2 += 2));
        GeneralPurposeBit generalPurposeBit = GeneralPurposeBit.parse(this.cfhBuf, n2 += 2);
        boolean bl2 = generalPurposeBit.usesUTF8ForNames();
        ZipEncoding zipEncoding2 = zipEncoding = bl2 ? ZipEncodingHelper.UTF8_ZIP_ENCODING : this.zipEncoding;
        if (bl2) {
            entry.setNameSource(ZipArchiveEntry.NameSource.NAME_WITH_EFS_FLAG);
        }
        entry.setGeneralPurposeBit(generalPurposeBit);
        entry.setRawFlag(ZipShort.getValue(this.cfhBuf, n2));
        entry.setMethod(ZipShort.getValue(this.cfhBuf, n2 += 2));
        long l2 = ZipUtil.dosToJavaTime(ZipLong.getValue(this.cfhBuf, n2 += 2));
        entry.setTime(l2);
        entry.setCrc(ZipLong.getValue(this.cfhBuf, n2 += 4));
        entry.setCompressedSize(ZipLong.getValue(this.cfhBuf, n2 += 4));
        entry.setSize(ZipLong.getValue(this.cfhBuf, n2 += 4));
        int n4 = ZipShort.getValue(this.cfhBuf, n2 += 4);
        int n5 = ZipShort.getValue(this.cfhBuf, n2 += 2);
        int n6 = ZipShort.getValue(this.cfhBuf, n2 += 2);
        int n7 = ZipShort.getValue(this.cfhBuf, n2 += 2);
        entry.setInternalAttributes(ZipShort.getValue(this.cfhBuf, n2 += 2));
        entry.setExternalAttributes(ZipLong.getValue(this.cfhBuf, n2 += 2));
        byte[] byArray = new byte[n4];
        IOUtils.readFully(this.archive, ByteBuffer.wrap(byArray));
        entry.setName(zipEncoding.decode(byArray), byArray);
        entry.setLocalHeaderOffset(ZipLong.getValue(this.cfhBuf, n2 += 4));
        this.entries.add(entry);
        byte[] byArray2 = new byte[n5];
        IOUtils.readFully(this.archive, ByteBuffer.wrap(byArray2));
        entry.setCentralDirectoryExtra(byArray2);
        this.setSizesAndOffsetFromZip64Extra(entry, n7);
        byte[] byArray3 = new byte[n6];
        IOUtils.readFully(this.archive, ByteBuffer.wrap(byArray3));
        entry.setComment(zipEncoding.decode(byArray3));
        if (!bl2 && this.useUnicodeExtraFields) {
            map.put(entry, new NameAndComment(byArray, byArray3));
        }
    }

    private void setSizesAndOffsetFromZip64Extra(ZipArchiveEntry zipArchiveEntry, int n2) throws IOException {
        Zip64ExtendedInformationExtraField zip64ExtendedInformationExtraField = (Zip64ExtendedInformationExtraField)zipArchiveEntry.getExtraField(Zip64ExtendedInformationExtraField.HEADER_ID);
        if (zip64ExtendedInformationExtraField != null) {
            boolean bl2 = zipArchiveEntry.getSize() == 0xFFFFFFFFL;
            boolean bl3 = zipArchiveEntry.getCompressedSize() == 0xFFFFFFFFL;
            boolean bl4 = zipArchiveEntry.getLocalHeaderOffset() == 0xFFFFFFFFL;
            zip64ExtendedInformationExtraField.reparseCentralDirectoryData(bl2, bl3, bl4, n2 == 65535);
            if (bl2) {
                zipArchiveEntry.setSize(zip64ExtendedInformationExtraField.getSize().getLongValue());
            } else if (bl3) {
                zip64ExtendedInformationExtraField.setSize(new ZipEightByteInteger(zipArchiveEntry.getSize()));
            }
            if (bl3) {
                zipArchiveEntry.setCompressedSize(zip64ExtendedInformationExtraField.getCompressedSize().getLongValue());
            } else if (bl2) {
                zip64ExtendedInformationExtraField.setCompressedSize(new ZipEightByteInteger(zipArchiveEntry.getCompressedSize()));
            }
            if (bl4) {
                zipArchiveEntry.setLocalHeaderOffset(zip64ExtendedInformationExtraField.getRelativeHeaderOffset().getLongValue());
            }
        }
    }

    private void positionAtCentralDirectory() throws IOException {
        boolean bl2;
        this.positionAtEndOfCentralDirectoryRecord();
        boolean bl3 = false;
        boolean bl4 = bl2 = this.archive.position() > 20L;
        if (bl2) {
            this.archive.position(this.archive.position() - 20L);
            this.wordBbuf.rewind();
            IOUtils.readFully(this.archive, this.wordBbuf);
            bl3 = Arrays.equals(ZipArchiveOutputStream.ZIP64_EOCD_LOC_SIG, this.wordBuf);
        }
        if (!bl3) {
            if (bl2) {
                this.skipBytes(16);
            }
            this.positionAtCentralDirectory32();
        } else {
            this.positionAtCentralDirectory64();
        }
    }

    private void positionAtCentralDirectory64() throws IOException {
        this.skipBytes(4);
        this.dwordBbuf.rewind();
        IOUtils.readFully(this.archive, this.dwordBbuf);
        this.archive.position(ZipEightByteInteger.getLongValue(this.dwordBuf));
        this.wordBbuf.rewind();
        IOUtils.readFully(this.archive, this.wordBbuf);
        if (!Arrays.equals(this.wordBuf, ZipArchiveOutputStream.ZIP64_EOCD_SIG)) {
            throw new ZipException("archive's ZIP64 end of central directory locator is corrupt.");
        }
        this.skipBytes(44);
        this.dwordBbuf.rewind();
        IOUtils.readFully(this.archive, this.dwordBbuf);
        this.archive.position(ZipEightByteInteger.getLongValue(this.dwordBuf));
    }

    private void positionAtCentralDirectory32() throws IOException {
        this.skipBytes(16);
        this.wordBbuf.rewind();
        IOUtils.readFully(this.archive, this.wordBbuf);
        this.archive.position(ZipLong.getValue(this.wordBuf));
    }

    private void positionAtEndOfCentralDirectoryRecord() throws IOException {
        boolean bl2 = this.tryToLocateSignature(22L, 65557L, ZipArchiveOutputStream.EOCD_SIG);
        if (!bl2) {
            throw new ZipException("archive is not a ZIP archive");
        }
    }

    private boolean tryToLocateSignature(long l2, long l3, byte[] byArray) throws IOException {
        long l4;
        boolean bl2 = false;
        long l5 = Math.max(0L, this.archive.size() - l3);
        if (l4 >= 0L) {
            for (l4 = this.archive.size() - l2; l4 >= l5; --l4) {
                this.archive.position(l4);
                try {
                    this.wordBbuf.rewind();
                    IOUtils.readFully(this.archive, this.wordBbuf);
                    this.wordBbuf.flip();
                }
                catch (EOFException eOFException) {
                    break;
                }
                byte by2 = this.wordBbuf.get();
                if (by2 != byArray[0] || (by2 = this.wordBbuf.get()) != byArray[1] || (by2 = this.wordBbuf.get()) != byArray[2] || (by2 = this.wordBbuf.get()) != byArray[3]) continue;
                bl2 = true;
                break;
            }
        }
        if (bl2) {
            this.archive.position(l4);
        }
        return bl2;
    }

    private void skipBytes(int n2) throws IOException {
        long l2 = this.archive.position();
        long l3 = l2 + (long)n2;
        if (l3 > this.archive.size()) {
            throw new EOFException();
        }
        this.archive.position(l3);
    }

    private void resolveLocalFileHeaderData(Map<ZipArchiveEntry, NameAndComment> map) throws IOException {
        for (ZipArchiveEntry zipArchiveEntry : this.entries) {
            LinkedList<ZipArchiveEntry> linkedList;
            Object object;
            Entry entry = (Entry)zipArchiveEntry;
            long l2 = entry.getLocalHeaderOffset();
            this.archive.position(l2 + 26L);
            this.wordBbuf.rewind();
            IOUtils.readFully(this.archive, this.wordBbuf);
            this.wordBbuf.flip();
            this.wordBbuf.get(this.shortBuf);
            int n2 = ZipShort.getValue(this.shortBuf);
            this.wordBbuf.get(this.shortBuf);
            int n3 = ZipShort.getValue(this.shortBuf);
            this.skipBytes(n2);
            byte[] byArray = new byte[n3];
            IOUtils.readFully(this.archive, ByteBuffer.wrap(byArray));
            entry.setExtra(byArray);
            entry.setDataOffset(l2 + 26L + 2L + 2L + (long)n2 + (long)n3);
            entry.setStreamContiguous(true);
            if (map.containsKey(entry)) {
                object = map.get(entry);
                ZipUtil.setNameAndCommentFromExtraFields(entry, ((NameAndComment)object).name, ((NameAndComment)object).comment);
            }
            if ((linkedList = this.nameMap.get(object = entry.getName())) == null) {
                linkedList = new LinkedList();
                this.nameMap.put((String)object, linkedList);
            }
            linkedList.addLast(entry);
        }
    }

    private boolean startsWithLocalFileHeader() throws IOException {
        this.archive.position(0L);
        this.wordBbuf.rewind();
        IOUtils.readFully(this.archive, this.wordBbuf);
        return Arrays.equals(this.wordBuf, ZipArchiveOutputStream.LFH_SIG);
    }

    private BoundedInputStream createBoundedInputStream(long l2, long l3) {
        return this.archive instanceof FileChannel ? new BoundedFileChannelInputStream(l2, l3) : new BoundedInputStream(l2, l3);
    }

    private static class StoredStatisticsStream
    extends CountingInputStream
    implements InputStreamStatistics {
        StoredStatisticsStream(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        public long getCompressedCount() {
            return super.getBytesRead();
        }

        @Override
        public long getUncompressedCount() {
            return this.getCompressedCount();
        }
    }

    private static class Entry
    extends ZipArchiveEntry {
        Entry() {
        }

        @Override
        public int hashCode() {
            return 3 * super.hashCode() + (int)this.getLocalHeaderOffset() + (int)(this.getLocalHeaderOffset() >> 32);
        }

        @Override
        public boolean equals(Object object) {
            if (super.equals(object)) {
                Entry entry = (Entry)object;
                return this.getLocalHeaderOffset() == entry.getLocalHeaderOffset() && this.getDataOffset() == entry.getDataOffset();
            }
            return false;
        }
    }

    private static final class NameAndComment {
        private final byte[] name;
        private final byte[] comment;

        private NameAndComment(byte[] byArray, byte[] byArray2) {
            this.name = byArray;
            this.comment = byArray2;
        }
    }

    private class BoundedFileChannelInputStream
    extends BoundedInputStream {
        private final FileChannel archive;

        BoundedFileChannelInputStream(long l2, long l3) {
            super(l2, l3);
            this.archive = (FileChannel)ZipFile.this.archive;
        }

        @Override
        protected int read(long l2, ByteBuffer byteBuffer) throws IOException {
            int n2 = this.archive.read(byteBuffer, l2);
            byteBuffer.flip();
            return n2;
        }
    }

    private class BoundedInputStream
    extends InputStream {
        private ByteBuffer singleByteBuffer;
        private final long end;
        private long loc;

        BoundedInputStream(long l2, long l3) {
            this.end = l2 + l3;
            if (this.end < l2) {
                throw new IllegalArgumentException("Invalid length of stream at offset=" + l2 + ", length=" + l3);
            }
            this.loc = l2;
        }

        @Override
        public synchronized int read() throws IOException {
            if (this.loc >= this.end) {
                return -1;
            }
            if (this.singleByteBuffer == null) {
                this.singleByteBuffer = ByteBuffer.allocate(1);
            } else {
                this.singleByteBuffer.rewind();
            }
            int n2 = this.read(this.loc, this.singleByteBuffer);
            if (n2 < 0) {
                return n2;
            }
            ++this.loc;
            return this.singleByteBuffer.get() & 0xFF;
        }

        @Override
        public synchronized int read(byte[] byArray, int n2, int n3) throws IOException {
            ByteBuffer byteBuffer;
            int n4;
            if (n3 <= 0) {
                return 0;
            }
            if ((long)n3 > this.end - this.loc) {
                if (this.loc >= this.end) {
                    return -1;
                }
                n3 = (int)(this.end - this.loc);
            }
            if ((n4 = this.read(this.loc, byteBuffer = ByteBuffer.wrap(byArray, n2, n3))) > 0) {
                this.loc += (long)n4;
                return n4;
            }
            return n4;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int read(long l2, ByteBuffer byteBuffer) throws IOException {
            int n2;
            SeekableByteChannel seekableByteChannel = ZipFile.this.archive;
            synchronized (seekableByteChannel) {
                ZipFile.this.archive.position(l2);
                n2 = ZipFile.this.archive.read(byteBuffer);
            }
            byteBuffer.flip();
            return n2;
        }
    }
}

