/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.compress.changes;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import zz.org.apache.commons.compress.archivers.ArchiveEntry;
import zz.org.apache.commons.compress.archivers.ArchiveInputStream;
import zz.org.apache.commons.compress.archivers.ArchiveOutputStream;
import zz.org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import zz.org.apache.commons.compress.archivers.zip.ZipFile;
import zz.org.apache.commons.compress.changes.Change;
import zz.org.apache.commons.compress.changes.ChangeSet;
import zz.org.apache.commons.compress.changes.ChangeSetResults;
import zz.org.apache.commons.compress.utils.IOUtils;

public class ChangeSetPerformer {
    private final Set<Change> changes;

    public ChangeSetPerformer(ChangeSet changeSet) {
        this.changes = changeSet.getChanges();
    }

    public ChangeSetResults perform(ArchiveInputStream archiveInputStream, ArchiveOutputStream archiveOutputStream) throws IOException {
        return this.perform(new ArchiveInputStreamIterator(archiveInputStream), archiveOutputStream);
    }

    public ChangeSetResults perform(ZipFile zipFile, ArchiveOutputStream archiveOutputStream) throws IOException {
        return this.perform(new ZipFileIterator(zipFile), archiveOutputStream);
    }

    private ChangeSetResults perform(ArchiveEntryIterator archiveEntryIterator, ArchiveOutputStream archiveOutputStream) throws IOException {
        ChangeSetResults changeSetResults = new ChangeSetResults();
        LinkedHashSet<Change> linkedHashSet = new LinkedHashSet<Change>(this.changes);
        Iterator iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            Change change = (Change)iterator.next();
            if (change.type() != 2 || !change.isReplaceMode()) continue;
            this.copyStream(change.getInput(), archiveOutputStream, change.getEntry());
            iterator.remove();
            changeSetResults.addedFromChangeSet(change.getEntry().getName());
        }
        while (archiveEntryIterator.hasNext()) {
            iterator = archiveEntryIterator.next();
            boolean bl2 = true;
            Iterator iterator2 = linkedHashSet.iterator();
            while (iterator2.hasNext()) {
                Change change = (Change)iterator2.next();
                int n2 = change.type();
                String string = iterator.getName();
                if (n2 == 1 && string != null) {
                    if (!string.equals(change.targetFile())) continue;
                    bl2 = false;
                    iterator2.remove();
                    changeSetResults.deleted(string);
                    break;
                }
                if (n2 != 4 || string == null || !string.startsWith(change.targetFile() + "/")) continue;
                bl2 = false;
                changeSetResults.deleted(string);
                break;
            }
            if (!bl2 || this.isDeletedLater((Set<Change>)linkedHashSet, (ArchiveEntry)((Object)iterator)) || changeSetResults.hasBeenAdded(iterator.getName())) continue;
            this.copyStream(archiveEntryIterator.getInputStream(), archiveOutputStream, (ArchiveEntry)((Object)iterator));
            changeSetResults.addedFromStream(iterator.getName());
        }
        iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            Change change = (Change)iterator.next();
            if (change.type() != 2 || change.isReplaceMode() || changeSetResults.hasBeenAdded(change.getEntry().getName())) continue;
            this.copyStream(change.getInput(), archiveOutputStream, change.getEntry());
            iterator.remove();
            changeSetResults.addedFromChangeSet(change.getEntry().getName());
        }
        archiveOutputStream.finish();
        return changeSetResults;
    }

    private boolean isDeletedLater(Set<Change> set, ArchiveEntry archiveEntry) {
        String string = archiveEntry.getName();
        if (!set.isEmpty()) {
            for (Change change : set) {
                int n2 = change.type();
                String string2 = change.targetFile();
                if (n2 == 1 && string.equals(string2)) {
                    return true;
                }
                if (n2 != 4 || !string.startsWith(string2 + "/")) continue;
                return true;
            }
        }
        return false;
    }

    private void copyStream(InputStream inputStream, ArchiveOutputStream archiveOutputStream, ArchiveEntry archiveEntry) throws IOException {
        archiveOutputStream.putArchiveEntry(archiveEntry);
        IOUtils.copy(inputStream, archiveOutputStream);
        archiveOutputStream.closeArchiveEntry();
    }

    private static class ZipFileIterator
    implements ArchiveEntryIterator {
        private final ZipFile in;
        private final Enumeration<ZipArchiveEntry> nestedEnum;
        private ZipArchiveEntry current;

        ZipFileIterator(ZipFile zipFile) {
            this.in = zipFile;
            this.nestedEnum = zipFile.getEntriesInPhysicalOrder();
        }

        @Override
        public boolean hasNext() {
            return this.nestedEnum.hasMoreElements();
        }

        @Override
        public ArchiveEntry next() {
            this.current = this.nestedEnum.nextElement();
            return this.current;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.in.getInputStream(this.current);
        }
    }

    private static class ArchiveInputStreamIterator
    implements ArchiveEntryIterator {
        private final ArchiveInputStream in;
        private ArchiveEntry next;

        ArchiveInputStreamIterator(ArchiveInputStream archiveInputStream) {
            this.in = archiveInputStream;
        }

        @Override
        public boolean hasNext() throws IOException {
            this.next = this.in.getNextEntry();
            return this.next != null;
        }

        @Override
        public ArchiveEntry next() {
            return this.next;
        }

        @Override
        public InputStream getInputStream() {
            return this.in;
        }
    }

    static interface ArchiveEntryIterator {
        public boolean hasNext() throws IOException;

        public ArchiveEntry next();

        public InputStream getInputStream() throws IOException;
    }
}

