/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.compress.compressors.bzip2;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.Arrays;
import zz.org.apache.commons.compress.compressors.CompressorInputStream;
import zz.org.apache.commons.compress.compressors.bzip2.BZip2Constants;
import zz.org.apache.commons.compress.compressors.bzip2.CRC;
import zz.org.apache.commons.compress.compressors.bzip2.Rand;
import zz.org.apache.commons.compress.utils.BitInputStream;
import zz.org.apache.commons.compress.utils.CloseShieldFilterInputStream;
import zz.org.apache.commons.compress.utils.InputStreamStatistics;

public class BZip2CompressorInputStream
extends CompressorInputStream
implements BZip2Constants,
InputStreamStatistics {
    private int last;
    private int origPtr;
    private int blockSize100k;
    private boolean blockRandomised;
    private final CRC crc = new CRC();
    private int nInUse;
    private BitInputStream bin;
    private final boolean decompressConcatenated;
    private static final int EOF = 0;
    private static final int START_BLOCK_STATE = 1;
    private static final int RAND_PART_A_STATE = 2;
    private static final int RAND_PART_B_STATE = 3;
    private static final int RAND_PART_C_STATE = 4;
    private static final int NO_RAND_PART_A_STATE = 5;
    private static final int NO_RAND_PART_B_STATE = 6;
    private static final int NO_RAND_PART_C_STATE = 7;
    private int currentState = 1;
    private int storedBlockCRC;
    private int storedCombinedCRC;
    private int computedBlockCRC;
    private int computedCombinedCRC;
    private int su_count;
    private int su_ch2;
    private int su_chPrev;
    private int su_i2;
    private int su_j2;
    private int su_rNToGo;
    private int su_rTPos;
    private int su_tPos;
    private char su_z;
    private Data data;

    public BZip2CompressorInputStream(InputStream inputStream) throws IOException {
        this(inputStream, false);
    }

    public BZip2CompressorInputStream(InputStream inputStream, boolean bl2) throws IOException {
        this.bin = new BitInputStream(inputStream == System.in ? new CloseShieldFilterInputStream(inputStream) : inputStream, ByteOrder.BIG_ENDIAN);
        this.decompressConcatenated = bl2;
        this.init(true);
        this.initBlock();
    }

    @Override
    public int read() throws IOException {
        if (this.bin != null) {
            int n2 = this.read0();
            this.count(n2 < 0 ? -1 : 1);
            return n2;
        }
        throw new IOException("stream closed");
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("offs(" + n2 + ") < 0.");
        }
        if (n3 < 0) {
            throw new IndexOutOfBoundsException("len(" + n3 + ") < 0.");
        }
        if (n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException("offs(" + n2 + ") + len(" + n3 + ") > dest.length(" + byArray.length + ").");
        }
        if (this.bin == null) {
            throw new IOException("stream closed");
        }
        if (n3 == 0) {
            return 0;
        }
        int n5 = n2 + n3;
        int n6 = n2;
        while (n6 < n5 && (n4 = this.read0()) >= 0) {
            byArray[n6++] = (byte)n4;
            this.count(1);
        }
        return n6 == n2 ? -1 : n6 - n2;
    }

    @Override
    public long getCompressedCount() {
        return this.bin.getBytesRead();
    }

    private void makeMaps() {
        boolean[] blArray = this.data.inUse;
        byte[] byArray = this.data.seqToUnseq;
        int n2 = 0;
        for (int i2 = 0; i2 < 256; ++i2) {
            if (!blArray[i2]) continue;
            byArray[n2++] = (byte)i2;
        }
        this.nInUse = n2;
    }

    private int read0() throws IOException {
        switch (this.currentState) {
            case 0: {
                return -1;
            }
            case 1: {
                return this.setupBlock();
            }
            case 2: {
                throw new IllegalStateException();
            }
            case 3: {
                return this.setupRandPartB();
            }
            case 4: {
                return this.setupRandPartC();
            }
            case 5: {
                throw new IllegalStateException();
            }
            case 6: {
                return this.setupNoRandPartB();
            }
            case 7: {
                return this.setupNoRandPartC();
            }
        }
        throw new IllegalStateException();
    }

    private int readNextByte(BitInputStream bitInputStream) throws IOException {
        long l2 = bitInputStream.readBits(8);
        return (int)l2;
    }

    private boolean init(boolean bl2) throws IOException {
        int n2;
        if (null == this.bin) {
            throw new IOException("No InputStream");
        }
        if (!bl2) {
            this.bin.clearBitCache();
        }
        if ((n2 = this.readNextByte(this.bin)) == -1 && !bl2) {
            return false;
        }
        int n3 = this.readNextByte(this.bin);
        int n4 = this.readNextByte(this.bin);
        if (n2 != 66 || n3 != 90 || n4 != 104) {
            throw new IOException(bl2 ? "Stream is not in the BZip2 format" : "Garbage after a valid BZip2 stream");
        }
        int n5 = this.readNextByte(this.bin);
        if (n5 < 49 || n5 > 57) {
            throw new IOException("BZip2 block size is invalid");
        }
        this.blockSize100k = n5 - 48;
        this.computedCombinedCRC = 0;
        return true;
    }

    private void initBlock() throws IOException {
        char c2;
        char c3;
        char c4;
        char c5;
        char c6;
        char c7;
        BitInputStream bitInputStream;
        block3: {
            bitInputStream = this.bin;
            do {
                c7 = BZip2CompressorInputStream.bsGetUByte(bitInputStream);
                c6 = BZip2CompressorInputStream.bsGetUByte(bitInputStream);
                c5 = BZip2CompressorInputStream.bsGetUByte(bitInputStream);
                c4 = BZip2CompressorInputStream.bsGetUByte(bitInputStream);
                c3 = BZip2CompressorInputStream.bsGetUByte(bitInputStream);
                c2 = BZip2CompressorInputStream.bsGetUByte(bitInputStream);
                if (c7 != '\u0017' || c6 != 'r' || c5 != 'E' || c4 != '8' || c3 != 'P' || c2 != '\u0090') break block3;
            } while (!this.complete());
            return;
        }
        if (c7 != '1' || c6 != 'A' || c5 != 'Y' || c4 != '&' || c3 != 'S' || c2 != 'Y') {
            this.currentState = 0;
            throw new IOException("bad block header");
        }
        this.storedBlockCRC = BZip2CompressorInputStream.bsGetInt(bitInputStream);
        boolean bl2 = this.blockRandomised = BZip2CompressorInputStream.bsR(bitInputStream, 1) == 1;
        if (this.data == null) {
            this.data = new Data(this.blockSize100k);
        }
        this.getAndMoveToFrontDecode();
        this.crc.initialiseCRC();
        this.currentState = 1;
    }

    private void endBlock() throws IOException {
        this.computedBlockCRC = this.crc.getFinalCRC();
        if (this.storedBlockCRC != this.computedBlockCRC) {
            this.computedCombinedCRC = this.storedCombinedCRC << 1 | this.storedCombinedCRC >>> 31;
            this.computedCombinedCRC ^= this.storedBlockCRC;
            throw new IOException("BZip2 CRC error");
        }
        this.computedCombinedCRC = this.computedCombinedCRC << 1 | this.computedCombinedCRC >>> 31;
        this.computedCombinedCRC ^= this.computedBlockCRC;
    }

    private boolean complete() throws IOException {
        this.storedCombinedCRC = BZip2CompressorInputStream.bsGetInt(this.bin);
        this.currentState = 0;
        this.data = null;
        if (this.storedCombinedCRC != this.computedCombinedCRC) {
            throw new IOException("BZip2 CRC error");
        }
        return !this.decompressConcatenated || !this.init(false);
    }

    @Override
    public void close() throws IOException {
        BitInputStream bitInputStream = this.bin;
        if (bitInputStream != null) {
            try {
                bitInputStream.close();
            }
            finally {
                this.data = null;
                this.bin = null;
            }
        }
    }

    private static int bsR(BitInputStream bitInputStream, int n2) throws IOException {
        long l2 = bitInputStream.readBits(n2);
        if (l2 < 0L) {
            throw new IOException("unexpected end of stream");
        }
        return (int)l2;
    }

    private static boolean bsGetBit(BitInputStream bitInputStream) throws IOException {
        return BZip2CompressorInputStream.bsR(bitInputStream, 1) != 0;
    }

    private static char bsGetUByte(BitInputStream bitInputStream) throws IOException {
        return (char)BZip2CompressorInputStream.bsR(bitInputStream, 8);
    }

    private static int bsGetInt(BitInputStream bitInputStream) throws IOException {
        return BZip2CompressorInputStream.bsR(bitInputStream, 32);
    }

    private static void checkBounds(int n2, int n3, String string) throws IOException {
        if (n2 < 0) {
            throw new IOException("Corrupted input, " + string + " value negative");
        }
        if (n2 >= n3) {
            throw new IOException("Corrupted input, " + string + " value too big");
        }
    }

    private static void hbCreateDecodeTables(int[] nArray, int[] nArray2, int[] nArray3, char[] cArray, int n2, int n3, int n4) throws IOException {
        int n5;
        int n6;
        int n7 = 0;
        for (n6 = n2; n6 <= n3; ++n6) {
            for (n5 = 0; n5 < n4; ++n5) {
                if (cArray[n5] != n6) continue;
                nArray3[n7++] = n5;
            }
        }
        n6 = 23;
        while (--n6 > 0) {
            nArray2[n6] = 0;
            nArray[n6] = 0;
        }
        for (n6 = 0; n6 < n4; ++n6) {
            n7 = cArray[n6];
            BZip2CompressorInputStream.checkBounds(n7, 258, "length");
            int n8 = n7 + 1;
            nArray2[n8] = nArray2[n8] + 1;
        }
        n7 = nArray2[0];
        for (n6 = 1; n6 < 23; ++n6) {
            nArray2[n6] = n7 += nArray2[n6];
        }
        n7 = 0;
        n5 = nArray2[n6];
        for (n6 = n2; n6 <= n3; ++n6) {
            int n9 = nArray2[n6 + 1];
            n5 = n9;
            nArray[n6] = (n7 += n9 - n5) - 1;
            n7 <<= 1;
        }
        for (n6 = n2 + 1; n6 <= n3; ++n6) {
            nArray2[n6] = (nArray[n6 - 1] + 1 << 1) - nArray2[n6];
        }
    }

    private void recvDecodingTables() throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        BitInputStream bitInputStream = this.bin;
        Data data = this.data;
        boolean[] blArray = data.inUse;
        byte[] byArray = data.recvDecodingTables_pos;
        byte[] byArray2 = data.selector;
        byte[] byArray3 = data.selectorMtf;
        int n8 = 0;
        for (n7 = 0; n7 < 16; ++n7) {
            if (!BZip2CompressorInputStream.bsGetBit(bitInputStream)) continue;
            n8 |= 1 << n7;
        }
        Arrays.fill(blArray, false);
        for (n7 = 0; n7 < 16; ++n7) {
            if ((n8 & 1 << n7) == 0) continue;
            n6 = n7 << 4;
            for (n5 = 0; n5 < 16; ++n5) {
                if (!BZip2CompressorInputStream.bsGetBit(bitInputStream)) continue;
                blArray[n6 + n5] = true;
            }
        }
        this.makeMaps();
        n7 = this.nInUse + 2;
        n6 = BZip2CompressorInputStream.bsR(bitInputStream, 3);
        n5 = BZip2CompressorInputStream.bsR(bitInputStream, 15);
        BZip2CompressorInputStream.checkBounds(n7, 259, "alphaSize");
        BZip2CompressorInputStream.checkBounds(n6, 7, "nGroups");
        BZip2CompressorInputStream.checkBounds(n5, 18003, "nSelectors");
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = 0;
            while (BZip2CompressorInputStream.bsGetBit(bitInputStream)) {
                ++n3;
            }
            byArray3[n4] = (byte)n3;
        }
        n4 = n6;
        while (--n4 >= 0) {
            byArray[n4] = (byte)n4;
        }
        for (n4 = 0; n4 < n5; ++n4) {
            BZip2CompressorInputStream.checkBounds(n3, 6, "selectorMtf");
            n2 = byArray[n3];
            for (n3 = byArray3[n4] & 0xFF; n3 > 0; --n3) {
                byArray[n3] = byArray[n3 - 1];
            }
            byArray[0] = n2;
            byArray2[n4] = n2;
        }
        char[][] cArray = data.temp_charArray2d;
        for (n3 = 0; n3 < n6; ++n3) {
            n2 = BZip2CompressorInputStream.bsR(bitInputStream, 5);
            char[] cArray2 = cArray[n3];
            for (int i2 = 0; i2 < n7; ++i2) {
                while (BZip2CompressorInputStream.bsGetBit(bitInputStream)) {
                    n2 += BZip2CompressorInputStream.bsGetBit(bitInputStream) ? -1 : 1;
                }
                cArray2[i2] = (char)n2;
            }
        }
        this.createHuffmanDecodingTables(n7, n6);
    }

    private void createHuffmanDecodingTables(int n2, int n3) throws IOException {
        Data data = this.data;
        char[][] cArray = data.temp_charArray2d;
        int[] nArray = data.minLens;
        int[][] nArray2 = data.limit;
        int[][] nArray3 = data.base;
        int[][] nArray4 = data.perm;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = 32;
            int n5 = 0;
            char[] cArray2 = cArray[i2];
            int n6 = n2;
            while (--n6 >= 0) {
                int n7 = cArray2[n6];
                if (n7 > n5) {
                    n5 = n7;
                }
                if (n7 >= n4) continue;
                n4 = n7;
            }
            BZip2CompressorInputStream.hbCreateDecodeTables(nArray2[i2], nArray3[i2], nArray4[i2], cArray[i2], n4, n5, n2);
            nArray[i2] = n4;
        }
    }

    private void getAndMoveToFrontDecode() throws IOException {
        BitInputStream bitInputStream = this.bin;
        this.origPtr = BZip2CompressorInputStream.bsR(bitInputStream, 24);
        this.recvDecodingTables();
        Data data = this.data;
        byte[] byArray = data.ll8;
        int[] nArray = data.unzftab;
        byte[] byArray2 = data.selector;
        byte[] byArray3 = data.seqToUnseq;
        char[] cArray = data.getAndMoveToFrontDecode_yy;
        int[] nArray2 = data.minLens;
        int[][] nArray3 = data.limit;
        int[][] nArray4 = data.base;
        int[][] nArray5 = data.perm;
        int n2 = this.blockSize100k * 100000;
        int n3 = 256;
        while (--n3 >= 0) {
            cArray[n3] = (char)n3;
            nArray[n3] = 0;
        }
        n3 = 0;
        int n4 = 49;
        int n5 = this.nInUse + 1;
        int n6 = this.getAndMoveToFrontDecode0();
        int n7 = -1;
        int n8 = byArray2[n3] & 0xFF;
        BZip2CompressorInputStream.checkBounds(n8, 6, "zt");
        int[] nArray6 = nArray4[n8];
        int[] nArray7 = nArray3[n8];
        int[] nArray8 = nArray5[n8];
        int n9 = nArray2[n8];
        while (n6 != n5) {
            int n10;
            int n11;
            int n12;
            int n13;
            if (n6 == 0 || n6 == 1) {
                n13 = -1;
                n12 = 1;
                while (true) {
                    if (n6 == 0) {
                        n13 += n12;
                    } else {
                        if (n6 != 1) break;
                        n13 += n12 << 1;
                    }
                    if (n4 == 0) {
                        n4 = 49;
                        BZip2CompressorInputStream.checkBounds(++n3, 18002, "groupNo");
                        n8 = byArray2[n3] & 0xFF;
                        BZip2CompressorInputStream.checkBounds(n8, 6, "zt");
                        nArray6 = nArray4[n8];
                        nArray7 = nArray3[n8];
                        nArray8 = nArray5[n8];
                        n9 = nArray2[n8];
                    } else {
                        --n4;
                    }
                    n11 = n9;
                    BZip2CompressorInputStream.checkBounds(n11, 258, "zn");
                    n10 = BZip2CompressorInputStream.bsR(bitInputStream, n11);
                    while (n10 > nArray7[n11]) {
                        BZip2CompressorInputStream.checkBounds(++n11, 258, "zn");
                        n10 = n10 << 1 | BZip2CompressorInputStream.bsR(bitInputStream, 1);
                    }
                    int n14 = n10 - nArray6[n11];
                    BZip2CompressorInputStream.checkBounds(n14, 258, "zvec");
                    n6 = nArray8[n14];
                    n12 <<= 1;
                }
                n12 = cArray[0];
                BZip2CompressorInputStream.checkBounds(n12, 256, "yy");
                n11 = byArray3[n12];
                int n15 = n11 & 0xFF;
                nArray[n15] = nArray[n15] + (n13 + 1);
                n10 = ++n7;
                Arrays.fill(byArray, n10, (n7 += n13) + 1, (byte)n11);
                if (n7 < n2) continue;
                throw new IOException("block overrun while expanding RLE in MTF, " + n7 + " exceeds " + n2);
            }
            if (++n7 >= n2) {
                throw new IOException("block overrun in MTF, " + n7 + " exceeds " + n2);
            }
            BZip2CompressorInputStream.checkBounds(n6, 257, "nextSym");
            n13 = cArray[n6 - 1];
            BZip2CompressorInputStream.checkBounds(n13, 256, "yy");
            int n16 = byArray3[n13] & 0xFF;
            nArray[n16] = nArray[n16] + 1;
            byArray[n7] = byArray3[n13];
            if (n6 <= 16) {
                n12 = n6 - 1;
                while (n12 > 0) {
                    cArray[n12--] = cArray[n12];
                }
            } else {
                System.arraycopy(cArray, 0, cArray, 1, n6 - 1);
            }
            cArray[0] = n13;
            if (n4 == 0) {
                n4 = 49;
                BZip2CompressorInputStream.checkBounds(++n3, 18002, "groupNo");
                n8 = byArray2[n3] & 0xFF;
                BZip2CompressorInputStream.checkBounds(n8, 6, "zt");
                nArray6 = nArray4[n8];
                nArray7 = nArray3[n8];
                nArray8 = nArray5[n8];
                n9 = nArray2[n8];
            } else {
                --n4;
            }
            n12 = n9;
            BZip2CompressorInputStream.checkBounds(n12, 258, "zn");
            n11 = BZip2CompressorInputStream.bsR(bitInputStream, n12);
            while (n11 > nArray7[n12]) {
                BZip2CompressorInputStream.checkBounds(++n12, 258, "zn");
                n11 = n11 << 1 | BZip2CompressorInputStream.bsR(bitInputStream, 1);
            }
            n10 = n11 - nArray6[n12];
            BZip2CompressorInputStream.checkBounds(n10, 258, "zvec");
            n6 = nArray8[n10];
        }
        this.last = n7;
    }

    private int getAndMoveToFrontDecode0() throws IOException {
        Data data = this.data;
        int n2 = data.selector[0] & 0xFF;
        BZip2CompressorInputStream.checkBounds(n2, 6, "zt");
        int[] nArray = data.limit[n2];
        int n3 = data.minLens[n2];
        BZip2CompressorInputStream.checkBounds(n3, 258, "zn");
        int n4 = BZip2CompressorInputStream.bsR(this.bin, n3);
        while (n4 > nArray[n3]) {
            BZip2CompressorInputStream.checkBounds(++n3, 258, "zn");
            n4 = n4 << 1 | BZip2CompressorInputStream.bsR(this.bin, 1);
        }
        int n5 = n4 - data.base[n2][n3];
        BZip2CompressorInputStream.checkBounds(n5, 258, "zvec");
        return data.perm[n2][n5];
    }

    private int setupBlock() throws IOException {
        int n2;
        if (this.currentState == 0 || this.data == null) {
            return -1;
        }
        int[] nArray = this.data.cftab;
        int n3 = this.last + 1;
        int[] nArray2 = this.data.initTT(n3);
        byte[] byArray = this.data.ll8;
        nArray[0] = 0;
        System.arraycopy(this.data.unzftab, 0, nArray, 1, 256);
        int n4 = nArray[0];
        for (n2 = 1; n2 <= 256; ++n2) {
            nArray[n2] = n4 += nArray[n2];
        }
        n2 = 0;
        n4 = this.last;
        while (n2 <= n4) {
            int n5;
            int n6 = byArray[n2] & 0xFF;
            nArray[n6] = nArray[n6] + 1;
            BZip2CompressorInputStream.checkBounds(n5, n3, "tt index");
            nArray2[n5] = n2++;
        }
        if (this.origPtr < 0 || this.origPtr >= nArray2.length) {
            throw new IOException("stream corrupted");
        }
        this.su_tPos = nArray2[this.origPtr];
        this.su_count = 0;
        this.su_i2 = 0;
        this.su_ch2 = 256;
        if (this.blockRandomised) {
            this.su_rNToGo = 0;
            this.su_rTPos = 0;
            return this.setupRandPartA();
        }
        return this.setupNoRandPartA();
    }

    private int setupRandPartA() throws IOException {
        if (this.su_i2 <= this.last) {
            this.su_chPrev = this.su_ch2;
            int n2 = this.data.ll8[this.su_tPos] & 0xFF;
            BZip2CompressorInputStream.checkBounds(this.su_tPos, this.data.tt.length, "su_tPos");
            this.su_tPos = this.data.tt[this.su_tPos];
            if (this.su_rNToGo == 0) {
                this.su_rNToGo = Rand.rNums(this.su_rTPos) - 1;
                if (++this.su_rTPos == 512) {
                    this.su_rTPos = 0;
                }
            } else {
                --this.su_rNToGo;
            }
            this.su_ch2 = n2 ^= this.su_rNToGo == 1 ? 1 : 0;
            ++this.su_i2;
            this.currentState = 3;
            this.crc.updateCRC(n2);
            return n2;
        }
        this.endBlock();
        this.initBlock();
        return this.setupBlock();
    }

    private int setupNoRandPartA() throws IOException {
        if (this.su_i2 <= this.last) {
            int n2;
            this.su_chPrev = this.su_ch2;
            this.su_ch2 = n2 = this.data.ll8[this.su_tPos] & 0xFF;
            BZip2CompressorInputStream.checkBounds(this.su_tPos, this.data.tt.length, "su_tPos");
            this.su_tPos = this.data.tt[this.su_tPos];
            ++this.su_i2;
            this.currentState = 6;
            this.crc.updateCRC(n2);
            return n2;
        }
        this.currentState = 5;
        this.endBlock();
        this.initBlock();
        return this.setupBlock();
    }

    private int setupRandPartB() throws IOException {
        if (this.su_ch2 != this.su_chPrev) {
            this.currentState = 2;
            this.su_count = 1;
            return this.setupRandPartA();
        }
        if (++this.su_count >= 4) {
            this.su_z = (char)(this.data.ll8[this.su_tPos] & 0xFF);
            BZip2CompressorInputStream.checkBounds(this.su_tPos, this.data.tt.length, "su_tPos");
            this.su_tPos = this.data.tt[this.su_tPos];
            if (this.su_rNToGo == 0) {
                this.su_rNToGo = Rand.rNums(this.su_rTPos) - 1;
                if (++this.su_rTPos == 512) {
                    this.su_rTPos = 0;
                }
            } else {
                --this.su_rNToGo;
            }
            this.su_j2 = 0;
            this.currentState = 4;
            if (this.su_rNToGo == 1) {
                this.su_z = (char)(this.su_z ^ '\u0001');
            }
            return this.setupRandPartC();
        }
        this.currentState = 2;
        return this.setupRandPartA();
    }

    private int setupRandPartC() throws IOException {
        if (this.su_j2 < this.su_z) {
            this.crc.updateCRC(this.su_ch2);
            ++this.su_j2;
            return this.su_ch2;
        }
        this.currentState = 2;
        ++this.su_i2;
        this.su_count = 0;
        return this.setupRandPartA();
    }

    private int setupNoRandPartB() throws IOException {
        if (this.su_ch2 != this.su_chPrev) {
            this.su_count = 1;
            return this.setupNoRandPartA();
        }
        if (++this.su_count >= 4) {
            BZip2CompressorInputStream.checkBounds(this.su_tPos, this.data.ll8.length, "su_tPos");
            this.su_z = (char)(this.data.ll8[this.su_tPos] & 0xFF);
            this.su_tPos = this.data.tt[this.su_tPos];
            this.su_j2 = 0;
            return this.setupNoRandPartC();
        }
        return this.setupNoRandPartA();
    }

    private int setupNoRandPartC() throws IOException {
        if (this.su_j2 < this.su_z) {
            int n2 = this.su_ch2;
            this.crc.updateCRC(n2);
            ++this.su_j2;
            this.currentState = 7;
            return n2;
        }
        ++this.su_i2;
        this.su_count = 0;
        return this.setupNoRandPartA();
    }

    public static boolean matches(byte[] byArray, int n2) {
        return n2 >= 3 && byArray[0] == 66 && byArray[1] == 90 && byArray[2] == 104;
    }

    private static final class Data {
        final boolean[] inUse = new boolean[256];
        final byte[] seqToUnseq = new byte[256];
        final byte[] selector = new byte[18002];
        final byte[] selectorMtf = new byte[18002];
        final int[] unzftab = new int[256];
        final int[][] limit = new int[6][258];
        final int[][] base = new int[6][258];
        final int[][] perm = new int[6][258];
        final int[] minLens = new int[6];
        final int[] cftab = new int[257];
        final char[] getAndMoveToFrontDecode_yy = new char[256];
        final char[][] temp_charArray2d = new char[6][258];
        final byte[] recvDecodingTables_pos = new byte[6];
        int[] tt;
        byte[] ll8;

        Data(int n2) {
            this.ll8 = new byte[n2 * 100000];
        }

        int[] initTT(int n2) {
            int[] nArray = this.tt;
            if (nArray == null || nArray.length < n2) {
                this.tt = nArray = new int[n2];
            }
            return nArray;
        }
    }
}

