/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.compress.compressors.bzip2;

import java.io.IOException;
import java.io.OutputStream;
import zz.org.apache.commons.compress.compressors.CompressorOutputStream;
import zz.org.apache.commons.compress.compressors.bzip2.BZip2Constants;
import zz.org.apache.commons.compress.compressors.bzip2.BlockSort;
import zz.org.apache.commons.compress.compressors.bzip2.CRC;

public class BZip2CompressorOutputStream
extends CompressorOutputStream
implements BZip2Constants {
    public static final int MIN_BLOCKSIZE = 1;
    public static final int MAX_BLOCKSIZE = 9;
    private static final int GREATER_ICOST = 15;
    private static final int LESSER_ICOST = 0;
    private int last;
    private final int blockSize100k;
    private int bsBuff;
    private int bsLive;
    private final CRC crc = new CRC();
    private int nInUse;
    private int nMTF;
    private int currentChar = -1;
    private int runLength = 0;
    private int blockCRC;
    private int combinedCRC;
    private final int allowableBlockSize;
    private Data data;
    private BlockSort blockSorter;
    private OutputStream out;
    private volatile boolean closed;

    private static void hbMakeCodeLengths(byte[] byArray, int[] nArray, Data data, int n2, int n3) {
        int[] nArray2 = data.heap;
        int[] nArray3 = data.weight;
        int[] nArray4 = data.parent;
        int n4 = n2;
        while (--n4 >= 0) {
            nArray3[n4 + 1] = (nArray[n4] == 0 ? 1 : nArray[n4]) << 8;
        }
        n4 = 1;
        while (n4 != 0) {
            int n5;
            int n6;
            int n7;
            int n8;
            n4 = 0;
            int n9 = n2;
            int n10 = 0;
            nArray2[0] = 0;
            nArray3[0] = 0;
            nArray4[0] = -2;
            for (n8 = 1; n8 <= n2; ++n8) {
                nArray4[n8] = -1;
                nArray2[++n10] = n8;
                n7 = n10;
                n6 = nArray2[n7];
                while (nArray3[n6] < nArray3[nArray2[n7 >> 1]]) {
                    nArray2[n7] = nArray2[n7 >> 1];
                    n7 >>= 1;
                }
                nArray2[n7] = n6;
            }
            while (n10 > 1) {
                int n11;
                int n12;
                n8 = nArray2[1];
                nArray2[1] = nArray2[n10];
                --n10;
                n7 = 0;
                n6 = 1;
                n5 = nArray2[1];
                while ((n7 = n6 << 1) <= n10) {
                    if (n7 < n10 && nArray3[nArray2[n7 + 1]] < nArray3[nArray2[n7]]) {
                        ++n7;
                    }
                    if (nArray3[n5] < nArray3[nArray2[n7]]) break;
                    nArray2[n6] = nArray2[n7];
                    n6 = n7;
                }
                nArray2[n6] = n5;
                int n13 = nArray2[1];
                nArray2[1] = nArray2[n10];
                --n10;
                n7 = 0;
                n6 = 1;
                n5 = nArray2[1];
                while ((n7 = n6 << 1) <= n10) {
                    if (n7 < n10 && nArray3[nArray2[n7 + 1]] < nArray3[nArray2[n7]]) {
                        ++n7;
                    }
                    if (nArray3[n5] < nArray3[nArray2[n7]]) break;
                    nArray2[n6] = nArray2[n7];
                    n6 = n7;
                }
                nArray2[n6] = n5;
                nArray4[n8] = nArray4[n13] = ++n9;
                nArray3[n9] = (n12 & 0xFFFFFF00) + (n11 & 0xFFFFFF00) | 1 + (((n12 = nArray3[n8]) & 0xFF) > ((n11 = nArray3[n13]) & 0xFF) ? n12 & 0xFF : n11 & 0xFF);
                nArray4[n9] = -1;
                nArray2[++n10] = n9;
                n5 = 0;
                n6 = n10;
                n5 = nArray2[n6];
                int n14 = nArray3[n5];
                while (n14 < nArray3[nArray2[n6 >> 1]]) {
                    nArray2[n6] = nArray2[n6 >> 1];
                    n6 >>= 1;
                }
                nArray2[n6] = n5;
            }
            for (n8 = 1; n8 <= n2; ++n8) {
                n7 = 0;
                n6 = n8;
                while ((n5 = nArray4[n6]) >= 0) {
                    n6 = n5;
                    ++n7;
                }
                byArray[n8 - 1] = (byte)n7;
                if (n7 <= n3) continue;
                n4 = 1;
            }
            if (n4 == 0) continue;
            for (n8 = 1; n8 < n2; ++n8) {
                n7 = nArray3[n8] >> 8;
                n7 = 1 + (n7 >> 1);
                nArray3[n8] = n7 << 8;
            }
        }
    }

    public static int chooseBlockSize(long l2) {
        return l2 > 0L ? (int)Math.min(l2 / 132000L + 1L, 9L) : 9;
    }

    public BZip2CompressorOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, 9);
    }

    public BZip2CompressorOutputStream(OutputStream outputStream, int n2) throws IOException {
        if (n2 < 1) {
            throw new IllegalArgumentException("blockSize(" + n2 + ") < 1");
        }
        if (n2 > 9) {
            throw new IllegalArgumentException("blockSize(" + n2 + ") > 9");
        }
        this.blockSize100k = n2;
        this.out = outputStream;
        this.allowableBlockSize = this.blockSize100k * 100000 - 20;
        this.init();
    }

    @Override
    public void write(int n2) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.write0(n2);
    }

    private void writeRun() throws IOException {
        int n2 = this.last;
        if (n2 < this.allowableBlockSize) {
            int n3 = this.currentChar;
            Data data = this.data;
            data.inUse[n3] = true;
            byte by2 = (byte)n3;
            int n4 = this.runLength;
            this.crc.updateCRC(n3, n4);
            switch (n4) {
                case 1: {
                    data.block[n2 + 2] = by2;
                    this.last = n2 + 1;
                    break;
                }
                case 2: {
                    data.block[n2 + 2] = by2;
                    data.block[n2 + 3] = by2;
                    this.last = n2 + 2;
                    break;
                }
                case 3: {
                    byte[] byArray = data.block;
                    byArray[n2 + 2] = by2;
                    byArray[n2 + 3] = by2;
                    byArray[n2 + 4] = by2;
                    this.last = n2 + 3;
                    break;
                }
                default: {
                    data.inUse[n4 -= 4] = true;
                    byte[] byArray = data.block;
                    byArray[n2 + 2] = by2;
                    byArray[n2 + 3] = by2;
                    byArray[n2 + 4] = by2;
                    byArray[n2 + 5] = by2;
                    byArray[n2 + 6] = (byte)n4;
                    this.last = n2 + 5;
                    break;
                }
            }
        } else {
            this.endBlock();
            this.initBlock();
            this.writeRun();
        }
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            System.err.println("Unclosed BZip2CompressorOutputStream detected, will *not* close it");
        }
        super.finalize();
    }

    public void finish() throws IOException {
        if (!this.closed) {
            this.closed = true;
            try {
                if (this.runLength > 0) {
                    this.writeRun();
                }
                this.currentChar = -1;
                this.endBlock();
                this.endCompression();
            }
            finally {
                this.out = null;
                this.blockSorter = null;
                this.data = null;
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try (OutputStream outputStream = this.out;){
                this.finish();
            }
        }
    }

    @Override
    public void flush() throws IOException {
        OutputStream outputStream = this.out;
        if (outputStream != null) {
            outputStream.flush();
        }
    }

    private void init() throws IOException {
        this.bsPutUByte(66);
        this.bsPutUByte(90);
        this.data = new Data(this.blockSize100k);
        this.blockSorter = new BlockSort(this.data);
        this.bsPutUByte(104);
        this.bsPutUByte(48 + this.blockSize100k);
        this.combinedCRC = 0;
        this.initBlock();
    }

    private void initBlock() {
        this.crc.initialiseCRC();
        this.last = -1;
        boolean[] blArray = this.data.inUse;
        int n2 = 256;
        while (--n2 >= 0) {
            blArray[n2] = false;
        }
    }

    private void endBlock() throws IOException {
        this.blockCRC = this.crc.getFinalCRC();
        this.combinedCRC = this.combinedCRC << 1 | this.combinedCRC >>> 31;
        this.combinedCRC ^= this.blockCRC;
        if (this.last == -1) {
            return;
        }
        this.blockSort();
        this.bsPutUByte(49);
        this.bsPutUByte(65);
        this.bsPutUByte(89);
        this.bsPutUByte(38);
        this.bsPutUByte(83);
        this.bsPutUByte(89);
        this.bsPutInt(this.blockCRC);
        this.bsW(1, 0);
        this.moveToFrontCodeAndSend();
    }

    private void endCompression() throws IOException {
        this.bsPutUByte(23);
        this.bsPutUByte(114);
        this.bsPutUByte(69);
        this.bsPutUByte(56);
        this.bsPutUByte(80);
        this.bsPutUByte(144);
        this.bsPutInt(this.combinedCRC);
        this.bsFinishedWithStream();
    }

    public final int getBlockSize() {
        return this.blockSize100k;
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("offs(" + n2 + ") < 0.");
        }
        if (n3 < 0) {
            throw new IndexOutOfBoundsException("len(" + n3 + ") < 0.");
        }
        if (n2 + n3 > byArray.length) {
            throw new IndexOutOfBoundsException("offs(" + n2 + ") + len(" + n3 + ") > buf.length(" + byArray.length + ").");
        }
        if (this.closed) {
            throw new IOException("stream closed");
        }
        int n4 = n2 + n3;
        while (n2 < n4) {
            this.write0(byArray[n2++]);
        }
    }

    private void write0(int n2) throws IOException {
        if (this.currentChar != -1) {
            if (this.currentChar == (n2 &= 0xFF)) {
                if (++this.runLength > 254) {
                    this.writeRun();
                    this.currentChar = -1;
                    this.runLength = 0;
                }
            } else {
                this.writeRun();
                this.runLength = 1;
                this.currentChar = n2;
            }
        } else {
            this.currentChar = n2 & 0xFF;
            ++this.runLength;
        }
    }

    private static void hbAssignCodes(int[] nArray, byte[] byArray, int n2, int n3, int n4) {
        int n5 = 0;
        for (int i2 = n2; i2 <= n3; ++i2) {
            for (int i3 = 0; i3 < n4; ++i3) {
                if ((byArray[i3] & 0xFF) != i2) continue;
                nArray[i3] = n5++;
            }
            n5 <<= 1;
        }
    }

    private void bsFinishedWithStream() throws IOException {
        while (this.bsLive > 0) {
            int n2 = this.bsBuff >> 24;
            this.out.write(n2);
            this.bsBuff <<= 8;
            this.bsLive -= 8;
        }
    }

    private void bsW(int n2, int n3) throws IOException {
        int n4;
        OutputStream outputStream = this.out;
        int n5 = this.bsBuff;
        for (n4 = this.bsLive; n4 >= 8; n4 -= 8) {
            outputStream.write(n5 >> 24);
            n5 <<= 8;
        }
        this.bsBuff = n5 | n3 << 32 - n4 - n2;
        this.bsLive = n4 + n2;
    }

    private void bsPutUByte(int n2) throws IOException {
        this.bsW(8, n2);
    }

    private void bsPutInt(int n2) throws IOException {
        this.bsW(8, n2 >> 24 & 0xFF);
        this.bsW(8, n2 >> 16 & 0xFF);
        this.bsW(8, n2 >> 8 & 0xFF);
        this.bsW(8, n2 & 0xFF);
    }

    private void sendMTFValues() throws IOException {
        byte[][] byArray = this.data.sendMTFValues_len;
        int n2 = this.nInUse + 2;
        int n3 = 6;
        while (--n3 >= 0) {
            byte[] byArray2 = byArray[n3];
            int n4 = n2;
            while (--n4 >= 0) {
                byArray2[n4] = 15;
            }
        }
        n3 = this.nMTF < 200 ? 2 : (this.nMTF < 600 ? 3 : (this.nMTF < 1200 ? 4 : (this.nMTF < 2400 ? 5 : 6)));
        this.sendMTFValues0(n3, n2);
        int n5 = this.sendMTFValues1(n3, n2);
        this.sendMTFValues2(n3, n5);
        this.sendMTFValues3(n3, n2);
        this.sendMTFValues4();
        this.sendMTFValues5(n3, n5);
        this.sendMTFValues6(n3, n2);
        this.sendMTFValues7();
    }

    private void sendMTFValues0(int n2, int n3) {
        byte[][] byArray = this.data.sendMTFValues_len;
        int[] nArray = this.data.mtfFreq;
        int n4 = this.nMTF;
        int n5 = 0;
        for (int i2 = n2; i2 > 0; --i2) {
            int n6;
            int n7 = n4 / i2;
            int n8 = n5 - 1;
            int n9 = n3 - 1;
            for (n6 = 0; n6 < n7 && n8 < n9; n6 += nArray[++n8]) {
            }
            if (n8 > n5 && i2 != n2 && i2 != 1 && (n2 - i2 & 1) != 0) {
                n6 -= nArray[n8--];
            }
            byte[] byArray2 = byArray[i2 - 1];
            int n10 = n3;
            while (--n10 >= 0) {
                if (n10 >= n5 && n10 <= n8) {
                    byArray2[n10] = 0;
                    continue;
                }
                byArray2[n10] = 15;
            }
            n5 = n8 + 1;
            n4 -= n6;
        }
    }

    private int sendMTFValues1(int n2, int n3) {
        Data data = this.data;
        int[][] nArray = data.sendMTFValues_rfreq;
        int[] nArray2 = data.sendMTFValues_fave;
        short[] sArray = data.sendMTFValues_cost;
        char[] cArray = data.sfmap;
        byte[] byArray = data.selector;
        byte[][] byArray2 = data.sendMTFValues_len;
        byte[] byArray3 = byArray2[0];
        byte[] byArray4 = byArray2[1];
        byte[] byArray5 = byArray2[2];
        byte[] byArray6 = byArray2[3];
        byte[] byArray7 = byArray2[4];
        byte[] byArray8 = byArray2[5];
        int n4 = this.nMTF;
        int n5 = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            int n6;
            int n7 = n2;
            while (--n7 >= 0) {
                nArray2[n7] = 0;
                int[] nArray3 = nArray[n7];
                n6 = n3;
                while (--n6 >= 0) {
                    nArray3[n6] = 0;
                }
            }
            n5 = 0;
            n7 = 0;
            while (n7 < this.nMTF) {
                int n8;
                int n9;
                int n10;
                int n11 = Math.min(n7 + 50 - 1, n4 - 1);
                if (n2 == 6) {
                    n6 = 0;
                    n10 = 0;
                    n9 = 0;
                    n8 = 0;
                    short s2 = 0;
                    short s3 = 0;
                    for (int i3 = n7; i3 <= n11; ++i3) {
                        char c2 = cArray[i3];
                        n6 = (short)(n6 + (byArray3[c2] & 0xFF));
                        n10 = (short)(n10 + (byArray4[c2] & 0xFF));
                        n9 = (short)(n9 + (byArray5[c2] & 0xFF));
                        n8 = (short)(n8 + (byArray6[c2] & 0xFF));
                        s2 = (short)(s2 + (byArray7[c2] & 0xFF));
                        s3 = (short)(s3 + (byArray8[c2] & 0xFF));
                    }
                    sArray[0] = n6;
                    sArray[1] = n10;
                    sArray[2] = n9;
                    sArray[3] = n8;
                    sArray[4] = s2;
                    sArray[5] = s3;
                } else {
                    n6 = n2;
                    while (--n6 >= 0) {
                        sArray[n6] = 0;
                    }
                    for (n6 = n7; n6 <= n11; ++n6) {
                        char c3 = cArray[n6];
                        n9 = n2;
                        while (--n9 >= 0) {
                            int n12 = n9;
                            sArray[n12] = (short)(sArray[n12] + (byArray2[n9][c3] & 0xFF));
                        }
                    }
                }
                n6 = -1;
                n10 = n2;
                n9 = 999999999;
                while (--n10 >= 0) {
                    n8 = sArray[n10];
                    if (n8 >= n9) continue;
                    n9 = n8;
                    n6 = n10;
                }
                int n13 = n6;
                nArray2[n13] = nArray2[n13] + 1;
                byArray[n5] = (byte)n6;
                ++n5;
                int[] nArray4 = nArray[n6];
                for (n9 = n7; n9 <= n11; ++n9) {
                    char c4 = cArray[n9];
                    nArray4[c4] = nArray4[c4] + 1;
                }
                n7 = n11 + 1;
            }
            for (n7 = 0; n7 < n2; ++n7) {
                BZip2CompressorOutputStream.hbMakeCodeLengths(byArray2[n7], nArray[n7], this.data, n3, 20);
            }
        }
        return n5;
    }

    private void sendMTFValues2(int n2, int n3) {
        Data data = this.data;
        byte[] byArray = data.sendMTFValues2_pos;
        int n4 = n2;
        while (--n4 >= 0) {
            byArray[n4] = (byte)n4;
        }
        for (n4 = 0; n4 < n3; ++n4) {
            byte by2 = data.selector[n4];
            byte by3 = byArray[0];
            int n5 = 0;
            while (by2 != by3) {
                byte by4 = by3;
                by3 = byArray[++n5];
                byArray[n5] = by4;
            }
            byArray[0] = by3;
            data.selectorMtf[n4] = (byte)n5;
        }
    }

    private void sendMTFValues3(int n2, int n3) {
        int[][] nArray = this.data.sendMTFValues_code;
        byte[][] byArray = this.data.sendMTFValues_len;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = 32;
            int n5 = 0;
            byte[] byArray2 = byArray[i2];
            int n6 = n3;
            while (--n6 >= 0) {
                int n7 = byArray2[n6] & 0xFF;
                if (n7 > n5) {
                    n5 = n7;
                }
                if (n7 >= n4) continue;
                n4 = n7;
            }
            BZip2CompressorOutputStream.hbAssignCodes(nArray[i2], byArray[i2], n4, n5, n3);
        }
    }

    private void sendMTFValues4() throws IOException {
        int n2;
        int n3;
        boolean[] blArray = this.data.inUse;
        boolean[] blArray2 = this.data.sentMTFValues4_inUse16;
        int n4 = 16;
        while (--n4 >= 0) {
            blArray2[n4] = false;
            n3 = n4 * 16;
            n2 = 16;
            while (--n2 >= 0) {
                if (!blArray[n3 + n2]) continue;
                blArray2[n4] = true;
            }
        }
        for (n4 = 0; n4 < 16; ++n4) {
            this.bsW(1, blArray2[n4] ? 1 : 0);
        }
        OutputStream outputStream = this.out;
        n3 = this.bsLive;
        n2 = this.bsBuff;
        for (int i2 = 0; i2 < 16; ++i2) {
            if (!blArray2[i2]) continue;
            int n5 = i2 * 16;
            for (int i3 = 0; i3 < 16; ++i3) {
                while (n3 >= 8) {
                    outputStream.write(n2 >> 24);
                    n2 <<= 8;
                    n3 -= 8;
                }
                if (blArray[n5 + i3]) {
                    n2 |= 1 << 32 - n3 - 1;
                }
                ++n3;
            }
        }
        this.bsBuff = n2;
        this.bsLive = n3;
    }

    private void sendMTFValues5(int n2, int n3) throws IOException {
        this.bsW(3, n2);
        this.bsW(15, n3);
        OutputStream outputStream = this.out;
        byte[] byArray = this.data.selectorMtf;
        int n4 = this.bsLive;
        int n5 = this.bsBuff;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n6 = byArray[i2] & 0xFF;
            for (int i3 = 0; i3 < n6; ++i3) {
                while (n4 >= 8) {
                    outputStream.write(n5 >> 24);
                    n5 <<= 8;
                    n4 -= 8;
                }
                n5 |= 1 << 32 - n4 - 1;
                ++n4;
            }
            while (n4 >= 8) {
                outputStream.write(n5 >> 24);
                n5 <<= 8;
                n4 -= 8;
            }
            ++n4;
        }
        this.bsBuff = n5;
        this.bsLive = n4;
    }

    private void sendMTFValues6(int n2, int n3) throws IOException {
        byte[][] byArray = this.data.sendMTFValues_len;
        OutputStream outputStream = this.out;
        int n4 = this.bsLive;
        int n5 = this.bsBuff;
        for (int i2 = 0; i2 < n2; ++i2) {
            byte[] byArray2 = byArray[i2];
            int n6 = byArray2[0] & 0xFF;
            while (n4 >= 8) {
                outputStream.write(n5 >> 24);
                n5 <<= 8;
                n4 -= 8;
            }
            n5 |= n6 << 32 - n4 - 5;
            n4 += 5;
            for (int i3 = 0; i3 < n3; ++i3) {
                int n7 = byArray2[i3] & 0xFF;
                while (n6 < n7) {
                    while (n4 >= 8) {
                        outputStream.write(n5 >> 24);
                        n5 <<= 8;
                        n4 -= 8;
                    }
                    n5 |= 2 << 32 - n4 - 2;
                    n4 += 2;
                    ++n6;
                }
                while (n6 > n7) {
                    while (n4 >= 8) {
                        outputStream.write(n5 >> 24);
                        n5 <<= 8;
                        n4 -= 8;
                    }
                    n5 |= 3 << 32 - n4 - 2;
                    n4 += 2;
                    --n6;
                }
                while (n4 >= 8) {
                    outputStream.write(n5 >> 24);
                    n5 <<= 8;
                    n4 -= 8;
                }
                ++n4;
            }
        }
        this.bsBuff = n5;
        this.bsLive = n4;
    }

    private void sendMTFValues7() throws IOException {
        Data data = this.data;
        byte[][] byArray = data.sendMTFValues_len;
        int[][] nArray = data.sendMTFValues_code;
        OutputStream outputStream = this.out;
        byte[] byArray2 = data.selector;
        char[] cArray = data.sfmap;
        int n2 = this.nMTF;
        int n3 = 0;
        int n4 = this.bsLive;
        int n5 = this.bsBuff;
        int n6 = 0;
        while (n6 < n2) {
            int n7 = Math.min(n6 + 50 - 1, n2 - 1);
            int n8 = byArray2[n3] & 0xFF;
            int[] nArray2 = nArray[n8];
            byte[] byArray3 = byArray[n8];
            while (n6 <= n7) {
                char c2 = cArray[n6];
                while (n4 >= 8) {
                    outputStream.write(n5 >> 24);
                    n5 <<= 8;
                    n4 -= 8;
                }
                int n9 = byArray3[c2] & 0xFF;
                n5 |= nArray2[c2] << 32 - n4 - n9;
                n4 += n9;
                ++n6;
            }
            n6 = n7 + 1;
            ++n3;
        }
        this.bsBuff = n5;
        this.bsLive = n4;
    }

    private void moveToFrontCodeAndSend() throws IOException {
        this.bsW(24, this.data.origPtr);
        this.generateMTFValues();
        this.sendMTFValues();
    }

    private void blockSort() {
        this.blockSorter.blockSort(this.data, this.last);
    }

    private void generateMTFValues() {
        int n2;
        int n3;
        int n4 = this.last;
        Data data = this.data;
        boolean[] blArray = data.inUse;
        byte[] byArray = data.block;
        int[] nArray = data.fmap;
        char[] cArray = data.sfmap;
        int[] nArray2 = data.mtfFreq;
        byte[] byArray2 = data.unseqToSeq;
        byte[] byArray3 = data.generateMTFValues_yy;
        int n5 = 0;
        for (n3 = 0; n3 < 256; ++n3) {
            if (!blArray[n3]) continue;
            byArray2[n3] = (byte)n5;
            ++n5;
        }
        this.nInUse = n5;
        for (n2 = n3 = n5 + 1; n2 >= 0; --n2) {
            nArray2[n2] = 0;
        }
        n2 = n5;
        while (--n2 >= 0) {
            byArray3[n2] = (byte)n2;
        }
        n2 = 0;
        int n6 = 0;
        for (int i2 = 0; i2 <= n4; ++i2) {
            byte by2 = byArray2[byArray[nArray[i2]] & 0xFF];
            byte by3 = byArray3[0];
            int n7 = 0;
            while (by2 != by3) {
                byte by4 = by3;
                by3 = byArray3[++n7];
                byArray3[n7] = by4;
            }
            byArray3[0] = by3;
            if (n7 == 0) {
                ++n6;
                continue;
            }
            if (n6 > 0) {
                --n6;
                while (true) {
                    if ((n6 & 1) == 0) {
                        cArray[n2] = '\u0000';
                        ++n2;
                        nArray2[0] = nArray2[0] + 1;
                    } else {
                        cArray[n2] = '\u0001';
                        ++n2;
                        nArray2[1] = nArray2[1] + 1;
                    }
                    if (n6 < 2) break;
                    n6 = n6 - 2 >> 1;
                }
                n6 = 0;
            }
            cArray[n2] = (char)(n7 + 1);
            ++n2;
            int n8 = n7 + 1;
            nArray2[n8] = nArray2[n8] + 1;
        }
        if (n6 > 0) {
            --n6;
            while (true) {
                if ((n6 & 1) == 0) {
                    cArray[n2] = '\u0000';
                    ++n2;
                    nArray2[0] = nArray2[0] + 1;
                } else {
                    cArray[n2] = '\u0001';
                    ++n2;
                    nArray2[1] = nArray2[1] + 1;
                }
                if (n6 < 2) break;
                n6 = n6 - 2 >> 1;
            }
        }
        cArray[n2] = (char)n3;
        int n9 = n3;
        nArray2[n9] = nArray2[n9] + 1;
        this.nMTF = n2 + 1;
    }

    static final class Data {
        final boolean[] inUse = new boolean[256];
        final byte[] unseqToSeq = new byte[256];
        final int[] mtfFreq = new int[258];
        final byte[] selector = new byte[18002];
        final byte[] selectorMtf = new byte[18002];
        final byte[] generateMTFValues_yy = new byte[256];
        final byte[][] sendMTFValues_len = new byte[6][258];
        final int[][] sendMTFValues_rfreq = new int[6][258];
        final int[] sendMTFValues_fave = new int[6];
        final short[] sendMTFValues_cost = new short[6];
        final int[][] sendMTFValues_code = new int[6][258];
        final byte[] sendMTFValues2_pos = new byte[6];
        final boolean[] sentMTFValues4_inUse16 = new boolean[16];
        final int[] heap = new int[260];
        final int[] weight = new int[516];
        final int[] parent = new int[516];
        final byte[] block;
        final int[] fmap;
        final char[] sfmap;
        int origPtr;

        Data(int n2) {
            int n3 = n2 * 100000;
            this.block = new byte[n3 + 1 + 20];
            this.fmap = new int[n3];
            this.sfmap = new char[2 * n3];
        }
    }
}

