/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.compress.compressors.deflate;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import zz.org.apache.commons.compress.compressors.CompressorInputStream;
import zz.org.apache.commons.compress.compressors.deflate.DeflateParameters;
import zz.org.apache.commons.compress.utils.CountingInputStream;
import zz.org.apache.commons.compress.utils.IOUtils;
import zz.org.apache.commons.compress.utils.InputStreamStatistics;

public class DeflateCompressorInputStream
extends CompressorInputStream
implements InputStreamStatistics {
    private static final int MAGIC_1 = 120;
    private static final int MAGIC_2a = 1;
    private static final int MAGIC_2b = 94;
    private static final int MAGIC_2c = 156;
    private static final int MAGIC_2d = 218;
    private final CountingInputStream countingStream;
    private final InputStream in;
    private final Inflater inflater;

    public DeflateCompressorInputStream(InputStream inputStream) {
        this(inputStream, new DeflateParameters());
    }

    public DeflateCompressorInputStream(InputStream inputStream, DeflateParameters deflateParameters) {
        this.inflater = new Inflater(!deflateParameters.withZlibHeader());
        this.countingStream = new CountingInputStream(inputStream);
        this.in = new InflaterInputStream(this.countingStream, this.inflater);
    }

    @Override
    public int read() throws IOException {
        int n2 = this.in.read();
        this.count(n2 == -1 ? 0 : 1);
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.in.read(byArray, n2, n3);
        this.count(n4);
        return n4;
    }

    @Override
    public long skip(long l2) throws IOException {
        return IOUtils.skip(this.in, l2);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        try {
            this.in.close();
        }
        finally {
            this.inflater.end();
        }
    }

    @Override
    public long getCompressedCount() {
        return this.countingStream.getBytesRead();
    }

    public static boolean matches(byte[] byArray, int n2) {
        return n2 > 3 && byArray[0] == 120 && (byArray[1] == 1 || byArray[1] == 94 || byArray[1] == -100 || byArray[1] == -38);
    }
}

