/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.compress.compressors.deflate64;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.Arrays;
import zz.org.apache.commons.compress.compressors.deflate64.HuffmanState;
import zz.org.apache.commons.compress.utils.BitInputStream;

class HuffmanDecoder
implements Closeable {
    private static final short[] RUN_LENGTH_TABLE = new short[]{96, 128, 160, 192, 224, 256, 288, 320, 353, 417, 481, 545, 610, 738, 866, 994, 1123, 1379, 1635, 1891, 2148, 2660, 3172, 3684, 4197, 5221, 6245, 7269, 112};
    private static final int[] DISTANCE_TABLE = new int[]{16, 32, 48, 64, 81, 113, 146, 210, 275, 403, 532, 788, 1045, 1557, 2070, 3094, 4119, 6167, 8216, 12312, 16409, 24601, 32794, 49178, 65563, 98331, 131100, 196636, 262173, 393245, 524318, 786462};
    private static final int[] CODE_LENGTHS_ORDER = new int[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};
    private static final int[] FIXED_LITERALS = new int[288];
    private static final int[] FIXED_DISTANCE;
    private boolean finalBlock = false;
    private DecoderState state;
    private BitInputStream reader;
    private final InputStream in;
    private final DecodingMemory memory = new DecodingMemory();

    HuffmanDecoder(InputStream inputStream) {
        this.reader = new BitInputStream(inputStream, ByteOrder.LITTLE_ENDIAN);
        this.in = inputStream;
        this.state = new InitialState();
    }

    @Override
    public void close() {
        this.state = new InitialState();
        this.reader = null;
    }

    public int decode(byte[] byArray) throws IOException {
        return this.decode(byArray, 0, byArray.length);
    }

    public int decode(byte[] byArray, int n2, int n3) throws IOException {
        block5: while (!this.finalBlock || this.state.hasData()) {
            if (this.state.state() == HuffmanState.INITIAL) {
                this.finalBlock = this.readBits(1) == 1L;
                int n4 = (int)this.readBits(2);
                switch (n4) {
                    case 0: {
                        this.switchToUncompressedState();
                        continue block5;
                    }
                    case 1: {
                        this.state = new HuffmanCodes(HuffmanState.FIXED_CODES, FIXED_LITERALS, FIXED_DISTANCE);
                        continue block5;
                    }
                    case 2: {
                        int[][] nArray = this.readDynamicTables();
                        this.state = new HuffmanCodes(HuffmanState.DYNAMIC_CODES, nArray[0], nArray[1]);
                        continue block5;
                    }
                }
                throw new IllegalStateException("Unsupported compression: " + n4);
            }
            return this.state.read(byArray, n2, n3);
        }
        return -1;
    }

    long getBytesRead() {
        return this.reader.getBytesRead();
    }

    private void switchToUncompressedState() throws IOException {
        this.reader.alignWithByteBoundary();
        long l2 = this.readBits(16);
        long l3 = this.readBits(16);
        if (((l2 ^ 0xFFFFL) & 0xFFFFL) != l3) {
            throw new IllegalStateException("Illegal LEN / NLEN values");
        }
        this.state = new UncompressedState(l2);
    }

    private int[][] readDynamicTables() throws IOException {
        int[][] nArrayArray = new int[2][];
        int n2 = (int)(this.readBits(5) + 257L);
        nArrayArray[0] = new int[n2];
        int n3 = (int)(this.readBits(5) + 1L);
        nArrayArray[1] = new int[n3];
        HuffmanDecoder.populateDynamicTables(this.reader, nArrayArray[0], nArrayArray[1]);
        return nArrayArray;
    }

    int available() throws IOException {
        return this.state.available();
    }

    private static int nextSymbol(BitInputStream bitInputStream, BinaryTreeNode binaryTreeNode) throws IOException {
        BinaryTreeNode binaryTreeNode2 = binaryTreeNode;
        while (binaryTreeNode2 != null && binaryTreeNode2.literal == -1) {
            long l2 = HuffmanDecoder.readBits(bitInputStream, 1);
            binaryTreeNode2 = l2 == 0L ? binaryTreeNode2.leftNode : binaryTreeNode2.rightNode;
        }
        return binaryTreeNode2 != null ? binaryTreeNode2.literal : -1;
    }

    private static void populateDynamicTables(BitInputStream bitInputStream, int[] nArray, int[] nArray2) throws IOException {
        int n2 = (int)(HuffmanDecoder.readBits(bitInputStream, 4) + 4L);
        int[] nArray3 = new int[19];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray3[HuffmanDecoder.CODE_LENGTHS_ORDER[i2]] = (int)HuffmanDecoder.readBits(bitInputStream, 3);
        }
        BinaryTreeNode binaryTreeNode = HuffmanDecoder.buildTree(nArray3);
        int[] nArray4 = new int[nArray.length + nArray2.length];
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        while (n5 < nArray4.length) {
            if (n4 > 0) {
                nArray4[n5++] = n3;
                --n4;
                continue;
            }
            int n6 = HuffmanDecoder.nextSymbol(bitInputStream, binaryTreeNode);
            if (n6 < 16) {
                n3 = n6;
                nArray4[n5++] = n3;
                continue;
            }
            if (n6 == 16) {
                n4 = (int)(HuffmanDecoder.readBits(bitInputStream, 2) + 3L);
                continue;
            }
            if (n6 == 17) {
                n3 = 0;
                n4 = (int)(HuffmanDecoder.readBits(bitInputStream, 3) + 3L);
                continue;
            }
            if (n6 != 18) continue;
            n3 = 0;
            n4 = (int)(HuffmanDecoder.readBits(bitInputStream, 7) + 11L);
        }
        System.arraycopy(nArray4, 0, nArray, 0, nArray.length);
        System.arraycopy(nArray4, nArray.length, nArray2, 0, nArray2.length);
    }

    private static BinaryTreeNode buildTree(int[] nArray) {
        int[] nArray2 = HuffmanDecoder.getCodes(nArray);
        BinaryTreeNode binaryTreeNode = new BinaryTreeNode(0);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            if (n2 == 0) continue;
            BinaryTreeNode binaryTreeNode2 = binaryTreeNode;
            int n3 = nArray2[n2 - 1];
            for (int i3 = n2 - 1; i3 >= 0; --i3) {
                int n4 = n3 & 1 << i3;
                binaryTreeNode2 = n4 == 0 ? binaryTreeNode2.left() : binaryTreeNode2.right();
            }
            binaryTreeNode2.leaf(i2);
            int n5 = n2 - 1;
            nArray2[n5] = nArray2[n5] + 1;
        }
        return binaryTreeNode;
    }

    private static int[] getCodes(int[] nArray) {
        int n2;
        int n3 = 0;
        int[] nArray2 = new int[65];
        int[] nArray3 = nArray;
        int n4 = nArray3.length;
        for (n2 = 0; n2 < n4; ++n2) {
            int n5 = nArray3[n2];
            n3 = Math.max(n3, n5);
            int n6 = n5;
            nArray2[n6] = nArray2[n6] + 1;
        }
        nArray2 = Arrays.copyOf(nArray2, n3 + 1);
        int n7 = 0;
        int[] nArray4 = new int[n3 + 1];
        for (n2 = 0; n2 <= n3; ++n2) {
            nArray4[n2] = n7 = n7 + nArray2[n2] << 1;
        }
        return nArray4;
    }

    private long readBits(int n2) throws IOException {
        return HuffmanDecoder.readBits(this.reader, n2);
    }

    private static long readBits(BitInputStream bitInputStream, int n2) throws IOException {
        long l2 = bitInputStream.readBits(n2);
        if (l2 == -1L) {
            throw new EOFException("Truncated Deflate64 Stream");
        }
        return l2;
    }

    static {
        Arrays.fill(FIXED_LITERALS, 0, 144, 8);
        Arrays.fill(FIXED_LITERALS, 144, 256, 9);
        Arrays.fill(FIXED_LITERALS, 256, 280, 7);
        Arrays.fill(FIXED_LITERALS, 280, 288, 8);
        FIXED_DISTANCE = new int[32];
        Arrays.fill(FIXED_DISTANCE, 5);
    }

    private static class DecodingMemory {
        private final byte[] memory;
        private final int mask;
        private int wHead;
        private boolean wrappedAround;

        private DecodingMemory() {
            this(16);
        }

        private DecodingMemory(int n2) {
            this.memory = new byte[1 << n2];
            this.mask = this.memory.length - 1;
        }

        byte add(byte by2) {
            this.memory[this.wHead] = by2;
            this.wHead = this.incCounter(this.wHead);
            return by2;
        }

        void add(byte[] byArray, int n2, int n3) {
            for (int i2 = n2; i2 < n2 + n3; ++i2) {
                this.add(byArray[i2]);
            }
        }

        void recordToBuffer(int n2, int n3, byte[] byArray) {
            if (n2 > this.memory.length) {
                throw new IllegalStateException("Illegal distance parameter: " + n2);
            }
            int n4 = this.wHead - n2 & this.mask;
            if (!this.wrappedAround && n4 >= this.wHead) {
                throw new IllegalStateException("Attempt to read beyond memory: dist=" + n2);
            }
            int n5 = n4;
            for (int i2 = 0; i2 < n3; ++i2) {
                byArray[i2] = this.add(this.memory[n5]);
                n5 = this.incCounter(n5);
            }
        }

        private int incCounter(int n2) {
            int n3 = n2 + 1 & this.mask;
            if (!this.wrappedAround && n3 < n2) {
                this.wrappedAround = true;
            }
            return n3;
        }
    }

    private static class BinaryTreeNode {
        private final int bits;
        int literal = -1;
        BinaryTreeNode leftNode;
        BinaryTreeNode rightNode;

        private BinaryTreeNode(int n2) {
            this.bits = n2;
        }

        void leaf(int n2) {
            this.literal = n2;
            this.leftNode = null;
            this.rightNode = null;
        }

        BinaryTreeNode left() {
            if (this.leftNode == null && this.literal == -1) {
                this.leftNode = new BinaryTreeNode(this.bits + 1);
            }
            return this.leftNode;
        }

        BinaryTreeNode right() {
            if (this.rightNode == null && this.literal == -1) {
                this.rightNode = new BinaryTreeNode(this.bits + 1);
            }
            return this.rightNode;
        }
    }

    private class HuffmanCodes
    extends DecoderState {
        private boolean endOfBlock;
        private final HuffmanState state;
        private final BinaryTreeNode lengthTree;
        private final BinaryTreeNode distanceTree;
        private int runBufferPos;
        private byte[] runBuffer;
        private int runBufferLength;

        HuffmanCodes(HuffmanState huffmanState, int[] nArray, int[] nArray2) {
            this.endOfBlock = false;
            this.runBufferPos = 0;
            this.runBuffer = new byte[0];
            this.runBufferLength = 0;
            this.state = huffmanState;
            this.lengthTree = HuffmanDecoder.buildTree(nArray);
            this.distanceTree = HuffmanDecoder.buildTree(nArray2);
        }

        @Override
        HuffmanState state() {
            return this.endOfBlock ? HuffmanState.INITIAL : this.state;
        }

        @Override
        int read(byte[] byArray, int n2, int n3) throws IOException {
            return this.decodeNext(byArray, n2, n3);
        }

        private int decodeNext(byte[] byArray, int n2, int n3) throws IOException {
            if (this.endOfBlock) {
                return -1;
            }
            int n4 = this.copyFromRunBuffer(byArray, n2, n3);
            while (n4 < n3) {
                int n5 = HuffmanDecoder.nextSymbol(HuffmanDecoder.this.reader, this.lengthTree);
                if (n5 < 256) {
                    byArray[n2 + n4++] = HuffmanDecoder.this.memory.add((byte)n5);
                    continue;
                }
                if (n5 > 256) {
                    short s2 = RUN_LENGTH_TABLE[n5 - 257];
                    int n6 = s2 >>> 5;
                    int n7 = s2 & 0x1F;
                    n6 = (int)((long)n6 + HuffmanDecoder.this.readBits(n7));
                    int n8 = HuffmanDecoder.nextSymbol(HuffmanDecoder.this.reader, this.distanceTree);
                    int n9 = DISTANCE_TABLE[n8];
                    int n10 = n9 >>> 4;
                    int n11 = n9 & 0xF;
                    n10 = (int)((long)n10 + HuffmanDecoder.this.readBits(n11));
                    if (this.runBuffer.length < n6) {
                        this.runBuffer = new byte[n6];
                    }
                    this.runBufferLength = n6;
                    this.runBufferPos = 0;
                    HuffmanDecoder.this.memory.recordToBuffer(n10, n6, this.runBuffer);
                    n4 += this.copyFromRunBuffer(byArray, n2 + n4, n3 - n4);
                    continue;
                }
                this.endOfBlock = true;
                return n4;
            }
            return n4;
        }

        private int copyFromRunBuffer(byte[] byArray, int n2, int n3) {
            int n4 = this.runBufferLength - this.runBufferPos;
            int n5 = 0;
            if (n4 > 0) {
                n5 = Math.min(n3, n4);
                System.arraycopy(this.runBuffer, this.runBufferPos, byArray, n2, n5);
                this.runBufferPos += n5;
            }
            return n5;
        }

        @Override
        boolean hasData() {
            return !this.endOfBlock;
        }

        @Override
        int available() {
            return this.runBufferLength - this.runBufferPos;
        }
    }

    private class InitialState
    extends DecoderState {
        private InitialState() {
        }

        @Override
        HuffmanState state() {
            return HuffmanState.INITIAL;
        }

        @Override
        int read(byte[] byArray, int n2, int n3) throws IOException {
            throw new IllegalStateException("Cannot read in this state");
        }

        @Override
        boolean hasData() {
            return false;
        }

        @Override
        int available() {
            return 0;
        }
    }

    private class UncompressedState
    extends DecoderState {
        private final long blockLength;
        private long read;

        private UncompressedState(long l2) {
            this.blockLength = l2;
        }

        @Override
        HuffmanState state() {
            return this.read < this.blockLength ? HuffmanState.STORED : HuffmanState.INITIAL;
        }

        @Override
        int read(byte[] byArray, int n2, int n3) throws IOException {
            int n4;
            int n5 = (int)Math.min(this.blockLength - this.read, (long)n3);
            for (int i2 = 0; i2 < n5; i2 += n4) {
                if (HuffmanDecoder.this.reader.bitsCached() > 0) {
                    byte by2 = (byte)HuffmanDecoder.this.readBits(8);
                    byArray[n2 + i2] = HuffmanDecoder.this.memory.add(by2);
                    n4 = 1;
                } else {
                    n4 = HuffmanDecoder.this.in.read(byArray, n2 + i2, n5 - i2);
                    if (n4 == -1) {
                        throw new EOFException("Truncated Deflate64 Stream");
                    }
                    HuffmanDecoder.this.memory.add(byArray, n2 + i2, n4);
                }
                this.read += (long)n4;
            }
            return n5;
        }

        @Override
        boolean hasData() {
            return this.read < this.blockLength;
        }

        @Override
        int available() throws IOException {
            return (int)Math.min(this.blockLength - this.read, HuffmanDecoder.this.reader.bitsAvailable() / 8L);
        }
    }

    private static abstract class DecoderState {
        private DecoderState() {
        }

        abstract HuffmanState state();

        abstract int read(byte[] var1, int var2, int var3) throws IOException;

        abstract boolean hasData();

        abstract int available() throws IOException;
    }
}

