/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.compress.compressors.lz4;

import java.io.IOException;
import java.io.InputStream;
import zz.org.apache.commons.compress.compressors.lz77support.AbstractLZ77CompressorInputStream;
import zz.org.apache.commons.compress.utils.ByteUtils;

public class BlockLZ4CompressorInputStream
extends AbstractLZ77CompressorInputStream {
    static final int WINDOW_SIZE = 65536;
    static final int SIZE_BITS = 4;
    static final int BACK_REFERENCE_SIZE_MASK = 15;
    static final int LITERAL_SIZE_MASK = 240;
    private int nextBackReferenceSize;
    private State state = State.NO_BLOCK;

    public BlockLZ4CompressorInputStream(InputStream inputStream) throws IOException {
        super(inputStream, 65536);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        switch (this.state) {
            case EOF: {
                return -1;
            }
            case NO_BLOCK: {
                this.readSizes();
            }
            case IN_LITERAL: {
                int n4 = this.readLiteral(byArray, n2, n3);
                if (!this.hasMoreDataInBlock()) {
                    this.state = State.LOOKING_FOR_BACK_REFERENCE;
                }
                return n4 > 0 ? n4 : this.read(byArray, n2, n3);
            }
            case LOOKING_FOR_BACK_REFERENCE: {
                if (!this.initializeBackReference()) {
                    this.state = State.EOF;
                    return -1;
                }
            }
            case IN_BACK_REFERENCE: {
                int n5 = this.readBackReference(byArray, n2, n3);
                if (!this.hasMoreDataInBlock()) {
                    this.state = State.NO_BLOCK;
                }
                return n5 > 0 ? n5 : this.read(byArray, n2, n3);
            }
        }
        throw new IOException("Unknown stream state " + (Object)((Object)this.state));
    }

    private void readSizes() throws IOException {
        int n2 = this.readOneByte();
        if (n2 == -1) {
            throw new IOException("Premature end of stream while looking for next block");
        }
        this.nextBackReferenceSize = n2 & 0xF;
        long l2 = (n2 & 0xF0) >> 4;
        if (l2 == 15L) {
            l2 += this.readSizeBytes();
        }
        this.startLiteral(l2);
        this.state = State.IN_LITERAL;
    }

    private long readSizeBytes() throws IOException {
        int n2;
        long l2 = 0L;
        do {
            if ((n2 = this.readOneByte()) == -1) {
                throw new IOException("Premature end of stream while parsing length");
            }
            l2 += (long)n2;
        } while (n2 == 255);
        return l2;
    }

    private boolean initializeBackReference() throws IOException {
        int n2 = 0;
        try {
            n2 = (int)ByteUtils.fromLittleEndian(this.supplier, 2);
        }
        catch (IOException iOException) {
            if (this.nextBackReferenceSize == 0) {
                return false;
            }
            throw iOException;
        }
        long l2 = this.nextBackReferenceSize;
        if (this.nextBackReferenceSize == 15) {
            l2 += this.readSizeBytes();
        }
        this.startBackReference(n2, l2 + 4L);
        this.state = State.IN_BACK_REFERENCE;
        return true;
    }

    private static enum State {
        NO_BLOCK,
        IN_LITERAL,
        LOOKING_FOR_BACK_REFERENCE,
        IN_BACK_REFERENCE,
        EOF;

    }
}

