/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.compress.compressors.lz4;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import zz.org.apache.commons.compress.compressors.CompressorInputStream;
import zz.org.apache.commons.compress.compressors.lz4.BlockLZ4CompressorInputStream;
import zz.org.apache.commons.compress.compressors.lz4.XXHash32;
import zz.org.apache.commons.compress.utils.BoundedInputStream;
import zz.org.apache.commons.compress.utils.ByteUtils;
import zz.org.apache.commons.compress.utils.ChecksumCalculatingInputStream;
import zz.org.apache.commons.compress.utils.CountingInputStream;
import zz.org.apache.commons.compress.utils.IOUtils;
import zz.org.apache.commons.compress.utils.InputStreamStatistics;

public class FramedLZ4CompressorInputStream
extends CompressorInputStream
implements InputStreamStatistics {
    static final byte[] LZ4_SIGNATURE = new byte[]{4, 34, 77, 24};
    private static final byte[] SKIPPABLE_FRAME_TRAILER = new byte[]{42, 77, 24};
    private static final byte SKIPPABLE_FRAME_PREFIX_BYTE_MASK = 80;
    static final int VERSION_MASK = 192;
    static final int SUPPORTED_VERSION = 64;
    static final int BLOCK_INDEPENDENCE_MASK = 32;
    static final int BLOCK_CHECKSUM_MASK = 16;
    static final int CONTENT_SIZE_MASK = 8;
    static final int CONTENT_CHECKSUM_MASK = 4;
    static final int BLOCK_MAX_SIZE_MASK = 112;
    static final int UNCOMPRESSED_FLAG_MASK = Integer.MIN_VALUE;
    private final byte[] oneByte = new byte[1];
    private final ByteUtils.ByteSupplier supplier = new ByteUtils.ByteSupplier(){

        @Override
        public int getAsByte() throws IOException {
            return FramedLZ4CompressorInputStream.this.readOneByte();
        }
    };
    private final CountingInputStream in;
    private final boolean decompressConcatenated;
    private boolean expectBlockChecksum;
    private boolean expectBlockDependency;
    private boolean expectContentSize;
    private boolean expectContentChecksum;
    private InputStream currentBlock;
    private boolean endReached;
    private boolean inUncompressed;
    private final XXHash32 contentHash = new XXHash32();
    private final XXHash32 blockHash = new XXHash32();
    private byte[] blockDependencyBuffer;

    public FramedLZ4CompressorInputStream(InputStream inputStream) throws IOException {
        this(inputStream, false);
    }

    public FramedLZ4CompressorInputStream(InputStream inputStream, boolean bl2) throws IOException {
        this.in = new CountingInputStream(inputStream);
        this.decompressConcatenated = bl2;
        this.init(true);
    }

    @Override
    public int read() throws IOException {
        return this.read(this.oneByte, 0, 1) == -1 ? -1 : this.oneByte[0] & 0xFF;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.currentBlock != null) {
                this.currentBlock.close();
                this.currentBlock = null;
            }
        }
        finally {
            this.in.close();
        }
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.endReached) {
            return -1;
        }
        int n4 = this.readOnce(byArray, n2, n3);
        if (n4 == -1) {
            this.nextBlock();
            if (!this.endReached) {
                n4 = this.readOnce(byArray, n2, n3);
            }
        }
        if (n4 != -1) {
            if (this.expectBlockDependency) {
                this.appendToBlockDependencyBuffer(byArray, n2, n4);
            }
            if (this.expectContentChecksum) {
                this.contentHash.update(byArray, n2, n4);
            }
        }
        return n4;
    }

    @Override
    public long getCompressedCount() {
        return this.in.getBytesRead();
    }

    private void init(boolean bl2) throws IOException {
        if (this.readSignature(bl2)) {
            this.readFrameDescriptor();
            this.nextBlock();
        }
    }

    private boolean readSignature(boolean bl2) throws IOException {
        String string = bl2 ? "Not a LZ4 frame stream" : "LZ4 frame stream followed by garbage";
        byte[] byArray = new byte[4];
        int n2 = IOUtils.readFully(this.in, byArray);
        this.count(n2);
        if (0 == n2 && !bl2) {
            this.endReached = true;
            return false;
        }
        if (4 != n2) {
            throw new IOException(string);
        }
        n2 = this.skipSkippableFrame(byArray);
        if (0 == n2 && !bl2) {
            this.endReached = true;
            return false;
        }
        if (4 != n2 || !FramedLZ4CompressorInputStream.matches(byArray, 4)) {
            throw new IOException(string);
        }
        return true;
    }

    private void readFrameDescriptor() throws IOException {
        int n2;
        int n3;
        int n4 = this.readOneByte();
        if (n4 == -1) {
            throw new IOException("Premature end of stream while reading frame flags");
        }
        this.contentHash.update(n4);
        if ((n4 & 0xC0) != 64) {
            throw new IOException("Unsupported version " + (n4 >> 6));
        }
        boolean bl2 = this.expectBlockDependency = (n4 & 0x20) == 0;
        if (this.expectBlockDependency) {
            if (this.blockDependencyBuffer == null) {
                this.blockDependencyBuffer = new byte[65536];
            }
        } else {
            this.blockDependencyBuffer = null;
        }
        this.expectBlockChecksum = (n4 & 0x10) != 0;
        this.expectContentSize = (n4 & 8) != 0;
        this.expectContentChecksum = (n4 & 4) != 0;
        int n5 = this.readOneByte();
        if (n5 == -1) {
            throw new IOException("Premature end of stream while reading frame BD byte");
        }
        this.contentHash.update(n5);
        if (this.expectContentSize) {
            byte[] byArray = new byte[8];
            n3 = IOUtils.readFully(this.in, byArray);
            this.count(n3);
            if (8 != n3) {
                throw new IOException("Premature end of stream while reading content size");
            }
            this.contentHash.update(byArray, 0, byArray.length);
        }
        if ((n2 = this.readOneByte()) == -1) {
            throw new IOException("Premature end of stream while reading frame header checksum");
        }
        n3 = (int)(this.contentHash.getValue() >> 8 & 0xFFL);
        this.contentHash.reset();
        if (n2 != n3) {
            throw new IOException("frame header checksum mismatch.");
        }
    }

    private void nextBlock() throws IOException {
        this.maybeFinishCurrentBlock();
        long l2 = ByteUtils.fromLittleEndian(this.supplier, 4);
        boolean bl2 = (l2 & Integer.MIN_VALUE) != 0L;
        int n2 = (int)(l2 & Integer.MAX_VALUE);
        if (n2 == 0) {
            this.verifyContentChecksum();
            if (!this.decompressConcatenated) {
                this.endReached = true;
            } else {
                this.init(false);
            }
            return;
        }
        InputStream inputStream = new BoundedInputStream(this.in, n2);
        if (this.expectBlockChecksum) {
            inputStream = new ChecksumCalculatingInputStream(this.blockHash, inputStream);
        }
        if (bl2) {
            this.inUncompressed = true;
            this.currentBlock = inputStream;
        } else {
            this.inUncompressed = false;
            BlockLZ4CompressorInputStream blockLZ4CompressorInputStream = new BlockLZ4CompressorInputStream(inputStream);
            if (this.expectBlockDependency) {
                blockLZ4CompressorInputStream.prefill(this.blockDependencyBuffer);
            }
            this.currentBlock = blockLZ4CompressorInputStream;
        }
    }

    private void maybeFinishCurrentBlock() throws IOException {
        if (this.currentBlock != null) {
            this.currentBlock.close();
            this.currentBlock = null;
            if (this.expectBlockChecksum) {
                this.verifyChecksum(this.blockHash, "block");
                this.blockHash.reset();
            }
        }
    }

    private void verifyContentChecksum() throws IOException {
        if (this.expectContentChecksum) {
            this.verifyChecksum(this.contentHash, "content");
        }
        this.contentHash.reset();
    }

    private void verifyChecksum(XXHash32 xXHash32, String string) throws IOException {
        byte[] byArray = new byte[4];
        int n2 = IOUtils.readFully(this.in, byArray);
        this.count(n2);
        if (4 != n2) {
            throw new IOException("Premature end of stream while reading " + string + " checksum");
        }
        long l2 = xXHash32.getValue();
        if (l2 != ByteUtils.fromLittleEndian(byArray)) {
            throw new IOException(string + " checksum mismatch.");
        }
    }

    private int readOneByte() throws IOException {
        int n2 = this.in.read();
        if (n2 != -1) {
            this.count(1);
            return n2 & 0xFF;
        }
        return -1;
    }

    private int readOnce(byte[] byArray, int n2, int n3) throws IOException {
        if (this.inUncompressed) {
            int n4 = this.currentBlock.read(byArray, n2, n3);
            this.count(n4);
            return n4;
        }
        BlockLZ4CompressorInputStream blockLZ4CompressorInputStream = (BlockLZ4CompressorInputStream)this.currentBlock;
        long l2 = blockLZ4CompressorInputStream.getBytesRead();
        int n5 = this.currentBlock.read(byArray, n2, n3);
        this.count(blockLZ4CompressorInputStream.getBytesRead() - l2);
        return n5;
    }

    private static boolean isSkippableFrameSignature(byte[] byArray) {
        if ((byArray[0] & 0x50) != 80) {
            return false;
        }
        for (int i2 = 1; i2 < 4; ++i2) {
            if (byArray[i2] == SKIPPABLE_FRAME_TRAILER[i2 - 1]) continue;
            return false;
        }
        return true;
    }

    private int skipSkippableFrame(byte[] byArray) throws IOException {
        int n2 = 4;
        while (n2 == 4 && FramedLZ4CompressorInputStream.isSkippableFrameSignature(byArray)) {
            long l2 = ByteUtils.fromLittleEndian(this.supplier, 4);
            long l3 = IOUtils.skip(this.in, l2);
            this.count(l3);
            if (l2 != l3) {
                throw new IOException("Premature end of stream while skipping frame");
            }
            n2 = IOUtils.readFully(this.in, byArray);
            this.count(n2);
        }
        return n2;
    }

    private void appendToBlockDependencyBuffer(byte[] byArray, int n2, int n3) {
        if ((n3 = Math.min(n3, this.blockDependencyBuffer.length)) > 0) {
            int n4 = this.blockDependencyBuffer.length - n3;
            if (n4 > 0) {
                System.arraycopy(this.blockDependencyBuffer, n3, this.blockDependencyBuffer, 0, n4);
            }
            System.arraycopy(byArray, n2, this.blockDependencyBuffer, n4, n3);
        }
    }

    public static boolean matches(byte[] byArray, int n2) {
        if (n2 < LZ4_SIGNATURE.length) {
            return false;
        }
        byte[] byArray2 = byArray;
        if (byArray.length > LZ4_SIGNATURE.length) {
            byArray2 = new byte[LZ4_SIGNATURE.length];
            System.arraycopy(byArray, 0, byArray2, 0, LZ4_SIGNATURE.length);
        }
        return Arrays.equals(byArray2, LZ4_SIGNATURE);
    }
}

