/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.compress.compressors.lz4;

import java.util.zip.Checksum;
import zz.org.apache.commons.compress.utils.ByteUtils;

public class XXHash32
implements Checksum {
    private static final int BUF_SIZE = 16;
    private static final int ROTATE_BITS = 13;
    private static final int PRIME1 = -1640531535;
    private static final int PRIME2 = -2048144777;
    private static final int PRIME3 = -1028477379;
    private static final int PRIME4 = 668265263;
    private static final int PRIME5 = 374761393;
    private final byte[] oneByte = new byte[1];
    private final int[] state = new int[4];
    private final byte[] buffer = new byte[16];
    private final int seed;
    private int totalLen;
    private int pos;

    public XXHash32() {
        this(0);
    }

    public XXHash32(int n2) {
        this.seed = n2;
        this.initializeState();
    }

    @Override
    public void reset() {
        this.initializeState();
        this.totalLen = 0;
        this.pos = 0;
    }

    @Override
    public void update(int n2) {
        this.oneByte[0] = (byte)(n2 & 0xFF);
        this.update(this.oneByte, 0, 1);
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        int n4;
        if (n3 <= 0) {
            return;
        }
        this.totalLen += n3;
        int n5 = n2 + n3;
        if (this.pos + n3 < 16) {
            System.arraycopy(byArray, n2, this.buffer, this.pos, n3);
            this.pos += n3;
            return;
        }
        if (this.pos > 0) {
            n4 = 16 - this.pos;
            System.arraycopy(byArray, n2, this.buffer, this.pos, n4);
            this.process(this.buffer, 0);
            n2 += n4;
        }
        n4 = n5 - 16;
        while (n2 <= n4) {
            this.process(byArray, n2);
            n2 += 16;
        }
        if (n2 < n5) {
            this.pos = n5 - n2;
            System.arraycopy(byArray, n2, this.buffer, 0, this.pos);
        }
    }

    @Override
    public long getValue() {
        int n2;
        int n3 = this.totalLen > 16 ? Integer.rotateLeft(this.state[0], 1) + Integer.rotateLeft(this.state[1], 7) + Integer.rotateLeft(this.state[2], 12) + Integer.rotateLeft(this.state[3], 18) : this.state[2] + 374761393;
        n3 += this.totalLen;
        int n4 = this.pos - 4;
        for (n2 = 0; n2 <= n4; n2 += 4) {
            n3 = Integer.rotateLeft(n3 + XXHash32.getInt(this.buffer, n2) * -1028477379, 17) * 668265263;
        }
        while (n2 < this.pos) {
            n3 = Integer.rotateLeft(n3 + (this.buffer[n2++] & 0xFF) * 374761393, 11) * -1640531535;
        }
        n3 ^= n3 >>> 15;
        n3 *= -2048144777;
        n3 ^= n3 >>> 13;
        n3 *= -1028477379;
        n3 ^= n3 >>> 16;
        return (long)n3 & 0xFFFFFFFFL;
    }

    private static int getInt(byte[] byArray, int n2) {
        return (int)(ByteUtils.fromLittleEndian(byArray, n2, 4) & 0xFFFFFFFFL);
    }

    private void initializeState() {
        this.state[0] = this.seed + -1640531535 + -2048144777;
        this.state[1] = this.seed + -2048144777;
        this.state[2] = this.seed;
        this.state[3] = this.seed - -1640531535;
    }

    private void process(byte[] byArray, int n2) {
        int n3 = this.state[0];
        int n4 = this.state[1];
        int n5 = this.state[2];
        int n6 = this.state[3];
        n3 = Integer.rotateLeft(n3 + XXHash32.getInt(byArray, n2) * -2048144777, 13) * -1640531535;
        n4 = Integer.rotateLeft(n4 + XXHash32.getInt(byArray, n2 + 4) * -2048144777, 13) * -1640531535;
        n5 = Integer.rotateLeft(n5 + XXHash32.getInt(byArray, n2 + 8) * -2048144777, 13) * -1640531535;
        n6 = Integer.rotateLeft(n6 + XXHash32.getInt(byArray, n2 + 12) * -2048144777, 13) * -1640531535;
        this.state[0] = n3;
        this.state[1] = n4;
        this.state[2] = n5;
        this.state[3] = n6;
        this.pos = 0;
    }
}

