/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.compress.compressors.lz77support;

public final class Parameters {
    public static final int TRUE_MIN_BACK_REFERENCE_LENGTH = 3;
    private final int windowSize;
    private final int minBackReferenceLength;
    private final int maxBackReferenceLength;
    private final int maxOffset;
    private final int maxLiteralLength;
    private final int niceBackReferenceLength;
    private final int maxCandidates;
    private final int lazyThreshold;
    private final boolean lazyMatching;

    public static Builder builder(int n2) {
        return new Builder(n2);
    }

    private Parameters(int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl2, int n9) {
        this.windowSize = n2;
        this.minBackReferenceLength = n3;
        this.maxBackReferenceLength = n4;
        this.maxOffset = n5;
        this.maxLiteralLength = n6;
        this.niceBackReferenceLength = n7;
        this.maxCandidates = n8;
        this.lazyMatching = bl2;
        this.lazyThreshold = n9;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public int getMinBackReferenceLength() {
        return this.minBackReferenceLength;
    }

    public int getMaxBackReferenceLength() {
        return this.maxBackReferenceLength;
    }

    public int getMaxOffset() {
        return this.maxOffset;
    }

    public int getMaxLiteralLength() {
        return this.maxLiteralLength;
    }

    public int getNiceBackReferenceLength() {
        return this.niceBackReferenceLength;
    }

    public int getMaxCandidates() {
        return this.maxCandidates;
    }

    public boolean getLazyMatching() {
        return this.lazyMatching;
    }

    public int getLazyMatchingThreshold() {
        return this.lazyThreshold;
    }

    private static final boolean isPowerOfTwo(int n2) {
        return (n2 & n2 - 1) == 0;
    }

    public static class Builder {
        private final int windowSize;
        private int minBackReferenceLength;
        private int maxBackReferenceLength;
        private int maxOffset;
        private int maxLiteralLength;
        private Integer niceBackReferenceLength;
        private Integer maxCandidates;
        private Integer lazyThreshold;
        private Boolean lazyMatches;

        private Builder(int n2) {
            if (n2 < 2 || !Parameters.isPowerOfTwo(n2)) {
                throw new IllegalArgumentException("windowSize must be a power of two");
            }
            this.windowSize = n2;
            this.minBackReferenceLength = 3;
            this.maxBackReferenceLength = n2 - 1;
            this.maxOffset = n2 - 1;
            this.maxLiteralLength = n2;
        }

        public Builder withMinBackReferenceLength(int n2) {
            this.minBackReferenceLength = Math.max(3, n2);
            if (this.windowSize < this.minBackReferenceLength) {
                throw new IllegalArgumentException("minBackReferenceLength can't be bigger than windowSize");
            }
            if (this.maxBackReferenceLength < this.minBackReferenceLength) {
                this.maxBackReferenceLength = this.minBackReferenceLength;
            }
            return this;
        }

        public Builder withMaxBackReferenceLength(int n2) {
            this.maxBackReferenceLength = n2 < this.minBackReferenceLength ? this.minBackReferenceLength : Math.min(n2, this.windowSize - 1);
            return this;
        }

        public Builder withMaxOffset(int n2) {
            this.maxOffset = n2 < 1 ? this.windowSize - 1 : Math.min(n2, this.windowSize - 1);
            return this;
        }

        public Builder withMaxLiteralLength(int n2) {
            this.maxLiteralLength = n2 < 1 ? this.windowSize : Math.min(n2, this.windowSize);
            return this;
        }

        public Builder withNiceBackReferenceLength(int n2) {
            this.niceBackReferenceLength = n2;
            return this;
        }

        public Builder withMaxNumberOfCandidates(int n2) {
            this.maxCandidates = n2;
            return this;
        }

        public Builder withLazyMatching(boolean bl2) {
            this.lazyMatches = bl2;
            return this;
        }

        public Builder withLazyThreshold(int n2) {
            this.lazyThreshold = n2;
            return this;
        }

        public Builder tunedForSpeed() {
            this.niceBackReferenceLength = Math.max(this.minBackReferenceLength, this.maxBackReferenceLength / 8);
            this.maxCandidates = Math.max(32, this.windowSize / 1024);
            this.lazyMatches = false;
            this.lazyThreshold = this.minBackReferenceLength;
            return this;
        }

        public Builder tunedForCompressionRatio() {
            this.niceBackReferenceLength = this.lazyThreshold = Integer.valueOf(this.maxBackReferenceLength);
            this.maxCandidates = Math.max(32, this.windowSize / 16);
            this.lazyMatches = true;
            return this;
        }

        public Parameters build() {
            boolean bl2;
            int n2 = this.niceBackReferenceLength != null ? this.niceBackReferenceLength : Math.max(this.minBackReferenceLength, this.maxBackReferenceLength / 2);
            int n3 = this.maxCandidates != null ? this.maxCandidates : Math.max(256, this.windowSize / 128);
            boolean bl3 = bl2 = this.lazyMatches == null || this.lazyMatches != false;
            int n4 = bl2 ? (this.lazyThreshold != null ? this.lazyThreshold : n2) : this.minBackReferenceLength;
            return new Parameters(this.windowSize, this.minBackReferenceLength, this.maxBackReferenceLength, this.maxOffset, this.maxLiteralLength, n2, n3, bl2, n4);
        }
    }
}

