/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.compress.compressors.lzma;

import java.io.IOException;
import java.io.InputStream;
import zz.org.apache.commons.compress.MemoryLimitException;
import zz.org.apache.commons.compress.compressors.CompressorInputStream;
import zz.org.apache.commons.compress.utils.CountingInputStream;
import zz.org.apache.commons.compress.utils.IOUtils;
import zz.org.apache.commons.compress.utils.InputStreamStatistics;
import zz.org.tukaani.xz.LZMAInputStream;

public class LZMACompressorInputStream
extends CompressorInputStream
implements InputStreamStatistics {
    private final CountingInputStream countingStream;
    private final InputStream in;

    public LZMACompressorInputStream(InputStream inputStream) throws IOException {
        this.countingStream = new CountingInputStream(inputStream);
        this.in = new LZMAInputStream(this.countingStream, -1);
    }

    public LZMACompressorInputStream(InputStream inputStream, int n2) throws IOException {
        try {
            this.countingStream = new CountingInputStream(inputStream);
            this.in = new LZMAInputStream(this.countingStream, n2);
        }
        catch (zz.org.tukaani.xz.MemoryLimitException memoryLimitException) {
            throw new MemoryLimitException(memoryLimitException.getMemoryNeeded(), memoryLimitException.getMemoryLimit(), memoryLimitException);
        }
    }

    @Override
    public int read() throws IOException {
        int n2 = this.in.read();
        this.count(n2 == -1 ? 0 : 1);
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.in.read(byArray, n2, n3);
        this.count(n4);
        return n4;
    }

    @Override
    public long skip(long l2) throws IOException {
        return IOUtils.skip(this.in, l2);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public long getCompressedCount() {
        return this.countingStream.getBytesRead();
    }

    public static boolean matches(byte[] byArray, int n2) {
        return byArray != null && n2 >= 3 && byArray[0] == 93 && byArray[1] == 0 && byArray[2] == 0;
    }
}

