/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.compress.compressors.lzw;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import zz.org.apache.commons.compress.MemoryLimitException;
import zz.org.apache.commons.compress.compressors.CompressorInputStream;
import zz.org.apache.commons.compress.utils.BitInputStream;
import zz.org.apache.commons.compress.utils.InputStreamStatistics;

public abstract class LZWInputStream
extends CompressorInputStream
implements InputStreamStatistics {
    protected static final int DEFAULT_CODE_SIZE = 9;
    protected static final int UNUSED_PREFIX = -1;
    private final byte[] oneByte = new byte[1];
    protected final BitInputStream in;
    private int clearCode = -1;
    private int codeSize = 9;
    private byte previousCodeFirstChar;
    private int previousCode = -1;
    private int tableSize;
    private int[] prefixes;
    private byte[] characters;
    private byte[] outputStack;
    private int outputStackLocation;

    protected LZWInputStream(InputStream inputStream, ByteOrder byteOrder) {
        this.in = new BitInputStream(inputStream, byteOrder);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public int read() throws IOException {
        int n2 = this.read(this.oneByte);
        if (n2 < 0) {
            return n2;
        }
        return 0xFF & this.oneByte[0];
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.readFromStack(byArray, n2, n3);
        while (n3 - n4 > 0) {
            int n5 = this.decompressNextSymbol();
            if (n5 < 0) {
                if (n4 > 0) {
                    this.count(n4);
                    return n4;
                }
                return n5;
            }
            n4 += this.readFromStack(byArray, n2 + n4, n3 - n4);
        }
        this.count(n4);
        return n4;
    }

    @Override
    public long getCompressedCount() {
        return this.in.getBytesRead();
    }

    protected abstract int decompressNextSymbol() throws IOException;

    protected abstract int addEntry(int var1, byte var2) throws IOException;

    protected void setClearCode(int n2) {
        this.clearCode = 1 << n2 - 1;
    }

    protected void initializeTables(int n2, int n3) throws MemoryLimitException {
        int n4;
        long l2;
        long l3;
        if (n3 > -1 && (l3 = (l2 = (long)(n4 = 1 << n2) * 6L) >> 10) > (long)n3) {
            throw new MemoryLimitException(l3, n3);
        }
        this.initializeTables(n2);
    }

    protected void initializeTables(int n2) {
        int n3 = 1 << n2;
        this.prefixes = new int[n3];
        this.characters = new byte[n3];
        this.outputStack = new byte[n3];
        this.outputStackLocation = n3;
        int n4 = 256;
        for (int i2 = 0; i2 < 256; ++i2) {
            this.prefixes[i2] = -1;
            this.characters[i2] = (byte)i2;
        }
    }

    protected int readNextCode() throws IOException {
        if (this.codeSize > 31) {
            throw new IllegalArgumentException("code size must not be bigger than 31");
        }
        return (int)this.in.readBits(this.codeSize);
    }

    protected int addEntry(int n2, byte by2, int n3) {
        if (this.tableSize < n3) {
            this.prefixes[this.tableSize] = n2;
            this.characters[this.tableSize] = by2;
            return this.tableSize++;
        }
        return -1;
    }

    protected int addRepeatOfPreviousCode() throws IOException {
        if (this.previousCode == -1) {
            throw new IOException("The first code can't be a reference to its preceding code");
        }
        return this.addEntry(this.previousCode, this.previousCodeFirstChar);
    }

    protected int expandCodeToOutputStack(int n2, boolean bl2) throws IOException {
        int n3 = n2;
        while (n3 >= 0) {
            this.outputStack[--this.outputStackLocation] = this.characters[n3];
            n3 = this.prefixes[n3];
        }
        if (this.previousCode != -1 && !bl2) {
            this.addEntry(this.previousCode, this.outputStack[this.outputStackLocation]);
        }
        this.previousCode = n2;
        this.previousCodeFirstChar = this.outputStack[this.outputStackLocation];
        return this.outputStackLocation;
    }

    private int readFromStack(byte[] byArray, int n2, int n3) {
        int n4 = this.outputStack.length - this.outputStackLocation;
        if (n4 > 0) {
            int n5 = Math.min(n4, n3);
            System.arraycopy(this.outputStack, this.outputStackLocation, byArray, n2, n5);
            this.outputStackLocation += n5;
            return n5;
        }
        return 0;
    }

    protected int getCodeSize() {
        return this.codeSize;
    }

    protected void resetCodeSize() {
        this.setCodeSize(9);
    }

    protected void setCodeSize(int n2) {
        this.codeSize = n2;
    }

    protected void incrementCodeSize() {
        ++this.codeSize;
    }

    protected void resetPreviousCode() {
        this.previousCode = -1;
    }

    protected int getPrefix(int n2) {
        return this.prefixes[n2];
    }

    protected void setPrefix(int n2, int n3) {
        this.prefixes[n2] = n3;
    }

    protected int getPrefixesLength() {
        return this.prefixes.length;
    }

    protected int getClearCode() {
        return this.clearCode;
    }

    protected int getTableSize() {
        return this.tableSize;
    }

    protected void setTableSize(int n2) {
        this.tableSize = n2;
    }
}

