/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.compress.compressors.snappy;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Arrays;
import zz.org.apache.commons.compress.compressors.CompressorInputStream;
import zz.org.apache.commons.compress.compressors.snappy.FramedSnappyDialect;
import zz.org.apache.commons.compress.compressors.snappy.PureJavaCrc32C;
import zz.org.apache.commons.compress.compressors.snappy.SnappyCompressorInputStream;
import zz.org.apache.commons.compress.utils.BoundedInputStream;
import zz.org.apache.commons.compress.utils.ByteUtils;
import zz.org.apache.commons.compress.utils.CountingInputStream;
import zz.org.apache.commons.compress.utils.IOUtils;
import zz.org.apache.commons.compress.utils.InputStreamStatistics;

public class FramedSnappyCompressorInputStream
extends CompressorInputStream
implements InputStreamStatistics {
    static final long MASK_OFFSET = 2726488792L;
    private static final int STREAM_IDENTIFIER_TYPE = 255;
    static final int COMPRESSED_CHUNK_TYPE = 0;
    private static final int UNCOMPRESSED_CHUNK_TYPE = 1;
    private static final int PADDING_CHUNK_TYPE = 254;
    private static final int MIN_UNSKIPPABLE_TYPE = 2;
    private static final int MAX_UNSKIPPABLE_TYPE = 127;
    private static final int MAX_SKIPPABLE_TYPE = 253;
    static final byte[] SZ_SIGNATURE = new byte[]{-1, 6, 0, 0, 115, 78, 97, 80, 112, 89};
    private long unreadBytes;
    private final CountingInputStream countingStream;
    private final PushbackInputStream in;
    private final FramedSnappyDialect dialect;
    private SnappyCompressorInputStream currentCompressedChunk;
    private final byte[] oneByte = new byte[1];
    private boolean endReached;
    private boolean inUncompressedChunk;
    private int uncompressedBytesRemaining;
    private long expectedChecksum = -1L;
    private final int blockSize;
    private final PureJavaCrc32C checksum = new PureJavaCrc32C();
    private final ByteUtils.ByteSupplier supplier = new ByteUtils.ByteSupplier(){

        @Override
        public int getAsByte() throws IOException {
            return FramedSnappyCompressorInputStream.this.readOneByte();
        }
    };

    public FramedSnappyCompressorInputStream(InputStream inputStream) throws IOException {
        this(inputStream, FramedSnappyDialect.STANDARD);
    }

    public FramedSnappyCompressorInputStream(InputStream inputStream, FramedSnappyDialect framedSnappyDialect) throws IOException {
        this(inputStream, 32768, framedSnappyDialect);
    }

    public FramedSnappyCompressorInputStream(InputStream inputStream, int n2, FramedSnappyDialect framedSnappyDialect) throws IOException {
        this.countingStream = new CountingInputStream(inputStream);
        this.in = new PushbackInputStream(this.countingStream, 1);
        this.blockSize = n2;
        this.dialect = framedSnappyDialect;
        if (framedSnappyDialect.hasStreamIdentifier()) {
            this.readStreamIdentifier();
        }
    }

    @Override
    public int read() throws IOException {
        return this.read(this.oneByte, 0, 1) == -1 ? -1 : this.oneByte[0] & 0xFF;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.currentCompressedChunk != null) {
                this.currentCompressedChunk.close();
                this.currentCompressedChunk = null;
            }
        }
        finally {
            this.in.close();
        }
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.readOnce(byArray, n2, n3);
        if (n4 == -1) {
            this.readNextBlock();
            if (this.endReached) {
                return -1;
            }
            n4 = this.readOnce(byArray, n2, n3);
        }
        return n4;
    }

    @Override
    public int available() throws IOException {
        if (this.inUncompressedChunk) {
            return Math.min(this.uncompressedBytesRemaining, this.in.available());
        }
        if (this.currentCompressedChunk != null) {
            return this.currentCompressedChunk.available();
        }
        return 0;
    }

    @Override
    public long getCompressedCount() {
        return this.countingStream.getBytesRead() - this.unreadBytes;
    }

    private int readOnce(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = -1;
        if (this.inUncompressedChunk) {
            int n5 = Math.min(this.uncompressedBytesRemaining, n3);
            if (n5 == 0) {
                return -1;
            }
            n4 = this.in.read(byArray, n2, n5);
            if (n4 != -1) {
                this.uncompressedBytesRemaining -= n4;
                this.count(n4);
            }
        } else if (this.currentCompressedChunk != null) {
            long l2 = this.currentCompressedChunk.getBytesRead();
            n4 = this.currentCompressedChunk.read(byArray, n2, n3);
            if (n4 == -1) {
                this.currentCompressedChunk.close();
                this.currentCompressedChunk = null;
            } else {
                this.count(this.currentCompressedChunk.getBytesRead() - l2);
            }
        }
        if (n4 > 0) {
            this.checksum.update(byArray, n2, n4);
        }
        return n4;
    }

    private void readNextBlock() throws IOException {
        this.verifyLastChecksumAndReset();
        this.inUncompressedChunk = false;
        int n2 = this.readOneByte();
        if (n2 == -1) {
            this.endReached = true;
        } else if (n2 == 255) {
            this.in.unread(n2);
            ++this.unreadBytes;
            this.pushedBackBytes(1L);
            this.readStreamIdentifier();
            this.readNextBlock();
        } else if (n2 == 254 || n2 > 127 && n2 <= 253) {
            this.skipBlock();
            this.readNextBlock();
        } else {
            if (n2 >= 2 && n2 <= 127) {
                throw new IOException("unskippable chunk with type " + n2 + " (hex " + Integer.toHexString(n2) + ") detected.");
            }
            if (n2 == 1) {
                this.inUncompressedChunk = true;
                this.uncompressedBytesRemaining = this.readSize() - 4;
                this.expectedChecksum = FramedSnappyCompressorInputStream.unmask(this.readCrc());
            } else if (n2 == 0) {
                boolean bl2 = this.dialect.usesChecksumWithCompressedChunks();
                long l2 = (long)this.readSize() - (bl2 ? 4L : 0L);
                this.expectedChecksum = bl2 ? FramedSnappyCompressorInputStream.unmask(this.readCrc()) : -1L;
                this.currentCompressedChunk = new SnappyCompressorInputStream(new BoundedInputStream(this.in, l2), this.blockSize);
                this.count(this.currentCompressedChunk.getBytesRead());
            } else {
                throw new IOException("unknown chunk type " + n2 + " detected.");
            }
        }
    }

    private long readCrc() throws IOException {
        byte[] byArray = new byte[4];
        int n2 = IOUtils.readFully(this.in, byArray);
        this.count(n2);
        if (n2 != 4) {
            throw new IOException("premature end of stream");
        }
        return ByteUtils.fromLittleEndian(byArray);
    }

    static long unmask(long l2) {
        l2 -= 2726488792L;
        return ((l2 &= 0xFFFFFFFFL) >> 17 | l2 << 15) & 0xFFFFFFFFL;
    }

    private int readSize() throws IOException {
        return (int)ByteUtils.fromLittleEndian(this.supplier, 3);
    }

    private void skipBlock() throws IOException {
        int n2 = this.readSize();
        long l2 = IOUtils.skip(this.in, n2);
        this.count(l2);
        if (l2 != (long)n2) {
            throw new IOException("premature end of stream");
        }
    }

    private void readStreamIdentifier() throws IOException {
        byte[] byArray = new byte[10];
        int n2 = IOUtils.readFully(this.in, byArray);
        this.count(n2);
        if (10 != n2 || !FramedSnappyCompressorInputStream.matches(byArray, 10)) {
            throw new IOException("Not a framed Snappy stream");
        }
    }

    private int readOneByte() throws IOException {
        int n2 = this.in.read();
        if (n2 != -1) {
            this.count(1);
            return n2 & 0xFF;
        }
        return -1;
    }

    private void verifyLastChecksumAndReset() throws IOException {
        if (this.expectedChecksum >= 0L && this.expectedChecksum != this.checksum.getValue()) {
            throw new IOException("Checksum verification failed");
        }
        this.expectedChecksum = -1L;
        this.checksum.reset();
    }

    public static boolean matches(byte[] byArray, int n2) {
        if (n2 < SZ_SIGNATURE.length) {
            return false;
        }
        byte[] byArray2 = byArray;
        if (byArray.length > SZ_SIGNATURE.length) {
            byArray2 = new byte[SZ_SIGNATURE.length];
            System.arraycopy(byArray, 0, byArray2, 0, SZ_SIGNATURE.length);
        }
        return Arrays.equals(byArray2, SZ_SIGNATURE);
    }
}

