/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.compress.compressors.snappy;

import java.io.IOException;
import java.io.OutputStream;
import zz.org.apache.commons.compress.compressors.CompressorOutputStream;
import zz.org.apache.commons.compress.compressors.lz77support.LZ77Compressor;
import zz.org.apache.commons.compress.compressors.lz77support.Parameters;
import zz.org.apache.commons.compress.utils.ByteUtils;

public class SnappyCompressorOutputStream
extends CompressorOutputStream {
    private final LZ77Compressor compressor;
    private final OutputStream os;
    private final ByteUtils.ByteConsumer consumer;
    private final byte[] oneByte = new byte[1];
    private boolean finished = false;
    private static final int MAX_LITERAL_SIZE_WITHOUT_SIZE_BYTES = 60;
    private static final int MAX_LITERAL_SIZE_WITH_ONE_SIZE_BYTE = 256;
    private static final int MAX_LITERAL_SIZE_WITH_TWO_SIZE_BYTES = 65536;
    private static final int MAX_LITERAL_SIZE_WITH_THREE_SIZE_BYTES = 0x1000000;
    private static final int ONE_SIZE_BYTE_MARKER = 240;
    private static final int TWO_SIZE_BYTE_MARKER = 244;
    private static final int THREE_SIZE_BYTE_MARKER = 248;
    private static final int FOUR_SIZE_BYTE_MARKER = 252;
    private static final int MIN_MATCH_LENGTH_WITH_ONE_OFFSET_BYTE = 4;
    private static final int MAX_MATCH_LENGTH_WITH_ONE_OFFSET_BYTE = 11;
    private static final int MAX_OFFSET_WITH_ONE_OFFSET_BYTE = 1024;
    private static final int MAX_OFFSET_WITH_TWO_OFFSET_BYTES = 32768;
    private static final int ONE_BYTE_COPY_TAG = 1;
    private static final int TWO_BYTE_COPY_TAG = 2;
    private static final int FOUR_BYTE_COPY_TAG = 3;
    private static final int MIN_MATCH_LENGTH = 4;
    private static final int MAX_MATCH_LENGTH = 64;

    public SnappyCompressorOutputStream(OutputStream outputStream, long l2) throws IOException {
        this(outputStream, l2, 32768);
    }

    public SnappyCompressorOutputStream(OutputStream outputStream, long l2, int n2) throws IOException {
        this(outputStream, l2, SnappyCompressorOutputStream.createParameterBuilder(n2).build());
    }

    public SnappyCompressorOutputStream(OutputStream outputStream, long l2, Parameters parameters) throws IOException {
        this.os = outputStream;
        this.consumer = new ByteUtils.OutputStreamByteConsumer(outputStream);
        this.compressor = new LZ77Compressor(parameters, new LZ77Compressor.Callback(){

            @Override
            public void accept(LZ77Compressor.Block block) throws IOException {
                switch (block.getType()) {
                    case LITERAL: {
                        SnappyCompressorOutputStream.this.writeLiteralBlock((LZ77Compressor.LiteralBlock)block);
                        break;
                    }
                    case BACK_REFERENCE: {
                        SnappyCompressorOutputStream.this.writeBackReference((LZ77Compressor.BackReference)block);
                        break;
                    }
                }
            }
        });
        this.writeUncompressedSize(l2);
    }

    @Override
    public void write(int n2) throws IOException {
        this.oneByte[0] = (byte)(n2 & 0xFF);
        this.write(this.oneByte);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.compressor.compress(byArray, n2, n3);
    }

    @Override
    public void close() throws IOException {
        try {
            this.finish();
        }
        finally {
            this.os.close();
        }
    }

    public void finish() throws IOException {
        if (!this.finished) {
            this.compressor.finish();
            this.finished = true;
        }
    }

    private void writeUncompressedSize(long l2) throws IOException {
        boolean bl2 = false;
        do {
            int n2;
            boolean bl3 = bl2 = l2 > (long)(n2 = (int)(l2 & 0x7FL));
            if (bl2) {
                n2 |= 0x80;
            }
            this.os.write(n2);
            l2 >>= 7;
        } while (bl2);
    }

    private void writeLiteralBlock(LZ77Compressor.LiteralBlock literalBlock) throws IOException {
        int n2 = literalBlock.getLength();
        if (n2 <= 60) {
            this.writeLiteralBlockNoSizeBytes(literalBlock, n2);
        } else if (n2 <= 256) {
            this.writeLiteralBlockOneSizeByte(literalBlock, n2);
        } else if (n2 <= 65536) {
            this.writeLiteralBlockTwoSizeBytes(literalBlock, n2);
        } else if (n2 <= 0x1000000) {
            this.writeLiteralBlockThreeSizeBytes(literalBlock, n2);
        } else {
            this.writeLiteralBlockFourSizeBytes(literalBlock, n2);
        }
    }

    private void writeLiteralBlockNoSizeBytes(LZ77Compressor.LiteralBlock literalBlock, int n2) throws IOException {
        this.writeLiteralBlockWithSize(n2 - 1 << 2, 0, n2, literalBlock);
    }

    private void writeLiteralBlockOneSizeByte(LZ77Compressor.LiteralBlock literalBlock, int n2) throws IOException {
        this.writeLiteralBlockWithSize(240, 1, n2, literalBlock);
    }

    private void writeLiteralBlockTwoSizeBytes(LZ77Compressor.LiteralBlock literalBlock, int n2) throws IOException {
        this.writeLiteralBlockWithSize(244, 2, n2, literalBlock);
    }

    private void writeLiteralBlockThreeSizeBytes(LZ77Compressor.LiteralBlock literalBlock, int n2) throws IOException {
        this.writeLiteralBlockWithSize(248, 3, n2, literalBlock);
    }

    private void writeLiteralBlockFourSizeBytes(LZ77Compressor.LiteralBlock literalBlock, int n2) throws IOException {
        this.writeLiteralBlockWithSize(252, 4, n2, literalBlock);
    }

    private void writeLiteralBlockWithSize(int n2, int n3, int n4, LZ77Compressor.LiteralBlock literalBlock) throws IOException {
        this.os.write(n2);
        this.writeLittleEndian(n3, n4 - 1);
        this.os.write(literalBlock.getData(), literalBlock.getOffset(), n4);
    }

    private void writeLittleEndian(int n2, int n3) throws IOException {
        ByteUtils.toLittleEndian(this.consumer, (long)n3, n2);
    }

    private void writeBackReference(LZ77Compressor.BackReference backReference) throws IOException {
        int n2 = backReference.getLength();
        int n3 = backReference.getOffset();
        if (n2 >= 4 && n2 <= 11 && n3 <= 1024) {
            this.writeBackReferenceWithOneOffsetByte(n2, n3);
        } else if (n3 < 32768) {
            this.writeBackReferenceWithTwoOffsetBytes(n2, n3);
        } else {
            this.writeBackReferenceWithFourOffsetBytes(n2, n3);
        }
    }

    private void writeBackReferenceWithOneOffsetByte(int n2, int n3) throws IOException {
        this.os.write(1 | n2 - 4 << 2 | (n3 & 0x700) >> 3);
        this.os.write(n3 & 0xFF);
    }

    private void writeBackReferenceWithTwoOffsetBytes(int n2, int n3) throws IOException {
        this.writeBackReferenceWithLittleEndianOffset(2, 2, n2, n3);
    }

    private void writeBackReferenceWithFourOffsetBytes(int n2, int n3) throws IOException {
        this.writeBackReferenceWithLittleEndianOffset(3, 4, n2, n3);
    }

    private void writeBackReferenceWithLittleEndianOffset(int n2, int n3, int n4, int n5) throws IOException {
        this.os.write(n2 | n4 - 1 << 2);
        this.writeLittleEndian(n3, n5);
    }

    public static Parameters.Builder createParameterBuilder(int n2) {
        return Parameters.builder(n2).withMinBackReferenceLength(4).withMaxBackReferenceLength(64).withMaxOffset(n2).withMaxLiteralLength(n2);
    }
}

