/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.compress.compressors.z;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import zz.org.apache.commons.compress.compressors.lzw.LZWInputStream;

public class ZCompressorInputStream
extends LZWInputStream {
    private static final int MAGIC_1 = 31;
    private static final int MAGIC_2 = 157;
    private static final int BLOCK_MODE_MASK = 128;
    private static final int MAX_CODE_SIZE_MASK = 31;
    private final boolean blockMode;
    private final int maxCodeSize;
    private long totalCodesRead = 0L;

    public ZCompressorInputStream(InputStream inputStream, int n2) throws IOException {
        super(inputStream, ByteOrder.LITTLE_ENDIAN);
        int n3 = (int)this.in.readBits(8);
        int n4 = (int)this.in.readBits(8);
        int n5 = (int)this.in.readBits(8);
        if (n3 != 31 || n4 != 157 || n5 < 0) {
            throw new IOException("Input is not in .Z format");
        }
        this.blockMode = (n5 & 0x80) != 0;
        this.maxCodeSize = n5 & 0x1F;
        if (this.blockMode) {
            this.setClearCode(9);
        }
        this.initializeTables(this.maxCodeSize, n2);
        this.clearEntries();
    }

    public ZCompressorInputStream(InputStream inputStream) throws IOException {
        this(inputStream, -1);
    }

    private void clearEntries() {
        this.setTableSize(256 + (this.blockMode ? 1 : 0));
    }

    @Override
    protected int readNextCode() throws IOException {
        int n2 = super.readNextCode();
        if (n2 >= 0) {
            ++this.totalCodesRead;
        }
        return n2;
    }

    private void reAlignReading() throws IOException {
        long l2 = 8L - this.totalCodesRead % 8L;
        if (l2 == 8L) {
            l2 = 0L;
        }
        for (long i2 = 0L; i2 < l2; ++i2) {
            this.readNextCode();
        }
        this.in.clearBitCache();
    }

    @Override
    protected int addEntry(int n2, byte by2) throws IOException {
        int n3 = 1 << this.getCodeSize();
        int n4 = this.addEntry(n2, by2, n3);
        if (this.getTableSize() == n3 && this.getCodeSize() < this.maxCodeSize) {
            this.reAlignReading();
            this.incrementCodeSize();
        }
        return n4;
    }

    @Override
    protected int decompressNextSymbol() throws IOException {
        int n2 = this.readNextCode();
        if (n2 < 0) {
            return -1;
        }
        if (this.blockMode && n2 == this.getClearCode()) {
            this.clearEntries();
            this.reAlignReading();
            this.resetCodeSize();
            this.resetPreviousCode();
            return 0;
        }
        boolean bl2 = false;
        if (n2 == this.getTableSize()) {
            this.addRepeatOfPreviousCode();
            bl2 = true;
        } else if (n2 > this.getTableSize()) {
            throw new IOException(String.format("Invalid %d bit code 0x%x", this.getCodeSize(), n2));
        }
        return this.expandCodeToOutputStack(n2, bl2);
    }

    public static boolean matches(byte[] byArray, int n2) {
        return n2 > 3 && byArray[0] == 31 && byArray[1] == -99;
    }
}

