/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.compress.compressors.zstandard;

public class ZstdUtils {
    private static final byte[] ZSTANDARD_FRAME_MAGIC = new byte[]{40, -75, 47, -3};
    private static final byte[] SKIPPABLE_FRAME_MAGIC = new byte[]{42, 77, 24};
    private static volatile CachedAvailability cachedZstdAvailability = CachedAvailability.DONT_CACHE;

    private ZstdUtils() {
    }

    public static boolean isZstdCompressionAvailable() {
        CachedAvailability cachedAvailability = cachedZstdAvailability;
        if (cachedAvailability != CachedAvailability.DONT_CACHE) {
            return cachedAvailability == CachedAvailability.CACHED_AVAILABLE;
        }
        return ZstdUtils.internalIsZstdCompressionAvailable();
    }

    private static boolean internalIsZstdCompressionAvailable() {
        try {
            Class.forName("zz.com.github.luben.zstd.ZstdInputStream");
            return true;
        }
        catch (Exception | NoClassDefFoundError throwable) {
            return false;
        }
    }

    public static void setCacheZstdAvailablity(boolean bl2) {
        if (!bl2) {
            cachedZstdAvailability = CachedAvailability.DONT_CACHE;
        } else if (cachedZstdAvailability == CachedAvailability.DONT_CACHE) {
            boolean bl3 = ZstdUtils.internalIsZstdCompressionAvailable();
            cachedZstdAvailability = bl3 ? CachedAvailability.CACHED_AVAILABLE : CachedAvailability.CACHED_UNAVAILABLE;
        }
    }

    public static boolean matches(byte[] byArray, int n2) {
        int n3;
        if (n2 < ZSTANDARD_FRAME_MAGIC.length) {
            return false;
        }
        boolean bl2 = true;
        for (n3 = 0; n3 < ZSTANDARD_FRAME_MAGIC.length; ++n3) {
            if (byArray[n3] == ZSTANDARD_FRAME_MAGIC[n3]) continue;
            bl2 = false;
            break;
        }
        if (bl2) {
            return true;
        }
        if (80 == (byArray[0] & 0xF0)) {
            for (n3 = 0; n3 < SKIPPABLE_FRAME_MAGIC.length; ++n3) {
                if (byArray[n3 + 1] == SKIPPABLE_FRAME_MAGIC[n3]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static CachedAvailability getCachedZstdAvailability() {
        return cachedZstdAvailability;
    }

    static {
        try {
            Class.forName("zz.org.osgi.framework.BundleEvent");
        }
        catch (Exception exception) {
            ZstdUtils.setCacheZstdAvailablity(true);
        }
    }

    static enum CachedAvailability {
        DONT_CACHE,
        CACHED_AVAILABLE,
        CACHED_UNAVAILABLE;

    }
}

