/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.compress.utils;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import zz.org.apache.commons.compress.archivers.ArchiveEntry;

public class ArchiveUtils {
    private static final int MAX_SANITIZED_NAME_LENGTH = 255;

    private ArchiveUtils() {
    }

    public static String toString(ArchiveEntry archiveEntry) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(archiveEntry.isDirectory() ? (char)'d' : '-');
        String string = Long.toString(archiveEntry.getSize());
        stringBuilder.append(' ');
        for (int i2 = 7; i2 > string.length(); --i2) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(string);
        stringBuilder.append(' ').append(archiveEntry.getName());
        return stringBuilder.toString();
    }

    public static boolean matchAsciiBuffer(String string, byte[] byArray, int n2, int n3) {
        byte[] byArray2;
        try {
            byArray2 = string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        return ArchiveUtils.isEqual(byArray2, 0, byArray2.length, byArray, n2, n3, false);
    }

    public static boolean matchAsciiBuffer(String string, byte[] byArray) {
        return ArchiveUtils.matchAsciiBuffer(string, byArray, 0, byArray.length);
    }

    public static byte[] toAsciiBytes(String string) {
        try {
            return string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static String toAsciiString(byte[] byArray) {
        try {
            return new String(byArray, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static String toAsciiString(byte[] byArray, int n2, int n3) {
        try {
            return new String(byArray, n2, n3, "US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static boolean isEqual(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5, boolean bl2) {
        int n6;
        int n7 = n3 < n5 ? n3 : n5;
        for (n6 = 0; n6 < n7; ++n6) {
            if (byArray[n2 + n6] == byArray2[n4 + n6]) continue;
            return false;
        }
        if (n3 == n5) {
            return true;
        }
        if (bl2) {
            if (n3 > n5) {
                for (n6 = n5; n6 < n3; ++n6) {
                    if (byArray[n2 + n6] == 0) continue;
                    return false;
                }
            } else {
                for (n6 = n3; n6 < n5; ++n6) {
                    if (byArray2[n4 + n6] == 0) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean isEqual(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        return ArchiveUtils.isEqual(byArray, n2, n3, byArray2, n4, n5, false);
    }

    public static boolean isEqual(byte[] byArray, byte[] byArray2) {
        return ArchiveUtils.isEqual(byArray, 0, byArray.length, byArray2, 0, byArray2.length, false);
    }

    public static boolean isEqual(byte[] byArray, byte[] byArray2, boolean bl2) {
        return ArchiveUtils.isEqual(byArray, 0, byArray.length, byArray2, 0, byArray2.length, bl2);
    }

    public static boolean isEqualWithNull(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        return ArchiveUtils.isEqual(byArray, n2, n3, byArray2, n4, n5, true);
    }

    public static boolean isArrayZero(byte[] byArray, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            if (byArray[i2] == 0) continue;
            return false;
        }
        return true;
    }

    public static String sanitize(String string) {
        char[] cArray;
        char[] cArray2 = string.toCharArray();
        char[] cArray3 = cArray = cArray2.length <= 255 ? cArray2 : Arrays.copyOf(cArray2, 255);
        if (cArray2.length > 255) {
            for (int i2 = 252; i2 < 255; ++i2) {
                cArray[i2] = 46;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (char c2 : cArray) {
            Character.UnicodeBlock unicodeBlock;
            if (!Character.isISOControl(c2) && (unicodeBlock = Character.UnicodeBlock.of(c2)) != null && unicodeBlock != Character.UnicodeBlock.SPECIALS) {
                stringBuilder.append(c2);
                continue;
            }
            stringBuilder.append('?');
        }
        return stringBuilder.toString();
    }
}

