/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.compress.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import zz.org.apache.commons.compress.utils.CountingInputStream;

public class BitInputStream
implements Closeable {
    private static final int MAXIMUM_CACHE_SIZE = 63;
    private static final long[] MASKS = new long[64];
    private final CountingInputStream in;
    private final ByteOrder byteOrder;
    private long bitsCached = 0L;
    private int bitsCachedSize = 0;

    public BitInputStream(InputStream inputStream, ByteOrder byteOrder) {
        this.in = new CountingInputStream(inputStream);
        this.byteOrder = byteOrder;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public void clearBitCache() {
        this.bitsCached = 0L;
        this.bitsCachedSize = 0;
    }

    public long readBits(int n2) throws IOException {
        if (n2 < 0 || n2 > 63) {
            throw new IllegalArgumentException("count must not be negative or greater than 63");
        }
        if (this.ensureCache(n2)) {
            return -1L;
        }
        if (this.bitsCachedSize < n2) {
            return this.processBitsGreater57(n2);
        }
        return this.readCachedBits(n2);
    }

    public int bitsCached() {
        return this.bitsCachedSize;
    }

    public long bitsAvailable() throws IOException {
        return (long)this.bitsCachedSize + 8L * (long)this.in.available();
    }

    public void alignWithByteBoundary() {
        int n2 = this.bitsCachedSize % 8;
        if (n2 > 0) {
            this.readCachedBits(n2);
        }
    }

    public long getBytesRead() {
        return this.in.getBytesRead();
    }

    private long processBitsGreater57(int n2) throws IOException {
        int n3 = 0;
        long l2 = 0L;
        int n4 = n2 - this.bitsCachedSize;
        n3 = 8 - n4;
        long l3 = this.in.read();
        if (l3 < 0L) {
            return l3;
        }
        if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            long l4 = l3 & MASKS[n4];
            this.bitsCached |= l4 << this.bitsCachedSize;
            l2 = l3 >>> n4 & MASKS[n3];
        } else {
            this.bitsCached <<= n4;
            long l5 = l3 >>> n3 & MASKS[n4];
            this.bitsCached |= l5;
            l2 = l3 & MASKS[n3];
        }
        long l6 = this.bitsCached & MASKS[n2];
        this.bitsCached = l2;
        this.bitsCachedSize = n3;
        return l6;
    }

    private long readCachedBits(int n2) {
        long l2;
        if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            l2 = this.bitsCached & MASKS[n2];
            this.bitsCached >>>= n2;
        } else {
            l2 = this.bitsCached >> this.bitsCachedSize - n2 & MASKS[n2];
        }
        this.bitsCachedSize -= n2;
        return l2;
    }

    private boolean ensureCache(int n2) throws IOException {
        while (this.bitsCachedSize < n2 && this.bitsCachedSize < 57) {
            long l2 = this.in.read();
            if (l2 < 0L) {
                return true;
            }
            if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                this.bitsCached |= l2 << this.bitsCachedSize;
            } else {
                this.bitsCached <<= 8;
                this.bitsCached |= l2;
            }
            this.bitsCachedSize += 8;
        }
        return false;
    }

    static {
        for (int i2 = 1; i2 <= 63; ++i2) {
            BitInputStream.MASKS[i2] = (MASKS[i2 - 1] << 1) + 1L;
        }
    }
}

