/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.compress.utils;

import java.io.IOException;
import java.io.InputStream;

public class BoundedInputStream
extends InputStream {
    private final InputStream in;
    private long bytesRemaining;

    public BoundedInputStream(InputStream inputStream, long l2) {
        this.in = inputStream;
        this.bytesRemaining = l2;
    }

    @Override
    public int read() throws IOException {
        if (this.bytesRemaining > 0L) {
            --this.bytesRemaining;
            return this.in.read();
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        int n5 = n3;
        if ((long)n5 > this.bytesRemaining) {
            n5 = (int)this.bytesRemaining;
        }
        if ((n4 = this.in.read(byArray, n2, n5)) >= 0) {
            this.bytesRemaining -= (long)n4;
        }
        return n4;
    }

    @Override
    public void close() {
    }
}

