/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.compress.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Checksum;

public class ChecksumCalculatingInputStream
extends InputStream {
    private final InputStream in;
    private final Checksum checksum;

    public ChecksumCalculatingInputStream(Checksum checksum, InputStream inputStream) {
        if (checksum == null) {
            throw new NullPointerException("Parameter checksum must not be null");
        }
        if (inputStream == null) {
            throw new NullPointerException("Parameter in must not be null");
        }
        this.checksum = checksum;
        this.in = inputStream;
    }

    @Override
    public int read() throws IOException {
        int n2 = this.in.read();
        if (n2 >= 0) {
            this.checksum.update(n2);
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.in.read(byArray, n2, n3);
        if (n4 >= 0) {
            this.checksum.update(byArray, n2, n4);
        }
        return n4;
    }

    @Override
    public long skip(long l2) throws IOException {
        if (this.read() >= 0) {
            return 1L;
        }
        return 0L;
    }

    public long getValue() {
        return this.checksum.getValue();
    }
}

