/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.compress.utils;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;

public class SeekableInMemoryByteChannel
implements SeekableByteChannel {
    private static final int NAIVE_RESIZE_LIMIT = 0x3FFFFFFF;
    private byte[] data;
    private final AtomicBoolean closed = new AtomicBoolean();
    private int position;
    private int size;

    public SeekableInMemoryByteChannel(byte[] byArray) {
        this.data = byArray;
        this.size = byArray.length;
    }

    public SeekableInMemoryByteChannel() {
        this(new byte[0]);
    }

    public SeekableInMemoryByteChannel(int n2) {
        this(new byte[n2]);
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public SeekableByteChannel position(long l2) throws IOException {
        this.ensureOpen();
        if (l2 < 0L || l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Position has to be in range 0.. 2147483647");
        }
        this.position = (int)l2;
        return this;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public SeekableByteChannel truncate(long l2) {
        if ((long)this.size > l2) {
            this.size = (int)l2;
        }
        this.repositionIfNecessary();
        return this;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        this.ensureOpen();
        this.repositionIfNecessary();
        int n2 = byteBuffer.remaining();
        int n3 = this.size - this.position;
        if (n3 <= 0) {
            return -1;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        byteBuffer.put(this.data, this.position, n2);
        this.position += n2;
        return n2;
    }

    @Override
    public void close() {
        this.closed.set(true);
    }

    @Override
    public boolean isOpen() {
        return !this.closed.get();
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        this.ensureOpen();
        int n2 = byteBuffer.remaining();
        int n3 = this.size - this.position;
        if (n2 > n3) {
            int n4 = this.position + n2;
            if (n4 < 0) {
                this.resize(Integer.MAX_VALUE);
                n2 = Integer.MAX_VALUE - this.position;
            } else {
                this.resize(n4);
            }
        }
        byteBuffer.get(this.data, this.position, n2);
        this.position += n2;
        if (this.size < this.position) {
            this.size = this.position;
        }
        return n2;
    }

    public byte[] array() {
        return this.data;
    }

    private void resize(int n2) {
        int n3 = this.data.length;
        if (n3 <= 0) {
            n3 = 1;
        }
        if (n2 < 0x3FFFFFFF) {
            while (n3 < n2) {
                n3 <<= 1;
            }
        } else {
            n3 = n2;
        }
        this.data = Arrays.copyOf(this.data, n3);
    }

    private void ensureOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    private void repositionIfNecessary() {
        if (this.position > this.size) {
            this.position = this.size;
        }
    }
}

