/*
 * Decompiled with CFR 0.152.
 */
package zz.org.apache.commons.logging.impl;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.spi.LocationAwareLogger;
import zz.org.apache.commons.logging.Log;
import zz.org.apache.commons.logging.LogConfigurationException;
import zz.org.apache.commons.logging.LogFactory;
import zz.org.apache.commons.logging.impl.SLF4JLocationAwareLog;
import zz.org.apache.commons.logging.impl.SLF4JLog;

public class SLF4JLogFactory
extends LogFactory {
    ConcurrentMap<String, Log> loggerMap;
    public static final String LOG_PROPERTY = "zz.org.apache.commons.logging.Log";
    protected Hashtable attributes = new Hashtable();

    public SLF4JLogFactory() {
        this.loggerMap = new ConcurrentHashMap<String, Log>();
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public String[] getAttributeNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration enumeration = this.attributes.keys();
        while (enumeration.hasMoreElements()) {
            arrayList.add((String)enumeration.nextElement());
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = (String)arrayList.get(i2);
        }
        return stringArray;
    }

    public Log getInstance(Class clazz) throws LogConfigurationException {
        return this.getInstance(clazz.getName());
    }

    public Log getInstance(String string) throws LogConfigurationException {
        Log log = (Log)this.loggerMap.get(string);
        if (log != null) {
            return log;
        }
        Logger logger = LoggerFactory.getLogger((String)string);
        Log log2 = logger instanceof LocationAwareLogger ? new SLF4JLocationAwareLog((LocationAwareLogger)logger) : new SLF4JLog(logger);
        Log log3 = this.loggerMap.putIfAbsent(string, log2);
        return log3 == null ? log2 : log3;
    }

    public void release() {
        System.out.println("WARN: The method " + SLF4JLogFactory.class + "#release() was invoked.");
        System.out.println("WARN: Please see http://www.slf4j.org/codes.html#release for an explanation.");
        System.out.flush();
    }

    public void removeAttribute(String string) {
        this.attributes.remove(string);
    }

    public void setAttribute(String string, Object object) {
        if (object == null) {
            this.attributes.remove(string);
        } else {
            this.attributes.put(string, object);
        }
    }
}

