/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util;

import java.io.File;
import java.util.ArrayList;
import zz.org.codehaus.plexus.util.MatchPatterns;
import zz.org.codehaus.plexus.util.Scanner;
import zz.org.codehaus.plexus.util.SelectorUtils;
import zz.org.codehaus.plexus.util.StringUtils;

public abstract class AbstractScanner
implements Scanner {
    public static final String[] DEFAULTEXCLUDES = new String[]{"**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*", "**/CVS", "**/CVS/**", "**/.cvsignore", "**/RCS", "**/RCS/**", "**/SCCS", "**/SCCS/**", "**/vssver.scc", "**/project.pj", "**/.svn", "**/.svn/**", "**/.arch-ids", "**/.arch-ids/**", "**/.bzr", "**/.bzr/**", "**/.MySCMServerInfo", "**/.DS_Store", "**/.metadata", "**/.metadata/**", "**/.hg", "**/.hgignore", "**/.hg/**", "**/.git", "**/.gitignore", "**/.gitattributes", "**/.git/**", "**/BitKeeper", "**/BitKeeper/**", "**/ChangeSet", "**/ChangeSet/**", "**/_darcs", "**/_darcs/**", "**/.darcsrepo", "**/.darcsrepo/**", "**/-darcs-backup*", "**/.darcs-temp-mail"};
    protected String[] includes;
    private MatchPatterns includesPatterns;
    protected String[] excludes;
    private MatchPatterns excludesPatterns;
    protected boolean isCaseSensitive = true;

    public void setCaseSensitive(boolean bl2) {
        this.isCaseSensitive = bl2;
    }

    protected static boolean matchPatternStart(String string, String string2) {
        return SelectorUtils.matchPatternStart(string, string2);
    }

    protected static boolean matchPatternStart(String string, String string2, boolean bl2) {
        return SelectorUtils.matchPatternStart(string, string2, bl2);
    }

    protected static boolean matchPath(String string, String string2) {
        return SelectorUtils.matchPath(string, string2);
    }

    protected static boolean matchPath(String string, String string2, boolean bl2) {
        return SelectorUtils.matchPath(string, string2, bl2);
    }

    public static boolean match(String string, String string2) {
        return SelectorUtils.match(string, string2);
    }

    protected static boolean match(String string, String string2, boolean bl2) {
        return SelectorUtils.match(string, string2, bl2);
    }

    @Override
    public void setIncludes(String[] stringArray) {
        if (stringArray == null) {
            this.includes = null;
        } else {
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
            for (String string : stringArray) {
                if (string == null) continue;
                arrayList.add(this.normalizePattern(string));
            }
            this.includes = arrayList.toArray(new String[arrayList.size()]);
        }
    }

    @Override
    public void setExcludes(String[] stringArray) {
        if (stringArray == null) {
            this.excludes = null;
        } else {
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
            for (String string : stringArray) {
                if (string == null) continue;
                arrayList.add(this.normalizePattern(string));
            }
            this.excludes = arrayList.toArray(new String[arrayList.size()]);
        }
    }

    private String normalizePattern(String string) {
        if ((string = string.trim()).startsWith("%regex[")) {
            string = File.separatorChar == '\\' ? StringUtils.replace(string, "/", "\\\\") : StringUtils.replace(string, "\\\\", "/");
        } else if ((string = string.replace(File.separatorChar == '/' ? (char)'\\' : '/', File.separatorChar)).endsWith(File.separator)) {
            string = string + "**";
        }
        return string;
    }

    protected boolean isIncluded(String string) {
        return this.includesPatterns.matches(string, this.isCaseSensitive);
    }

    protected boolean isIncluded(String string, String[] stringArray) {
        return this.includesPatterns.matches(string, stringArray, this.isCaseSensitive);
    }

    protected boolean couldHoldIncluded(String string) {
        return this.includesPatterns.matchesPatternStart(string, this.isCaseSensitive);
    }

    protected boolean isExcluded(String string) {
        return this.excludesPatterns.matches(string, this.isCaseSensitive);
    }

    protected boolean isExcluded(String string, String[] stringArray) {
        return this.excludesPatterns.matches(string, stringArray, this.isCaseSensitive);
    }

    @Override
    public void addDefaultExcludes() {
        int n2 = this.excludes == null ? 0 : this.excludes.length;
        String[] stringArray = new String[n2 + DEFAULTEXCLUDES.length];
        if (n2 > 0) {
            System.arraycopy(this.excludes, 0, stringArray, 0, n2);
        }
        for (int i2 = 0; i2 < DEFAULTEXCLUDES.length; ++i2) {
            stringArray[i2 + n2] = DEFAULTEXCLUDES[i2].replace('/', File.separatorChar);
        }
        this.excludes = stringArray;
    }

    protected void setupDefaultFilters() {
        if (this.includes == null) {
            this.includes = new String[1];
            this.includes[0] = "**";
        }
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
    }

    protected void setupMatchPatterns() {
        this.includesPatterns = MatchPatterns.from(this.includes);
        this.excludesPatterns = MatchPatterns.from(this.excludes);
    }
}

