/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import zz.org.codehaus.plexus.util.FastMap;

public final class CachedMap
implements Map {
    private final FastMap _backingFastMap;
    private final Map _backingMap;
    private final FastMap _keysMap;
    private final int _mask;
    private final Object[] _keys;
    private final Object[] _values;

    public CachedMap() {
        this(256, new FastMap());
    }

    public CachedMap(int n2) {
        this(n2, new FastMap(n2));
    }

    public CachedMap(int n2, Map map) {
        int n3;
        for (n3 = 1; n3 < n2; n3 <<= 1) {
        }
        this._keys = new Object[n3];
        this._values = new Object[n3];
        this._mask = n3 - 1;
        if (map instanceof FastMap) {
            this._backingFastMap = (FastMap)map;
            this._backingMap = this._backingFastMap;
            this._keysMap = null;
        } else {
            this._backingFastMap = null;
            this._backingMap = map;
            this._keysMap = new FastMap(map.size());
            for (Object k2 : map.keySet()) {
                this._keysMap.put(k2, k2);
            }
        }
    }

    public int getCacheSize() {
        return this._keys.length;
    }

    public Map getBackingMap() {
        return this._backingFastMap != null ? this._backingFastMap : this._backingMap;
    }

    public void flush() {
        for (int i2 = 0; i2 < this._keys.length; ++i2) {
            this._keys[i2] = null;
            this._values[i2] = null;
        }
        if (this._keysMap != null) {
            for (Object k2 : this._backingMap.keySet()) {
                this._keysMap.put(k2, k2);
            }
        }
    }

    public Object get(Object object) {
        int n2 = object.hashCode() & this._mask;
        return object.equals(this._keys[n2]) ? this._values[n2] : this.getCacheMissed(object, n2);
    }

    private Object getCacheMissed(Object object, int n2) {
        if (this._backingFastMap != null) {
            Map.Entry entry = this._backingFastMap.getEntry(object);
            if (entry != null) {
                this._keys[n2] = entry.getKey();
                Object v2 = entry.getValue();
                this._values[n2] = v2;
                return v2;
            }
            return null;
        }
        Object v3 = this._keysMap.get(object);
        if (v3 != null) {
            this._keys[n2] = v3;
            Object v4 = this._backingMap.get(object);
            this._values[n2] = v4;
            return v4;
        }
        return null;
    }

    public Object put(Object object, Object object2) {
        int n2 = object.hashCode() & this._mask;
        if (object.equals(this._keys[n2])) {
            this._values[n2] = object2;
        } else if (this._keysMap != null) {
            this._keysMap.put(object, object);
        }
        return this._backingMap.put(object, object2);
    }

    public Object remove(Object object) {
        int n2 = object.hashCode() & this._mask;
        if (object.equals(this._keys[n2])) {
            this._keys[n2] = null;
        }
        if (this._keysMap != null) {
            this._keysMap.remove(object);
        }
        return this._backingMap.remove(object);
    }

    @Override
    public boolean containsKey(Object object) {
        int n2 = object.hashCode() & this._mask;
        if (object.equals(this._keys[n2])) {
            return true;
        }
        return this._backingMap.containsKey(object);
    }

    @Override
    public int size() {
        return this._backingMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this._backingMap.isEmpty();
    }

    @Override
    public boolean containsValue(Object object) {
        return this._backingMap.containsValue(object);
    }

    public void putAll(Map map) {
        this._backingMap.putAll(map);
        this.flush();
    }

    @Override
    public void clear() {
        this._backingMap.clear();
        this.flush();
    }

    public Set keySet() {
        return Collections.unmodifiableSet(this._backingMap.keySet());
    }

    public Collection values() {
        return Collections.unmodifiableCollection(this._backingMap.values());
    }

    public Set entrySet() {
        return Collections.unmodifiableSet(this._backingMap.entrySet());
    }

    @Override
    public boolean equals(Object object) {
        return this._backingMap.equals(object);
    }

    @Override
    public int hashCode() {
        return this._backingMap.hashCode();
    }
}

