/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import zz.org.codehaus.plexus.util.AbstractScanner;
import zz.org.codehaus.plexus.util.Java7Detector;
import zz.org.codehaus.plexus.util.MatchPattern;
import zz.org.codehaus.plexus.util.NioFiles;

public class DirectoryScanner
extends AbstractScanner {
    protected File basedir;
    protected Vector<String> filesIncluded;
    protected Vector<String> filesNotIncluded;
    protected Vector<String> filesExcluded;
    protected Vector<String> dirsIncluded;
    protected Vector<String> dirsNotIncluded;
    protected Vector<String> dirsExcluded;
    protected Vector<String> filesDeselected;
    protected Vector<String> dirsDeselected;
    protected boolean haveSlowResults = false;
    private boolean followSymlinks = true;
    protected boolean everythingIncluded = true;
    private final String[] tokenizedEmpty = MatchPattern.tokenizePathToString("", File.separator);

    public void setBasedir(String string) {
        this.setBasedir(new File(string.replace('/', File.separatorChar).replace('\\', File.separatorChar)));
    }

    public void setBasedir(File file) {
        this.basedir = file;
    }

    @Override
    public File getBasedir() {
        return this.basedir;
    }

    public void setFollowSymlinks(boolean bl2) {
        this.followSymlinks = bl2;
    }

    public boolean isEverythingIncluded() {
        return this.everythingIncluded;
    }

    @Override
    public void scan() throws IllegalStateException {
        if (this.basedir == null) {
            throw new IllegalStateException("No basedir set");
        }
        if (!this.basedir.exists()) {
            throw new IllegalStateException("basedir " + this.basedir + " does not exist");
        }
        if (!this.basedir.isDirectory()) {
            throw new IllegalStateException("basedir " + this.basedir + " is not a directory");
        }
        this.setupDefaultFilters();
        this.setupMatchPatterns();
        this.filesIncluded = new Vector();
        this.filesNotIncluded = new Vector();
        this.filesExcluded = new Vector();
        this.filesDeselected = new Vector();
        this.dirsIncluded = new Vector();
        this.dirsNotIncluded = new Vector();
        this.dirsExcluded = new Vector();
        this.dirsDeselected = new Vector();
        if (this.isIncluded("", this.tokenizedEmpty)) {
            if (!this.isExcluded("", this.tokenizedEmpty)) {
                if (this.isSelected("", this.basedir)) {
                    this.dirsIncluded.addElement("");
                } else {
                    this.dirsDeselected.addElement("");
                }
            } else {
                this.dirsExcluded.addElement("");
            }
        } else {
            this.dirsNotIncluded.addElement("");
        }
        this.scandir(this.basedir, "", true);
    }

    protected void slowScan() {
        if (this.haveSlowResults) {
            return;
        }
        Object[] objectArray = new String[this.dirsExcluded.size()];
        this.dirsExcluded.copyInto(objectArray);
        Object[] objectArray2 = new String[this.dirsNotIncluded.size()];
        this.dirsNotIncluded.copyInto(objectArray2);
        for (Object object : objectArray) {
            if (this.couldHoldIncluded((String)object)) continue;
            this.scandir(new File(this.basedir, (String)object), (String)object + File.separator, false);
        }
        for (Object object : objectArray2) {
            if (this.couldHoldIncluded((String)object)) continue;
            this.scandir(new File(this.basedir, (String)object), (String)object + File.separator, false);
        }
        this.haveSlowResults = true;
    }

    protected void scandir(File file, String string, boolean bl2) {
        Object object;
        String[] stringArray;
        String string2;
        String[] stringArray2 = file.list();
        if (stringArray2 == null) {
            stringArray2 = new String[]{};
        }
        if (!this.followSymlinks) {
            ArrayList arrayList = new ArrayList();
            String[] stringArray3 = stringArray2;
            int n2 = stringArray3.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                string2 = stringArray3[i2];
                try {
                    if (this.isParentSymbolicLink(file, string2)) {
                        stringArray = string + string2;
                        object = new File(file, string2);
                        if (((File)object).isDirectory()) {
                            this.dirsExcluded.addElement((String)stringArray);
                            continue;
                        }
                        this.filesExcluded.addElement((String)stringArray);
                        continue;
                    }
                    arrayList.add(string2);
                    continue;
                }
                catch (IOException iOException) {
                    object = "IOException caught while checking for links, couldn't get canonical path!";
                    System.err.println((String)object);
                    arrayList.add(string2);
                }
            }
            stringArray2 = arrayList.toArray(new String[arrayList.size()]);
        }
        for (String string3 : stringArray2) {
            string2 = string + string3;
            stringArray = MatchPattern.tokenizePathToString(string2, File.separator);
            object = new File(file, string3);
            if (((File)object).isDirectory()) {
                if (this.isIncluded(string2, stringArray)) {
                    if (!this.isExcluded(string2, stringArray)) {
                        if (this.isSelected(string2, (File)object)) {
                            this.dirsIncluded.addElement(string2);
                            if (bl2) {
                                this.scandir((File)object, string2 + File.separator, bl2);
                            }
                        } else {
                            this.everythingIncluded = false;
                            this.dirsDeselected.addElement(string2);
                            if (bl2 && this.couldHoldIncluded(string2)) {
                                this.scandir((File)object, string2 + File.separator, bl2);
                            }
                        }
                    } else {
                        this.everythingIncluded = false;
                        this.dirsExcluded.addElement(string2);
                        if (bl2 && this.couldHoldIncluded(string2)) {
                            this.scandir((File)object, string2 + File.separator, bl2);
                        }
                    }
                } else {
                    this.everythingIncluded = false;
                    this.dirsNotIncluded.addElement(string2);
                    if (bl2 && this.couldHoldIncluded(string2)) {
                        this.scandir((File)object, string2 + File.separator, bl2);
                    }
                }
                if (bl2) continue;
                this.scandir((File)object, string2 + File.separator, bl2);
                continue;
            }
            if (!((File)object).isFile()) continue;
            if (this.isIncluded(string2, stringArray)) {
                if (!this.isExcluded(string2, stringArray)) {
                    if (this.isSelected(string2, (File)object)) {
                        this.filesIncluded.addElement(string2);
                        continue;
                    }
                    this.everythingIncluded = false;
                    this.filesDeselected.addElement(string2);
                    continue;
                }
                this.everythingIncluded = false;
                this.filesExcluded.addElement(string2);
                continue;
            }
            this.everythingIncluded = false;
            this.filesNotIncluded.addElement(string2);
        }
    }

    protected boolean isSelected(String string, File file) {
        return true;
    }

    @Override
    public String[] getIncludedFiles() {
        Object[] objectArray = new String[this.filesIncluded.size()];
        this.filesIncluded.copyInto(objectArray);
        return objectArray;
    }

    public String[] getNotIncludedFiles() {
        this.slowScan();
        Object[] objectArray = new String[this.filesNotIncluded.size()];
        this.filesNotIncluded.copyInto(objectArray);
        return objectArray;
    }

    public String[] getExcludedFiles() {
        this.slowScan();
        Object[] objectArray = new String[this.filesExcluded.size()];
        this.filesExcluded.copyInto(objectArray);
        return objectArray;
    }

    public String[] getDeselectedFiles() {
        this.slowScan();
        Object[] objectArray = new String[this.filesDeselected.size()];
        this.filesDeselected.copyInto(objectArray);
        return objectArray;
    }

    @Override
    public String[] getIncludedDirectories() {
        Object[] objectArray = new String[this.dirsIncluded.size()];
        this.dirsIncluded.copyInto(objectArray);
        return objectArray;
    }

    public String[] getNotIncludedDirectories() {
        this.slowScan();
        Object[] objectArray = new String[this.dirsNotIncluded.size()];
        this.dirsNotIncluded.copyInto(objectArray);
        return objectArray;
    }

    public String[] getExcludedDirectories() {
        this.slowScan();
        Object[] objectArray = new String[this.dirsExcluded.size()];
        this.dirsExcluded.copyInto(objectArray);
        return objectArray;
    }

    public String[] getDeselectedDirectories() {
        this.slowScan();
        Object[] objectArray = new String[this.dirsDeselected.size()];
        this.dirsDeselected.copyInto(objectArray);
        return objectArray;
    }

    public boolean isSymbolicLink(File file, String string) throws IOException {
        if (Java7Detector.isJava7()) {
            return NioFiles.isSymbolicLink(new File(file, string));
        }
        File file2 = new File(file.getCanonicalPath());
        File file3 = new File(file2, string);
        return !file3.getAbsolutePath().equals(file3.getCanonicalPath());
    }

    public boolean isParentSymbolicLink(File file, String string) throws IOException {
        if (Java7Detector.isJava7()) {
            return NioFiles.isSymbolicLink(file);
        }
        File file2 = new File(file.getCanonicalPath());
        File file3 = new File(file2, string);
        return !file3.getAbsolutePath().equals(file3.getCanonicalPath());
    }
}

