/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import zz.org.codehaus.plexus.util.DirectoryScanner;
import zz.org.codehaus.plexus.util.DirectoryWalkListener;
import zz.org.codehaus.plexus.util.SelectorUtils;

public class DirectoryWalker {
    private File baseDir;
    private int baseDirOffset;
    private Stack<DirStackEntry> dirStack;
    private List<String> excludes;
    private List<String> includes = new ArrayList<String>();
    private boolean isCaseSensitive = true;
    private List<DirectoryWalkListener> listeners;
    private boolean debugEnabled = false;

    public DirectoryWalker() {
        this.excludes = new ArrayList<String>();
        this.listeners = new ArrayList<DirectoryWalkListener>();
    }

    public void addDirectoryWalkListener(DirectoryWalkListener directoryWalkListener) {
        this.listeners.add(directoryWalkListener);
    }

    public void addExclude(String string) {
        this.excludes.add(this.fixPattern(string));
    }

    public void addInclude(String string) {
        this.includes.add(this.fixPattern(string));
    }

    public void addSCMExcludes() {
        String[] stringArray;
        for (String string : stringArray = DirectoryScanner.DEFAULTEXCLUDES) {
            this.addExclude(string);
        }
    }

    private void fireStep(File file) {
        DirStackEntry dirStackEntry = this.dirStack.peek();
        int n2 = dirStackEntry.getPercentage();
        Iterator<DirectoryWalkListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            DirectoryWalkListener directoryWalkListener;
            DirectoryWalkListener directoryWalkListener2 = directoryWalkListener = iterator.next();
            directoryWalkListener2.directoryWalkStep(n2, file);
        }
    }

    private void fireWalkFinished() {
        for (DirectoryWalkListener directoryWalkListener : this.listeners) {
            directoryWalkListener.directoryWalkFinished();
        }
    }

    private void fireWalkStarting() {
        for (DirectoryWalkListener directoryWalkListener : this.listeners) {
            directoryWalkListener.directoryWalkStarting(this.baseDir);
        }
    }

    private void fireDebugMessage(String string) {
        for (DirectoryWalkListener directoryWalkListener : this.listeners) {
            directoryWalkListener.debug(string);
        }
    }

    private String fixPattern(String string) {
        String string2 = string;
        if (File.separatorChar != '/') {
            string2 = string2.replace('/', File.separatorChar);
        }
        if (File.separatorChar != '\\') {
            string2 = string2.replace('\\', File.separatorChar);
        }
        return string2;
    }

    public void setDebugMode(boolean bl2) {
        this.debugEnabled = bl2;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    private boolean isExcluded(String string) {
        return this.isMatch(this.excludes, string);
    }

    private boolean isIncluded(String string) {
        return this.isMatch(this.includes, string);
    }

    private boolean isMatch(List<String> list, String string) {
        for (String string2 : list) {
            if (!SelectorUtils.matchPath(string2, string, this.isCaseSensitive)) continue;
            return true;
        }
        return false;
    }

    private String relativeToBaseDir(File file) {
        return file.getAbsolutePath().substring(this.baseDirOffset + 1);
    }

    public void removeDirectoryWalkListener(DirectoryWalkListener directoryWalkListener) {
        this.listeners.remove(directoryWalkListener);
    }

    public void scan() {
        if (this.baseDir == null) {
            throw new IllegalStateException("Scan Failure.  BaseDir not specified.");
        }
        if (!this.baseDir.exists()) {
            throw new IllegalStateException("Scan Failure.  BaseDir does not exist.");
        }
        if (!this.baseDir.isDirectory()) {
            throw new IllegalStateException("Scan Failure.  BaseDir is not a directory.");
        }
        if (this.includes.isEmpty()) {
            this.addInclude("**");
        }
        if (this.debugEnabled) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("DirectoryWalker Scan");
            stringBuilder.append("\n  Base Dir: ").append(this.baseDir.getAbsolutePath());
            stringBuilder.append("\n  Includes: ");
            for (String string : this.includes) {
                stringBuilder.append("\n    - \"").append(string).append("\"");
            }
            stringBuilder.append("\n  Excludes: ");
            for (String string : this.excludes) {
                stringBuilder.append("\n    - \"").append(string).append("\"");
            }
            this.fireDebugMessage(stringBuilder.toString());
        }
        this.fireWalkStarting();
        this.dirStack = new Stack();
        this.scanDir(this.baseDir);
        this.fireWalkFinished();
    }

    private void scanDir(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        DirStackEntry dirStackEntry = new DirStackEntry(file, fileArray.length);
        if (this.dirStack.isEmpty()) {
            dirStackEntry.percentageOffset = 0.0;
            dirStackEntry.percentageSize = 100.0;
        } else {
            DirStackEntry dirStackEntry2 = this.dirStack.peek();
            dirStackEntry.percentageOffset = dirStackEntry2.getNextPercentageOffset();
            dirStackEntry.percentageSize = dirStackEntry2.getNextPercentageSize();
        }
        this.dirStack.push(dirStackEntry);
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            dirStackEntry.index = i2;
            String string = this.relativeToBaseDir(fileArray[i2]);
            if (this.isExcluded(string)) {
                this.fireDebugMessage(string + " is excluded.");
                continue;
            }
            if (fileArray[i2].isDirectory()) {
                this.scanDir(fileArray[i2]);
                continue;
            }
            if (!this.isIncluded(string)) continue;
            this.fireStep(fileArray[i2]);
        }
        this.dirStack.pop();
    }

    public void setBaseDir(File file) {
        this.baseDir = file;
        this.baseDirOffset = file.getAbsolutePath().length();
    }

    public void setExcludes(List<String> list) {
        this.excludes.clear();
        if (list != null) {
            for (String string : list) {
                this.excludes.add(this.fixPattern(string));
            }
        }
    }

    public void setIncludes(List<String> list) {
        this.includes.clear();
        if (list != null) {
            for (String string : list) {
                this.includes.add(this.fixPattern(string));
            }
        }
    }

    class DirStackEntry {
        public int count;
        public File dir;
        public int index;
        public double percentageOffset;
        public double percentageSize;

        public DirStackEntry(File file, int n2) {
            this.dir = file;
            this.count = n2;
        }

        public double getNextPercentageOffset() {
            return this.percentageOffset + (double)this.index * (this.percentageSize / (double)this.count);
        }

        public double getNextPercentageSize() {
            return this.percentageSize / (double)this.count;
        }

        public int getPercentage() {
            double d2 = (double)this.index / (double)this.count;
            return (int)Math.floor(this.percentageOffset + d2 * this.percentageSize);
        }

        public String toString() {
            return "DirStackEntry[dir=" + this.dir.getAbsolutePath() + ",count=" + this.count + ",index=" + this.index + ",percentageOffset=" + this.percentageOffset + ",percentageSize=" + this.percentageSize + ",percentage()=" + this.getPercentage() + ",getNextPercentageOffset()=" + this.getNextPercentageOffset() + ",getNextPercentageSize()=" + this.getNextPercentageSize() + "]";
        }
    }
}

