/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class ExceptionUtils {
    static final String WRAPPED_MARKER = " [wrapped] ";
    protected static String[] CAUSE_METHOD_NAMES = new String[]{"getCause", "getNextException", "getTargetException", "getException", "getSourceException", "getRootCause", "getCausedByException", "getNested"};

    protected ExceptionUtils() {
    }

    public static void addCauseMethodName(String string) {
        if (string != null && string.length() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(CAUSE_METHOD_NAMES));
            arrayList.add(string);
            CAUSE_METHOD_NAMES = arrayList.toArray(new String[arrayList.size()]);
        }
    }

    public static Throwable getCause(Throwable throwable) {
        return ExceptionUtils.getCause(throwable, CAUSE_METHOD_NAMES);
    }

    public static Throwable getCause(Throwable throwable, String[] stringArray) {
        Throwable throwable2 = ExceptionUtils.getCauseUsingWellKnownTypes(throwable);
        if (throwable2 == null) {
            String string;
            String[] stringArray2 = stringArray;
            int n2 = stringArray2.length;
            for (int i2 = 0; i2 < n2 && (throwable2 = ExceptionUtils.getCauseUsingMethodName(throwable, string = stringArray2[i2])) == null; ++i2) {
            }
            if (throwable2 == null) {
                throwable2 = ExceptionUtils.getCauseUsingFieldName(throwable, "detail");
            }
        }
        return throwable2;
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable throwable2 = ExceptionUtils.getCause(throwable);
        if (throwable2 != null) {
            throwable = throwable2;
            while ((throwable = ExceptionUtils.getCause(throwable)) != null) {
                throwable2 = throwable;
            }
        }
        return throwable2;
    }

    private static Throwable getCauseUsingWellKnownTypes(Throwable throwable) {
        if (throwable instanceof SQLException) {
            return ((SQLException)throwable).getNextException();
        }
        if (throwable instanceof InvocationTargetException) {
            return ((InvocationTargetException)throwable).getTargetException();
        }
        return null;
    }

    private static Throwable getCauseUsingMethodName(Throwable throwable, String string) {
        Method method = null;
        try {
            method = throwable.getClass().getMethod(string, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (method != null && Throwable.class.isAssignableFrom(method.getReturnType())) {
            try {
                return (Throwable)method.invoke((Object)throwable, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Throwable getCauseUsingFieldName(Throwable throwable, String string) {
        Field field = null;
        try {
            field = throwable.getClass().getField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (field != null && Throwable.class.isAssignableFrom(field.getType())) {
            try {
                return (Throwable)field.get(throwable);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public static int getThrowableCount(Throwable throwable) {
        int n2 = 0;
        while (throwable != null) {
            ++n2;
            throwable = ExceptionUtils.getCause(throwable);
        }
        return n2;
    }

    public static Throwable[] getThrowables(Throwable throwable) {
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        while (throwable != null) {
            arrayList.add(throwable);
            throwable = ExceptionUtils.getCause(throwable);
        }
        return arrayList.toArray(new Throwable[arrayList.size()]);
    }

    public static int indexOfThrowable(Throwable throwable, Class clazz) {
        return ExceptionUtils.indexOfThrowable(throwable, clazz, 0);
    }

    public static int indexOfThrowable(Throwable throwable, Class clazz, int n2) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Throwable index out of range: " + n2);
        }
        Throwable[] throwableArray = ExceptionUtils.getThrowables(throwable);
        if (n2 >= throwableArray.length) {
            throw new IndexOutOfBoundsException("Throwable index out of range: " + n2);
        }
        for (int i2 = n2; i2 < throwableArray.length; ++i2) {
            if (!throwableArray[i2].getClass().equals(clazz)) continue;
            return i2;
        }
        return -1;
    }

    public static void printRootCauseStackTrace(Throwable throwable, PrintStream printStream) {
        String[] stringArray;
        for (String string : stringArray = ExceptionUtils.getRootCauseStackTrace(throwable)) {
            printStream.println(string);
        }
        printStream.flush();
    }

    public static void printRootCauseStackTrace(Throwable throwable) {
        ExceptionUtils.printRootCauseStackTrace(throwable, System.err);
    }

    public static void printRootCauseStackTrace(Throwable throwable, PrintWriter printWriter) {
        String[] stringArray;
        for (String string : stringArray = ExceptionUtils.getRootCauseStackTrace(throwable)) {
            printWriter.println(string);
        }
        printWriter.flush();
    }

    public static String[] getRootCauseStackTrace(Throwable throwable) {
        Throwable[] throwableArray = ExceptionUtils.getThrowables(throwable);
        int n2 = throwableArray.length;
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list = ExceptionUtils.getStackFrameList(throwableArray[n2 - 1]);
        int n3 = n2;
        while (--n3 >= 0) {
            List<String> list2 = list;
            if (n3 != 0) {
                list = ExceptionUtils.getStackFrameList(throwableArray[n3 - 1]);
                ExceptionUtils.removeCommonFrames(list2, list);
            }
            if (n3 == n2 - 1) {
                arrayList.add(throwableArray[n3].toString());
            } else {
                arrayList.add(WRAPPED_MARKER + throwableArray[n3].toString());
            }
            for (String string : list2) {
                arrayList.add(string);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static void removeCommonFrames(List<String> list, List<String> list2) {
        int n2 = list.size() - 1;
        for (int i2 = list2.size() - 1; n2 >= 0 && i2 >= 0; --n2, --i2) {
            String string;
            String string2 = list.get(n2);
            if (!string2.equals(string = list2.get(i2))) continue;
            list.remove(n2);
        }
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        throwable.printStackTrace(printWriter);
        return stringWriter.getBuffer().toString();
    }

    public static String getFullStackTrace(Throwable throwable) {
        Throwable[] throwableArray;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        for (Throwable throwable2 : throwableArray = ExceptionUtils.getThrowables(throwable)) {
            throwable2.printStackTrace(printWriter);
            if (ExceptionUtils.isNestedThrowable(throwable2)) break;
        }
        return stringWriter.getBuffer().toString();
    }

    public static boolean isNestedThrowable(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        if (throwable instanceof SQLException) {
            return true;
        }
        if (throwable instanceof InvocationTargetException) {
            return true;
        }
        for (String string : CAUSE_METHOD_NAMES) {
            try {
                Method noSuchMethodException = throwable.getClass().getMethod(string, null);
                if (noSuchMethodException == null) continue;
                return true;
            }
            catch (NoSuchMethodException securityException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        try {
            Field noSuchFieldException = throwable.getClass().getField("detail");
            if (noSuchFieldException != null) {
                return true;
            }
        }
        catch (NoSuchFieldException securityException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return false;
    }

    public static String[] getStackFrames(Throwable throwable) {
        return ExceptionUtils.getStackFrames(ExceptionUtils.getStackTrace(throwable));
    }

    static String[] getStackFrames(String string) {
        String string2 = System.getProperty("line.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        LinkedList<String> linkedList = new LinkedList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            linkedList.add(stringTokenizer.nextToken());
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    static List<String> getStackFrameList(Throwable throwable) {
        String string = ExceptionUtils.getStackTrace(throwable);
        String string2 = System.getProperty("line.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        LinkedList<String> linkedList = new LinkedList<String>();
        boolean bl2 = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            int n2 = string3.indexOf("at");
            if (n2 != -1 && string3.substring(0, n2).trim().length() == 0) {
                bl2 = true;
                linkedList.add(string3);
                continue;
            }
            if (!bl2) continue;
            break;
        }
        return linkedList;
    }
}

