/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import zz.org.codehaus.plexus.util.FileUtils;
import zz.org.codehaus.plexus.util.IOUtil;

public class Expand {
    private File dest;
    private File source;
    private boolean overwrite = true;

    public void execute() throws Exception {
        this.expandFile(this.source, this.dest);
    }

    protected void expandFile(File file, File file2) throws Exception {
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(file));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                this.extractFile(file, file2, zipInputStream, zipEntry.getName(), new Date(zipEntry.getTime()), zipEntry.isDirectory());
                zipEntry = zipInputStream.getNextEntry();
            }
            zipInputStream.close();
            zipInputStream = null;
        }
        catch (IOException iOException) {
            try {
                throw new Exception("Error while expanding " + file.getPath(), iOException);
            }
            catch (Throwable throwable) {
                IOUtil.close(zipInputStream);
                throw throwable;
            }
        }
        IOUtil.close(zipInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void extractFile(File file, File file2, InputStream inputStream, String string, Date date, boolean bl2) throws Exception {
        File file3 = FileUtils.resolveFile(file2, string);
        if (!file3.getAbsolutePath().startsWith(file2.getAbsolutePath())) {
            throw new IOException("Entry '" + string + "' outside the target directory.");
        }
        try {
            if (!this.overwrite && file3.exists() && file3.lastModified() >= date.getTime()) {
                return;
            }
            File file4 = file3.getParentFile();
            file4.mkdirs();
            if (bl2) {
                file3.mkdirs();
            } else {
                byte[] byArray = new byte[65536];
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(file3);
                    int n2 = inputStream.read(byArray);
                    while (n2 >= 0) {
                        fileOutputStream.write(byArray, 0, n2);
                        n2 = inputStream.read(byArray);
                    }
                    fileOutputStream.close();
                    fileOutputStream = null;
                }
                catch (Throwable throwable) {
                    IOUtil.close(fileOutputStream);
                    throw throwable;
                }
                IOUtil.close(fileOutputStream);
            }
            file3.setLastModified(date.getTime());
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new Exception("Can't extract file " + file.getPath(), fileNotFoundException);
        }
    }

    public void setDest(File file) {
        this.dest = file;
    }

    public void setSrc(File file) {
        this.source = file;
    }

    public void setOverwrite(boolean bl2) {
        this.overwrite = bl2;
    }
}

