/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FastMap<K, V>
implements Serializable,
Cloneable,
Map<K, V> {
    private transient EntryImpl[] _entries;
    private transient int _capacity;
    private transient int _mask;
    private transient EntryImpl _poolFirst;
    private transient EntryImpl _mapFirst;
    private transient EntryImpl _mapLast;
    private transient int _size;
    private transient Values _values;
    private transient EntrySet _entrySet;
    private transient KeySet _keySet;

    public FastMap() {
        this.initialize(256);
    }

    public FastMap(Map map) {
        int n2 = map instanceof FastMap ? ((FastMap)map).capacity() : map.size();
        this.initialize(n2);
        this.putAll(map);
    }

    public FastMap(int n2) {
        this.initialize(n2);
    }

    @Override
    public int size() {
        return this._size;
    }

    public int capacity() {
        return this._capacity;
    }

    @Override
    public boolean isEmpty() {
        return this._size == 0;
    }

    @Override
    public boolean containsKey(Object object) {
        EntryImpl entryImpl = this._entries[FastMap.keyHash(object) & this._mask];
        while (entryImpl != null) {
            if (object.equals(entryImpl._key)) {
                return true;
            }
            entryImpl = entryImpl._next;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        EntryImpl entryImpl = this._mapFirst;
        while (entryImpl != null) {
            if (object.equals(entryImpl._value)) {
                return true;
            }
            entryImpl = entryImpl._after;
        }
        return false;
    }

    @Override
    public V get(Object object) {
        EntryImpl entryImpl = this._entries[FastMap.keyHash(object) & this._mask];
        while (entryImpl != null) {
            if (object.equals(entryImpl._key)) {
                return (V)entryImpl._value;
            }
            entryImpl = entryImpl._next;
        }
        return null;
    }

    public Map.Entry getEntry(Object object) {
        EntryImpl entryImpl = this._entries[FastMap.keyHash(object) & this._mask];
        while (entryImpl != null) {
            if (object.equals(entryImpl._key)) {
                return entryImpl;
            }
            entryImpl = entryImpl._next;
        }
        return null;
    }

    @Override
    public Object put(Object object, Object object2) {
        EntryImpl entryImpl = this._entries[FastMap.keyHash(object) & this._mask];
        while (entryImpl != null) {
            if (object.equals(entryImpl._key)) {
                Object object3 = entryImpl._value;
                entryImpl._value = object2;
                return object3;
            }
            entryImpl = entryImpl._next;
        }
        this.addEntry(object, object2);
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.addEntry(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        EntryImpl entryImpl = this._entries[FastMap.keyHash(object) & this._mask];
        while (entryImpl != null) {
            if (object.equals(entryImpl._key)) {
                Object object2 = entryImpl._value;
                this.removeEntry(entryImpl);
                return (V)object2;
            }
            entryImpl = entryImpl._next;
        }
        return null;
    }

    @Override
    public void clear() {
        EntryImpl entryImpl = this._mapFirst;
        while (entryImpl != null) {
            entryImpl._key = null;
            entryImpl._value = null;
            entryImpl._before = null;
            entryImpl._next = null;
            if (entryImpl._previous == null) {
                this._entries[((EntryImpl)entryImpl)._index] = null;
            } else {
                entryImpl._previous = null;
            }
            entryImpl = entryImpl._after;
        }
        if (this._mapLast != null) {
            this._mapLast._after = this._poolFirst;
            this._poolFirst = this._mapFirst;
            this._mapFirst = null;
            this._mapLast = null;
            this._size = 0;
            this.sizeChanged();
        }
    }

    public void setCapacity(int n2) {
        EntryImpl entryImpl;
        int n3;
        if (n2 > this._capacity) {
            for (n3 = this._capacity; n3 < n2; ++n3) {
                entryImpl = new EntryImpl();
                entryImpl._after = this._poolFirst;
                this._poolFirst = entryImpl;
            }
        } else if (n2 < this._capacity) {
            for (n3 = n2; n3 < this._capacity && this._poolFirst != null; ++n3) {
                entryImpl = this._poolFirst;
                this._poolFirst = entryImpl._after;
                entryImpl._after = null;
            }
        }
        for (n3 = 16; n3 < n2; n3 <<= 1) {
        }
        if (this._entries.length != n3) {
            this._entries = new EntryImpl[n3];
            this._mask = n3 - 1;
            entryImpl = this._mapFirst;
            while (entryImpl != null) {
                int n4 = FastMap.keyHash(entryImpl._key) & this._mask;
                entryImpl._index = n4;
                entryImpl._previous = null;
                EntryImpl entryImpl2 = this._entries[n4];
                entryImpl._next = entryImpl2;
                if (entryImpl2 != null) {
                    entryImpl2._previous = entryImpl;
                }
                this._entries[n4] = entryImpl;
                entryImpl = entryImpl._after;
            }
        }
        this._capacity = n2;
    }

    public Object clone() {
        try {
            FastMap fastMap = (FastMap)super.clone();
            fastMap.initialize(this._capacity);
            fastMap.putAll(this);
            return fastMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            if (this.size() == map.size()) {
                EntryImpl entryImpl = this._mapFirst;
                while (entryImpl != null) {
                    if (!map.entrySet().contains(entryImpl)) {
                        return false;
                    }
                    entryImpl = entryImpl._after;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        EntryImpl entryImpl = this._mapFirst;
        while (entryImpl != null) {
            n2 += entryImpl.hashCode();
            entryImpl = entryImpl._after;
        }
        return n2;
    }

    public String toString() {
        return this.entrySet().toString();
    }

    @Override
    public Collection values() {
        return this._values;
    }

    @Override
    public Set entrySet() {
        return this._entrySet;
    }

    @Override
    public Set keySet() {
        return this._keySet;
    }

    protected void sizeChanged() {
        if (this.size() > this.capacity()) {
            this.setCapacity(this.capacity() * 2);
        }
    }

    private static int keyHash(Object object) {
        int n2 = object.hashCode();
        n2 += ~(n2 << 9);
        n2 ^= n2 >>> 14;
        n2 += n2 << 4;
        n2 ^= n2 >>> 10;
        return n2;
    }

    private void addEntry(Object object, Object object2) {
        EntryImpl entryImpl = this._poolFirst;
        if (entryImpl != null) {
            this._poolFirst = entryImpl._after;
            entryImpl._after = null;
        } else {
            entryImpl = new EntryImpl();
        }
        entryImpl._key = object;
        entryImpl._value = object2;
        int n2 = FastMap.keyHash(object) & this._mask;
        entryImpl._index = n2;
        EntryImpl entryImpl2 = this._entries[n2];
        entryImpl._next = entryImpl2;
        if (entryImpl2 != null) {
            entryImpl2._previous = entryImpl;
        }
        this._entries[n2] = entryImpl;
        if (this._mapLast != null) {
            entryImpl._before = this._mapLast;
            this._mapLast._after = entryImpl;
        } else {
            this._mapFirst = entryImpl;
        }
        this._mapLast = entryImpl;
        ++this._size;
        this.sizeChanged();
    }

    private void removeEntry(EntryImpl entryImpl) {
        EntryImpl entryImpl2 = entryImpl._previous;
        EntryImpl entryImpl3 = entryImpl._next;
        if (entryImpl2 != null) {
            entryImpl2._next = entryImpl3;
            entryImpl._previous = null;
        } else {
            this._entries[((EntryImpl)entryImpl)._index] = entryImpl3;
        }
        if (entryImpl3 != null) {
            entryImpl3._previous = entryImpl2;
            entryImpl._next = null;
        }
        EntryImpl entryImpl4 = entryImpl._before;
        EntryImpl entryImpl5 = entryImpl._after;
        if (entryImpl4 != null) {
            entryImpl4._after = entryImpl5;
            entryImpl._before = null;
        } else {
            this._mapFirst = entryImpl5;
        }
        if (entryImpl5 != null) {
            entryImpl5._before = entryImpl4;
        } else {
            this._mapLast = entryImpl4;
        }
        entryImpl._key = null;
        entryImpl._value = null;
        entryImpl._after = this._poolFirst;
        this._poolFirst = entryImpl;
        --this._size;
        this.sizeChanged();
    }

    private void initialize(int n2) {
        int n3;
        for (n3 = 16; n3 < n2; n3 <<= 1) {
        }
        this._entries = new EntryImpl[n3];
        this._mask = n3 - 1;
        this._capacity = n2;
        this._size = 0;
        this._values = new Values();
        this._entrySet = new EntrySet();
        this._keySet = new KeySet();
        this._poolFirst = null;
        this._mapFirst = null;
        this._mapLast = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            EntryImpl entryImpl = new EntryImpl();
            entryImpl._after = this._poolFirst;
            this._poolFirst = entryImpl;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n2 = objectInputStream.readInt();
        this.initialize(n2);
        int n3 = objectInputStream.readInt();
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.addEntry(object, object2);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this._capacity);
        objectOutputStream.writeInt(this._size);
        int n2 = 0;
        EntryImpl entryImpl = this._mapFirst;
        while (entryImpl != null) {
            objectOutputStream.writeObject(entryImpl._key);
            objectOutputStream.writeObject(entryImpl._value);
            ++n2;
            entryImpl = entryImpl._after;
        }
        if (n2 != this._size) {
            throw new IOException("FastMap Corrupted");
        }
    }

    private static final class EntryImpl<K, V>
    implements Map.Entry<K, V> {
        private K _key;
        private V _value;
        private int _index;
        private EntryImpl _previous;
        private EntryImpl _next;
        private EntryImpl _before;
        private EntryImpl _after;

        private EntryImpl() {
        }

        @Override
        public K getKey() {
            return this._key;
        }

        @Override
        public V getValue() {
            return this._value;
        }

        @Override
        public V setValue(V v2) {
            V v3 = this._value;
            this._value = v2;
            return v3;
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return this._key.equals(entry.getKey()) && (this._value != null ? this._value.equals(entry.getValue()) : entry.getValue() == null);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this._key.hashCode() ^ (this._value != null ? this._value.hashCode() : 0);
        }

        public String toString() {
            return this._key + "=" + this._value;
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                EntryImpl after;
                EntryImpl before;
                {
                    this.after = FastMap.this._mapFirst;
                }

                @Override
                public void remove() {
                    FastMap.this.removeEntry(this.before);
                }

                @Override
                public boolean hasNext() {
                    return this.after != null;
                }

                public Object next() {
                    this.before = this.after;
                    this.after = this.after._after;
                    return this.before._key;
                }
            };
        }

        @Override
        public int size() {
            return FastMap.this._size;
        }

        @Override
        public boolean contains(Object object) {
            return FastMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            return FastMap.this.remove(object) != null;
        }

        @Override
        public void clear() {
            FastMap.this.clear();
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                EntryImpl after;
                EntryImpl before;
                {
                    this.after = FastMap.this._mapFirst;
                }

                @Override
                public void remove() {
                    FastMap.this.removeEntry(this.before);
                }

                @Override
                public boolean hasNext() {
                    return this.after != null;
                }

                public Object next() {
                    this.before = this.after;
                    this.after = this.after._after;
                    return this.before;
                }
            };
        }

        @Override
        public int size() {
            return FastMap.this._size;
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                Map.Entry entry2 = FastMap.this.getEntry(entry.getKey());
                return entry.equals(entry2);
            }
            return false;
        }

        @Override
        public boolean remove(Object object) {
            Map.Entry entry;
            EntryImpl entryImpl;
            if (object instanceof Map.Entry && (entryImpl = (EntryImpl)FastMap.this.getEntry((entry = (Map.Entry)object).getKey())) != null && entry.getValue().equals(entryImpl._value)) {
                FastMap.this.removeEntry(entryImpl);
                return true;
            }
            return false;
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                EntryImpl after;
                EntryImpl before;
                {
                    this.after = FastMap.this._mapFirst;
                }

                @Override
                public void remove() {
                    FastMap.this.removeEntry(this.before);
                }

                @Override
                public boolean hasNext() {
                    return this.after != null;
                }

                public Object next() {
                    this.before = this.after;
                    this.after = this.after._after;
                    return this.before._value;
                }
            };
        }

        @Override
        public int size() {
            return FastMap.this._size;
        }

        @Override
        public boolean contains(Object object) {
            return FastMap.this.containsValue(object);
        }

        @Override
        public void clear() {
            FastMap.this.clear();
        }
    }
}

