/*
 * Decompiled with CFR 0.152.
 */
package zz.org.codehaus.plexus.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import zz.org.codehaus.plexus.util.DirectoryScanner;
import zz.org.codehaus.plexus.util.IOUtil;
import zz.org.codehaus.plexus.util.Java7Detector;
import zz.org.codehaus.plexus.util.NioFiles;
import zz.org.codehaus.plexus.util.Os;
import zz.org.codehaus.plexus.util.StringUtils;
import zz.org.codehaus.plexus.util.io.InputStreamFacade;
import zz.org.codehaus.plexus.util.io.URLInputStreamFacade;

public class FileUtils {
    public static final int ONE_KB = 1024;
    public static final int ONE_MB = 0x100000;
    public static final int ONE_GB = 0x40000000;
    private static final long FILE_COPY_BUFFER_SIZE = 0x1E00000L;
    public static String FS = System.getProperty("file.separator");
    private static final String[] INVALID_CHARACTERS_FOR_WINDOWS_FILE_NAME = new String[]{":", "*", "?", "\"", "<", ">", "|"};

    public static String[] getDefaultExcludes() {
        return DirectoryScanner.DEFAULTEXCLUDES;
    }

    public static List<String> getDefaultExcludesAsList() {
        return Arrays.asList(FileUtils.getDefaultExcludes());
    }

    public static String getDefaultExcludesAsString() {
        return StringUtils.join(DirectoryScanner.DEFAULTEXCLUDES, ",");
    }

    public static String byteCountToDisplaySize(int n2) {
        String string = n2 / 0x40000000 > 0 ? String.valueOf(n2 / 0x40000000) + " GB" : (n2 / 0x100000 > 0 ? String.valueOf(n2 / 0x100000) + " MB" : (n2 / 1024 > 0 ? String.valueOf(n2 / 1024) + " KB" : String.valueOf(n2) + " bytes"));
        return string;
    }

    public static String dirname(String string) {
        int n2 = string.lastIndexOf(File.separator);
        return n2 >= 0 ? string.substring(0, n2) : "";
    }

    public static String filename(String string) {
        int n2 = string.lastIndexOf(File.separator);
        return n2 >= 0 ? string.substring(n2 + 1) : string;
    }

    public static String basename(String string) {
        return FileUtils.basename(string, FileUtils.extension(string));
    }

    public static String basename(String string, String string2) {
        int n2;
        int n3 = string.lastIndexOf(File.separator) + 1;
        int n4 = n2 = string2 != null && string2.length() > 0 ? string.lastIndexOf(string2) : -1;
        if (n2 >= 0) {
            return string.substring(n3, n2);
        }
        if (n3 > 0) {
            return string.substring(n3);
        }
        return string;
    }

    public static String extension(String string) {
        int n2;
        int n3 = string.lastIndexOf(File.separatorChar);
        if (n3 < 0) {
            n2 = string.lastIndexOf(46);
        } else {
            n2 = string.substring(n3 + 1).lastIndexOf(46);
            if (n2 >= 0) {
                n2 += n3 + 1;
            }
        }
        if (n2 >= 0 && n2 > n3) {
            return string.substring(n2 + 1);
        }
        return "";
    }

    public static boolean fileExists(String string) {
        File file = new File(string);
        return file.exists();
    }

    public static String fileRead(String string) throws IOException {
        return FileUtils.fileRead(string, null);
    }

    public static String fileRead(String string, String string2) throws IOException {
        return FileUtils.fileRead(new File(string), string2);
    }

    public static String fileRead(File file) throws IOException {
        return FileUtils.fileRead(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fileRead(File file, String string) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        InputStreamReader inputStreamReader = null;
        try {
            int n2;
            inputStreamReader = string != null ? new InputStreamReader((InputStream)new FileInputStream(file), string) : new InputStreamReader(new FileInputStream(file));
            char[] cArray = new char[512];
            while ((n2 = inputStreamReader.read(cArray)) >= 0) {
                stringBuilder.append(cArray, 0, n2);
            }
            ((Reader)inputStreamReader).close();
            inputStreamReader = null;
        }
        catch (Throwable throwable) {
            IOUtil.close(inputStreamReader);
            throw throwable;
        }
        IOUtil.close(inputStreamReader);
        return stringBuilder.toString();
    }

    public static void fileAppend(String string, String string2) throws IOException {
        FileUtils.fileAppend(string, null, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fileAppend(String string, String string2, String string3) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string, true);
            if (string2 != null) {
                fileOutputStream.write(string3.getBytes(string2));
            } else {
                fileOutputStream.write(string3.getBytes());
            }
            fileOutputStream.close();
            fileOutputStream = null;
        }
        catch (Throwable throwable) {
            IOUtil.close(fileOutputStream);
            throw throwable;
        }
        IOUtil.close(fileOutputStream);
    }

    public static void fileWrite(String string, String string2) throws IOException {
        FileUtils.fileWrite(string, null, string2);
    }

    public static void fileWrite(String string, String string2, String string3) throws IOException {
        File file = string == null ? null : new File(string);
        FileUtils.fileWrite(file, string2, string3);
    }

    public static void fileWrite(File file, String string) throws IOException {
        FileUtils.fileWrite(file, null, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fileWrite(File file, String string, String string2) throws IOException {
        OutputStreamWriter outputStreamWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            outputStreamWriter = string != null ? new OutputStreamWriter((OutputStream)fileOutputStream, string) : new OutputStreamWriter(fileOutputStream);
            outputStreamWriter.write(string2);
            ((Writer)outputStreamWriter).close();
            outputStreamWriter = null;
        }
        catch (Throwable throwable) {
            IOUtil.close(outputStreamWriter);
            throw throwable;
        }
        IOUtil.close(outputStreamWriter);
    }

    public static void fileDelete(String string) {
        File file = new File(string);
        if (Java7Detector.isJava7()) {
            try {
                NioFiles.deleteIfExists(file);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        } else {
            file.delete();
        }
    }

    public static boolean waitFor(String string, int n2) {
        return FileUtils.waitFor(new File(string), n2);
    }

    public static boolean waitFor(File file, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (!file.exists()) {
            if (n4++ >= 10) {
                n4 = 0;
                if (n3++ > n2) {
                    return false;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return true;
    }

    public static File getFile(String string) {
        return new File(string);
    }

    public static String[] getFilesFromExtension(String string, String[] stringArray) {
        List<String> list = new ArrayList<String>();
        File file = new File(string);
        String[] stringArray2 = file.list();
        if (stringArray2 == null) {
            return new String[0];
        }
        for (String string2 : stringArray2) {
            String[] stringArray3;
            String string3 = string + System.getProperty("file.separator") + string2;
            File file2 = new File(string3);
            if (file2.isDirectory()) {
                if (file2.getName().equals("CVS")) continue;
                stringArray3 = FileUtils.getFilesFromExtension(string3, stringArray);
                list = FileUtils.blendFilesToVector(list, stringArray3);
                continue;
            }
            stringArray3 = file2.getAbsolutePath();
            if (!FileUtils.isValidFile((String)stringArray3, stringArray)) continue;
            list.add((String)stringArray3);
        }
        String[] stringArray4 = new String[list.size()];
        list.toArray(stringArray4);
        return stringArray4;
    }

    private static List<String> blendFilesToVector(List<String> list, String[] stringArray) {
        for (String string : stringArray) {
            list.add(string);
        }
        return list;
    }

    private static boolean isValidFile(String string, String[] stringArray) {
        String string2 = FileUtils.extension(string);
        if (string2 == null) {
            string2 = "";
        }
        for (String string3 : stringArray) {
            if (!string3.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static void mkdir(String string) {
        File file = new File(string);
        if (Os.isFamily("windows") && !FileUtils.isValidWindowsFileName(file)) {
            throw new IllegalArgumentException("The file (" + string + ") cannot contain any of the following characters: \n" + StringUtils.join(INVALID_CHARACTERS_FOR_WINDOWS_FILE_NAME, " "));
        }
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contentEquals(File file, File file2) throws IOException {
        boolean bl2 = file.exists();
        if (bl2 != file2.exists()) {
            return false;
        }
        if (!bl2) {
            return true;
        }
        if (file.isDirectory() || file2.isDirectory()) {
            return false;
        }
        FileInputStream fileInputStream = null;
        FileInputStream fileInputStream2 = null;
        boolean bl3 = false;
        try {
            fileInputStream = new FileInputStream(file);
            fileInputStream2 = new FileInputStream(file2);
            bl3 = IOUtil.contentEquals(fileInputStream, fileInputStream2);
            ((InputStream)fileInputStream).close();
            fileInputStream = null;
            ((InputStream)fileInputStream2).close();
            fileInputStream2 = null;
        }
        catch (Throwable throwable) {
            IOUtil.close(fileInputStream);
            IOUtil.close(fileInputStream2);
            throw throwable;
        }
        IOUtil.close(fileInputStream);
        IOUtil.close(fileInputStream2);
        return bl3;
    }

    public static File toFile(URL uRL) {
        if (uRL == null || !uRL.getProtocol().equalsIgnoreCase("file")) {
            return null;
        }
        String string = uRL.getFile().replace('/', File.separatorChar);
        int n2 = -1;
        while ((n2 = string.indexOf(37, n2 + 1)) >= 0) {
            if (n2 + 2 >= string.length()) continue;
            String string2 = string.substring(n2 + 1, n2 + 3);
            char c2 = (char)Integer.parseInt(string2, 16);
            string = string.substring(0, n2) + c2 + string.substring(n2 + 3);
        }
        return new File(string);
    }

    public static URL[] toURLs(File[] fileArray) throws IOException {
        URL[] uRLArray = new URL[fileArray.length];
        for (int i2 = 0; i2 < uRLArray.length; ++i2) {
            uRLArray[i2] = fileArray[i2].toURI().toURL();
        }
        return uRLArray;
    }

    public static String removeExtension(String string) {
        String string2 = FileUtils.extension(string);
        if ("".equals(string2)) {
            return string;
        }
        int n2 = string.lastIndexOf(string2) - 1;
        return string.substring(0, n2);
    }

    public static String getExtension(String string) {
        return FileUtils.extension(string);
    }

    public static String removePath(String string) {
        return FileUtils.removePath(string, File.separatorChar);
    }

    public static String removePath(String string, char c2) {
        int n2 = string.lastIndexOf(c2);
        if (-1 == n2) {
            return string;
        }
        return string.substring(n2 + 1);
    }

    public static String getPath(String string) {
        return FileUtils.getPath(string, File.separatorChar);
    }

    public static String getPath(String string, char c2) {
        int n2 = string.lastIndexOf(c2);
        if (-1 == n2) {
            return "";
        }
        return string.substring(0, n2);
    }

    public static void copyFileToDirectory(String string, String string2) throws IOException {
        FileUtils.copyFileToDirectory(new File(string), new File(string2));
    }

    public static void copyFileToDirectoryIfModified(String string, String string2) throws IOException {
        FileUtils.copyFileToDirectoryIfModified(new File(string), new File(string2));
    }

    public static void copyFileToDirectory(File file, File file2) throws IOException {
        if (file2.exists() && !file2.isDirectory()) {
            throw new IllegalArgumentException("Destination is not a directory");
        }
        FileUtils.copyFile(file, new File(file2, file.getName()));
    }

    public static void copyFileToDirectoryIfModified(File file, File file2) throws IOException {
        if (file2.exists() && !file2.isDirectory()) {
            throw new IllegalArgumentException("Destination is not a directory");
        }
        FileUtils.copyFileIfModified(file, new File(file2, file.getName()));
    }

    public static void mkDirs(File file, String[] stringArray, File file2) throws IOException {
        for (String string : stringArray) {
            File file3 = new File(file, string);
            File file4 = new File(file2, string);
            if (Java7Detector.isJava7() && NioFiles.isSymbolicLink(file3)) {
                File file5 = NioFiles.readSymbolicLink(file3);
                NioFiles.createSymbolicLink(file4, file5);
                continue;
            }
            file4.mkdirs();
        }
    }

    public static void copyFile(File file, File file2) throws IOException {
        if (!file.exists()) {
            String string = "File " + file + " does not exist";
            throw new IOException(string);
        }
        if (file.getCanonicalPath().equals(file2.getCanonicalPath())) {
            return;
        }
        FileUtils.mkdirsFor(file2);
        FileUtils.doCopyFile(file, file2);
        if (file.length() != file2.length()) {
            String string = "Failed to copy full contents from " + file + " to " + file2;
            throw new IOException(string);
        }
    }

    private static void doCopyFile(File file, File file2) throws IOException {
        if (Java7Detector.isJava7()) {
            FileUtils.doCopyFileUsingNewIO(file, file2);
        } else {
            FileUtils.doCopyFileUsingLegacyIO(file, file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCopyFileUsingLegacyIO(File file, File file2) throws IOException {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        FileChannel fileChannel = null;
        FileChannel fileChannel2 = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
            fileChannel = fileInputStream.getChannel();
            fileChannel2 = fileOutputStream.getChannel();
            long l2 = fileChannel.size();
            long l3 = 0L;
            for (long i2 = 0L; i2 < l2; i2 += fileChannel2.transferFrom(fileChannel, i2, l3)) {
                l3 = l2 - i2 > 0x1E00000L ? 0x1E00000L : l2 - i2;
            }
            fileChannel2.close();
            fileChannel2 = null;
            fileOutputStream.close();
            fileOutputStream = null;
            fileChannel.close();
            fileChannel = null;
            fileInputStream.close();
            fileInputStream = null;
        }
        catch (Throwable throwable) {
            IOUtil.close(fileChannel2);
            IOUtil.close(fileOutputStream);
            IOUtil.close(fileChannel);
            IOUtil.close(fileInputStream);
            throw throwable;
        }
        IOUtil.close(fileChannel2);
        IOUtil.close(fileOutputStream);
        IOUtil.close(fileChannel);
        IOUtil.close(fileInputStream);
    }

    private static void doCopyFileUsingNewIO(File file, File file2) throws IOException {
        NioFiles.copy(file, file2);
    }

    public static boolean copyFileIfModified(File file, File file2) throws IOException {
        if (file2.lastModified() < file.lastModified()) {
            FileUtils.copyFile(file, file2);
            return true;
        }
        return false;
    }

    public static void copyURLToFile(URL uRL, File file) throws IOException {
        FileUtils.copyStreamToFile(new URLInputStreamFacade(uRL), file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStreamToFile(InputStreamFacade inputStreamFacade, File file) throws IOException {
        FileUtils.mkdirsFor(file);
        FileUtils.checkCanWrite(file);
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            inputStream = inputStreamFacade.getInputStream();
            fileOutputStream = new FileOutputStream(file);
            IOUtil.copy(inputStream, (OutputStream)fileOutputStream);
            fileOutputStream.close();
            fileOutputStream = null;
            inputStream.close();
            inputStream = null;
        }
        catch (Throwable throwable) {
            IOUtil.close(inputStream);
            IOUtil.close(fileOutputStream);
            throw throwable;
        }
        IOUtil.close(inputStream);
        IOUtil.close(fileOutputStream);
    }

    private static void checkCanWrite(File file) throws IOException {
        if (file.exists() && !file.canWrite()) {
            String string = "Unable to open file " + file + " for writing.";
            throw new IOException(string);
        }
    }

    private static void mkdirsFor(File file) {
        File file2 = file.getParentFile();
        if (file2 != null && !file2.exists()) {
            file2.mkdirs();
        }
    }

    public static String normalize(String string) {
        int n2;
        String string2 = string;
        while ((n2 = string2.indexOf("//")) >= 0) {
            string2 = string2.substring(0, n2) + string2.substring(n2 + 1);
        }
        while ((n2 = string2.indexOf("/./")) >= 0) {
            string2 = string2.substring(0, n2) + string2.substring(n2 + 2);
        }
        while ((n2 = string2.indexOf("/../")) >= 0) {
            if (n2 == 0) {
                return null;
            }
            int n3 = string2.lastIndexOf(47, n2 - 1);
            string2 = string2.substring(0, n3) + string2.substring(n2 + 3);
        }
        return string2;
    }

    public static String catPath(String string, String string2) {
        int n2 = string.lastIndexOf("/");
        String string3 = string.substring(0, n2);
        String string4 = string2;
        while (string4.startsWith("../")) {
            if (string3.length() <= 0) {
                return null;
            }
            n2 = string3.lastIndexOf("/");
            string3 = string3.substring(0, n2);
            n2 = string4.indexOf("../") + 3;
            string4 = string4.substring(n2);
        }
        return new StringBuffer(string3).append("/").append(string4).toString();
    }

    public static File resolveFile(File file, String string) {
        String string2 = string;
        if ('/' != File.separatorChar) {
            string2 = string.replace('/', File.separatorChar);
        }
        if ('\\' != File.separatorChar) {
            string2 = string.replace('\\', File.separatorChar);
        }
        if (string2.startsWith(File.separator) || Os.isFamily("windows") && string2.indexOf(":") > 0) {
            File file2 = new File(string2);
            try {
                file2 = file2.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return file2;
        }
        char[] cArray = string.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        if ('\\' == File.separatorChar) {
            stringBuilder.append(string2.charAt(0));
            ++n2;
        }
        for (int i2 = n2; i2 < cArray.length; ++i2) {
            boolean bl2;
            boolean bl3 = bl2 = File.separatorChar == cArray[i2] && File.separatorChar == cArray[i2 - 1];
            if (bl2) continue;
            stringBuilder.append(cArray[i2]);
        }
        string2 = stringBuilder.toString();
        File file3 = new File(file, string2).getAbsoluteFile();
        try {
            file3 = file3.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file3;
    }

    public static void forceDelete(String string) throws IOException {
        FileUtils.forceDelete(new File(string));
    }

    public static void forceDelete(File file) throws IOException {
        if (file.isDirectory()) {
            FileUtils.deleteDirectory(file);
        } else {
            boolean bl2 = file.getCanonicalFile().exists();
            if (!FileUtils.deleteFile(file) && bl2) {
                String string = "File " + file + " unable to be deleted.";
                throw new IOException(string);
            }
        }
    }

    private static boolean deleteFile(File file) throws IOException {
        if (file.isDirectory()) {
            throw new IOException("File " + file + " isn't a file.");
        }
        if (!file.delete()) {
            if (Os.isFamily("windows")) {
                file = file.getCanonicalFile();
                System.gc();
            }
            try {
                Thread.sleep(10L);
                return file.delete();
            }
            catch (InterruptedException interruptedException) {
                return file.delete();
            }
        }
        return true;
    }

    public static void forceDeleteOnExit(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            FileUtils.deleteDirectoryOnExit(file);
        } else {
            file.deleteOnExit();
        }
    }

    private static void deleteDirectoryOnExit(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        file.deleteOnExit();
        FileUtils.cleanDirectoryOnExit(file);
    }

    private static void cleanDirectoryOnExit(File file) throws IOException {
        File[] fileArray;
        if (!file.exists()) {
            String string = file + " does not exist";
            throw new IllegalArgumentException(string);
        }
        if (!file.isDirectory()) {
            String string = file + " is not a directory";
            throw new IllegalArgumentException(string);
        }
        IOException iOException = null;
        for (File file2 : fileArray = file.listFiles()) {
            try {
                FileUtils.forceDeleteOnExit(file2);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        if (null != iOException) {
            throw iOException;
        }
    }

    public static void forceMkdir(File file) throws IOException {
        if (Os.isFamily("windows") && !FileUtils.isValidWindowsFileName(file)) {
            throw new IllegalArgumentException("The file (" + file.getAbsolutePath() + ") cannot contain any of the following characters: \n" + StringUtils.join(INVALID_CHARACTERS_FOR_WINDOWS_FILE_NAME, " "));
        }
        if (file.exists()) {
            if (file.isFile()) {
                String string = "File " + file + " exists and is " + "not a directory. Unable to create directory.";
                throw new IOException(string);
            }
        } else if (!file.mkdirs()) {
            String string = "Unable to create directory " + file;
            throw new IOException(string);
        }
    }

    public static void deleteDirectory(String string) throws IOException {
        FileUtils.deleteDirectory(new File(string));
    }

    public static void deleteDirectory(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.delete()) {
            return;
        }
        FileUtils.cleanDirectory(file);
        if (!file.delete()) {
            String string = "Directory " + file + " unable to be deleted.";
            throw new IOException(string);
        }
    }

    public static void cleanDirectory(String string) throws IOException {
        FileUtils.cleanDirectory(new File(string));
    }

    public static void cleanDirectory(File file) throws IOException {
        if (!file.exists()) {
            String string = file + " does not exist";
            throw new IllegalArgumentException(string);
        }
        if (!file.isDirectory()) {
            String string = file + " is not a directory";
            throw new IllegalArgumentException(string);
        }
        IOException iOException = null;
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            try {
                FileUtils.forceDelete(file2);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        if (null != iOException) {
            throw iOException;
        }
    }

    public static long sizeOfDirectory(String string) {
        return FileUtils.sizeOfDirectory(new File(string));
    }

    public static long sizeOfDirectory(File file) {
        File[] fileArray;
        if (!file.exists()) {
            String string = file + " does not exist";
            throw new IllegalArgumentException(string);
        }
        if (!file.isDirectory()) {
            String string = file + " is not a directory";
            throw new IllegalArgumentException(string);
        }
        long l2 = 0L;
        for (File file2 : fileArray = file.listFiles()) {
            if (file2.isDirectory()) {
                l2 += FileUtils.sizeOfDirectory(file2);
                continue;
            }
            l2 += file2.length();
        }
        return l2;
    }

    public static List<File> getFiles(File file, String string, String string2) throws IOException {
        return FileUtils.getFiles(file, string, string2, true);
    }

    public static List<File> getFiles(File file, String string, String string2, boolean bl2) throws IOException {
        List<String> list = FileUtils.getFileNames(file, string, string2, bl2);
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string3 : list) {
            arrayList.add(new File(string3));
        }
        return arrayList;
    }

    public static List<String> getFileNames(File file, String string, String string2, boolean bl2) throws IOException {
        return FileUtils.getFileNames(file, string, string2, bl2, true);
    }

    public static List<String> getFileNames(File file, String string, String string2, boolean bl2, boolean bl3) throws IOException {
        return FileUtils.getFileAndDirectoryNames(file, string, string2, bl2, bl3, true, false);
    }

    public static List<String> getDirectoryNames(File file, String string, String string2, boolean bl2) throws IOException {
        return FileUtils.getDirectoryNames(file, string, string2, bl2, true);
    }

    public static List<String> getDirectoryNames(File file, String string, String string2, boolean bl2, boolean bl3) throws IOException {
        return FileUtils.getFileAndDirectoryNames(file, string, string2, bl2, bl3, false, true);
    }

    public static List<String> getFileAndDirectoryNames(File file, String string, String string2, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws IOException {
        String[] stringArray;
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(file);
        if (string != null) {
            directoryScanner.setIncludes(StringUtils.split(string, ","));
        }
        if (string2 != null) {
            directoryScanner.setExcludes(StringUtils.split(string2, ","));
        }
        directoryScanner.setCaseSensitive(bl3);
        directoryScanner.scan();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (bl4) {
            for (String string3 : stringArray = directoryScanner.getIncludedFiles()) {
                if (bl2) {
                    arrayList.add(file + FS + string3);
                    continue;
                }
                arrayList.add(string3);
            }
        }
        if (bl5) {
            for (String string3 : stringArray = directoryScanner.getIncludedDirectories()) {
                if (bl2) {
                    arrayList.add(file + FS + string3);
                    continue;
                }
                arrayList.add(string3);
            }
        }
        return arrayList;
    }

    public static void copyDirectory(File file, File file2) throws IOException {
        FileUtils.copyDirectory(file, file2, "**", null);
    }

    public static void copyDirectory(File file, File file2, String string, String string2) throws IOException {
        if (!file.exists()) {
            return;
        }
        List<File> list = FileUtils.getFiles(file, string, string2);
        for (File file3 : list) {
            FileUtils.copyFileToDirectory(file3, file2);
        }
    }

    public static void copyDirectoryLayout(File file, File file2, String[] stringArray, String[] stringArray2) throws IOException {
        if (file == null) {
            throw new IOException("source directory can't be null.");
        }
        if (file2 == null) {
            throw new IOException("destination directory can't be null.");
        }
        if (file.equals(file2)) {
            throw new IOException("source and destination are the same directory.");
        }
        if (!file.exists()) {
            throw new IOException("Source directory doesn't exists (" + file.getAbsolutePath() + ").");
        }
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(file);
        if (stringArray != null && stringArray.length >= 1) {
            directoryScanner.setIncludes(stringArray);
        } else {
            directoryScanner.setIncludes(new String[]{"**"});
        }
        if (stringArray2 != null && stringArray2.length >= 1) {
            directoryScanner.setExcludes(stringArray2);
        }
        directoryScanner.addDefaultExcludes();
        directoryScanner.scan();
        List<String> list = Arrays.asList(directoryScanner.getIncludedDirectories());
        for (String string : list) {
            File file3 = new File(file, string);
            if (file3.equals(file)) continue;
            File file4 = new File(file2, string);
            file4.mkdirs();
        }
    }

    public static void copyDirectoryStructure(File file, File file2) throws IOException {
        FileUtils.copyDirectoryStructure(file, file2, file2, false);
    }

    public static void copyDirectoryStructureIfModified(File file, File file2) throws IOException {
        FileUtils.copyDirectoryStructure(file, file2, file2, true);
    }

    private static void copyDirectoryStructure(File file, File file2, File file3, boolean bl2) throws IOException {
        if (file == null) {
            throw new IOException("source directory can't be null.");
        }
        if (file2 == null) {
            throw new IOException("destination directory can't be null.");
        }
        if (file.equals(file2)) {
            throw new IOException("source and destination are the same directory.");
        }
        if (!file.exists()) {
            throw new IOException("Source directory doesn't exists (" + file.getAbsolutePath() + ").");
        }
        File[] fileArray = file.listFiles();
        String string = file.getAbsolutePath();
        for (File file4 : fileArray) {
            if (file4.equals(file3)) continue;
            String string2 = file4.getAbsolutePath();
            string2 = string2.substring(string.length() + 1);
            File file5 = new File(file2, string2);
            if (file4.isFile()) {
                file5 = file5.getParentFile();
                if (bl2) {
                    FileUtils.copyFileToDirectoryIfModified(file4, file5);
                    continue;
                }
                FileUtils.copyFileToDirectory(file4, file5);
                continue;
            }
            if (file4.isDirectory()) {
                if (!file5.exists() && !file5.mkdirs()) {
                    throw new IOException("Could not create destination directory '" + file5.getAbsolutePath() + "'.");
                }
                FileUtils.copyDirectoryStructure(file4, file5, file3, bl2);
                continue;
            }
            throw new IOException("Unknown file type: " + file4.getAbsolutePath());
        }
    }

    public static void rename(File file, File file2) throws IOException {
        if (file2.exists() && !file2.delete()) {
            throw new IOException("Failed to delete " + file2 + " while trying to rename " + file);
        }
        File file3 = file2.getParentFile();
        if (file3 != null && !file3.exists() && !file3.mkdirs()) {
            throw new IOException("Failed to create directory " + file3 + " while trying to rename " + file);
        }
        if (!file.renameTo(file2)) {
            FileUtils.copyFile(file, file2);
            if (!file.delete()) {
                throw new IOException("Failed to delete " + file + " while trying to rename it.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File createTempFile(String string, String string2, File file) {
        Random random;
        File file2 = null;
        String string3 = System.getProperty("java.io.tmpdir");
        if (file != null) {
            string3 = file.getPath();
        }
        DecimalFormat decimalFormat = new DecimalFormat("#####");
        SecureRandom secureRandom = new SecureRandom();
        long l2 = secureRandom.nextLong();
        Random random2 = random = new Random(l2 + Runtime.getRuntime().freeMemory());
        synchronized (random2) {
            while ((file2 = new File(string3, string + decimalFormat.format(Math.abs(random.nextInt())) + string2)).exists()) {
            }
        }
        return file2;
    }

    public static void copyFile(File file, File file2, String string, FilterWrapper[] filterWrapperArray) throws IOException {
        FileUtils.copyFile(file, file2, string, filterWrapperArray, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File file, File file2, String string, FilterWrapper[] filterWrapperArray, boolean bl2) throws IOException {
        block7: {
            block6: {
                if (filterWrapperArray == null || filterWrapperArray.length <= 0) break block6;
                BufferedReader bufferedReader = null;
                OutputStreamWriter outputStreamWriter = null;
                try {
                    Closeable closeable;
                    if (string == null || string.length() < 1) {
                        bufferedReader = new BufferedReader(new FileReader(file));
                        outputStreamWriter = new FileWriter(file2);
                    } else {
                        closeable = new FileInputStream(file);
                        FilterWrapper[] filterWrapperArray2 = new FileOutputStream(file2);
                        bufferedReader = new BufferedReader(new InputStreamReader((InputStream)closeable, string));
                        outputStreamWriter = new OutputStreamWriter((OutputStream)filterWrapperArray2, string);
                    }
                    closeable = bufferedReader;
                    for (FilterWrapper filterWrapper : filterWrapperArray) {
                        closeable = filterWrapper.getReader((Reader)closeable);
                    }
                    IOUtil.copy((Reader)closeable, (Writer)outputStreamWriter);
                    ((Writer)outputStreamWriter).close();
                    outputStreamWriter = null;
                    ((Reader)bufferedReader).close();
                    bufferedReader = null;
                }
                catch (Throwable throwable) {
                    IOUtil.close(bufferedReader);
                    IOUtil.close(outputStreamWriter);
                    throw throwable;
                }
                IOUtil.close(bufferedReader);
                IOUtil.close(outputStreamWriter);
                break block7;
            }
            if (file2.lastModified() < file.lastModified() || bl2) {
                FileUtils.copyFile(file, file2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> loadFile(File file) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = null;
        try {
            if (file.exists()) {
                bufferedReader = new BufferedReader(new FileReader(file));
                String string = bufferedReader.readLine();
                while (string != null) {
                    if (!(string = string.trim()).startsWith("#") && string.length() != 0) {
                        arrayList.add(string);
                    }
                    string = bufferedReader.readLine();
                }
                bufferedReader.close();
                bufferedReader = null;
            }
        }
        finally {
            IOUtil.close(bufferedReader);
        }
        return arrayList;
    }

    public static boolean isValidWindowsFileName(File file) {
        if (Os.isFamily("windows")) {
            if (StringUtils.indexOfAny(file.getName(), INVALID_CHARACTERS_FOR_WINDOWS_FILE_NAME) != -1) {
                return false;
            }
            File file2 = file.getParentFile();
            if (file2 != null) {
                return FileUtils.isValidWindowsFileName(file2);
            }
        }
        return true;
    }

    public static abstract class FilterWrapper {
        public abstract Reader getReader(Reader var1);
    }
}

